/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.enumeration.MountAction;
import io.github.qsy7.shell.api.enumeration.VFSType;
import io.github.qsy7.shell.api.model.MountCommand;
import io.github.qsy7.shell.api.model.MountPoint;
import io.github.qsy7.shell.api.service.MountService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.property.MountTimeout;
import io.github.qsy7.shell.impl.service.AbstractMultipleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;

public class DefaultMountService
extends AbstractMultipleShellCommandService<MountCommand>
implements MountService {
    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultMountService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=MountTimeout.class) int n) {
        void timeout;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n});
        DefaultMountService defaultMountService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        int n2 = n;
        super((ShellCommandBuilder)shellExecutionService2, (ShellExecutionService)timeout, n2);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBefore(MountCommand mountCommand) {
        void mountCommand2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBefore", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand3 = mountCommand;
        super.doBefore(mountCommand3);
        mountCommand3.setTimeout(mountCommand2.timeout);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBefore", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBeforeEach(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBeforeEach", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        if (MountAction.Mount.equals((Object)mountCommand2.getMountAction())) {
            void mountCommand3;
            mountCommand3.prepareDevice(mountCommand2.getMountPoint());
            mountCommand3.prepareTarget(mountCommand2.getMountPoint(), mountCommand2.getRootPath());
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBeforeEach", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareDevice(MountPoint mountPoint) {
        void mountPoint2;
        File file;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareDevice", (Object[])new Object[]{mountPoint});
        DefaultMountService defaultMountService = this;
        MountPoint mountPoint3 = mountPoint;
        if (!"none".equals(mountPoint3.getDevice()) && !(file = new File(mountPoint2.getDevice(mountPoint3.getDevice()))).exists()) {
            file.mkdirs();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareDevice", (Object[])new Object[]{mountPoint}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareTarget(MountPoint mountPoint, String string) {
        void rootPath;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareTarget", (Object[])new Object[]{mountPoint, string});
        DefaultMountService defaultMountService = this;
        MountPoint mountPoint2 = mountPoint;
        String string2 = string;
        File file = new File(string2 + rootPath.getMountPoint());
        if (!file.exists()) {
            file.mkdirs();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareTarget", (Object[])new Object[]{mountPoint, string}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String[] getCommandLines(MountCommand mountCommand) {
        String[] stringArray;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getCommandLines", (Object[])new Object[]{mountCommand});
        String[] stringArray2 = this;
        MountCommand mountCommand2 = mountCommand;
        if (MountAction.Unmount.equals((Object)mountCommand2.getMountAction())) {
            if (VFSType.RBIND.equals((Object)mountCommand2.getMountPoint().getVfsType())) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "umount -R " + mountCommand2.getRootPath() + mountCommand2.getMountPoint().getMountPoint();
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "umount " + mountCommand2.getRootPath() + mountCommand2.getMountPoint().getMountPoint();
            }
        } else if (MountAction.Mount.equals((Object)mountCommand2.getMountAction())) {
            void mountCommand3;
            void commandLines;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (List list : commandLines.getMountPoint().getVfsType().getArguments(commandLines.getMountPoint(), mountCommand3.getDevice(commandLines.getMountPoint().getDevice()), commandLines.getRootPath())) {
                arrayList.add(String.join((CharSequence)" ", list.toArray(new String[list.size()])));
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        } else {
            throw new IllegalArgumentException("Remounting is not currently supported.");
        }
        stringArray2 = stringArray;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getCommandLines", (Object[])new Object[]{mountCommand}, (Object)stringArray2, (long)l);
        return stringArray2;
    }

    protected String getDevice(String string) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getDevice", (Object[])new Object[]{string});
        Object object = this;
        String string2 = string;
        object = System.getProperty("~/") != null && !System.getProperty("~/").isEmpty() ? string2.replace("~/", System.getProperty("~/") + File.separator) : string2;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getDevice", (Object[])new Object[]{string}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doAfter(MountCommand mountCommand) {
        void mountCommand2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doAfter", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand3 = mountCommand;
        super.doAfter(mountCommand3);
        mountCommand2.ensureTmpfsIsGloballyReadableAndWritable(mountCommand3);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doAfter", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void ensureTmpfsIsGloballyReadableAndWritable(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritable", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        if (VFSType.TMPFS.equals((Object)mountCommand2.getMountPoint().getVfsType())) {
            void mountCommand3;
            mountCommand3.ensureTmpfsIsGloballyReadableAndWritableCli(mountCommand2);
            mountCommand3.ensureTmpfsIsGloballyReadableAndWritableNative(mountCommand2);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritable", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void ensureTmpfsIsGloballyReadableAndWritableNative(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableNative", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
        hashSet.add(PosixFilePermission.OWNER_READ);
        hashSet.add(PosixFilePermission.OWNER_WRITE);
        hashSet.add(PosixFilePermission.OWNER_EXECUTE);
        hashSet.add(PosixFilePermission.GROUP_READ);
        hashSet.add(PosixFilePermission.GROUP_WRITE);
        hashSet.add(PosixFilePermission.GROUP_EXECUTE);
        hashSet.add(PosixFilePermission.OTHERS_READ);
        hashSet.add(PosixFilePermission.OTHERS_WRITE);
        hashSet.add(PosixFilePermission.OTHERS_EXECUTE);
        try {
            void permissions;
            Files.setPosixFilePermissions(new File(permissions.getRootPath() + File.separator + permissions.getMountPoint().getMountPoint()).toPath(), hashSet);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error fixing permissions", iOException);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableNative", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    protected void ensureTmpfsIsGloballyReadableAndWritableCli(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableCli", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableCli", (Object[])new Object[]{mountCommand}, null, (long)l);
    }
}

