/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.enumeration.BatteryState;
import io.github.qsy7.shell.api.model.BatteryRequest;
import io.github.qsy7.shell.api.model.BatteryStatus;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.Node;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.api.service.UpowerService;
import io.github.qsy7.shell.impl.property.UpowerTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class DefaultUpowerService
extends AbstractSingleShellCommandService<BatteryRequest>
implements UpowerService {
    protected final Node node;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultUpowerService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, Node node, @Property(value=UpowerTimeout.class) int n) {
        void timeout;
        void node2;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, node, n});
        DefaultUpowerService defaultUpowerService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        Node node3 = node;
        int n2 = n;
        super((ShellCommandBuilder)shellExecutionService2, (ShellExecutionService)node2, n2);
        shellCommandBuilder2.node = timeout;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, node, n}, null, (long)l);
    }

    protected String getCommandLine() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"getCommandLine", (Object[])new Object[0]);
        Object object = this;
        object = "upower -i /org/freedesktop/UPower/devices/battery_BAT0";
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"getCommandLine", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doAfter(BatteryRequest batteryRequest) {
        void batteryRequest2;
        String percentage;
        void statePattern;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"doAfter", (Object[])new Object[]{batteryRequest});
        DefaultUpowerService defaultUpowerService = this;
        BatteryRequest batteryRequest3 = batteryRequest;
        Pattern pattern = Pattern.compile(".*(fully-charged|charging|discharging).*");
        Pattern pattern2 = Pattern.compile(".*percentage:[\\W]{1,}([\\d]{1,3})%.*");
        Object var8_7 = null;
        int n = -1;
        for (String string : ((CommandOutput)statePattern.getShellCommand().getOutputs().get(0)).getOutput().split("\n")) {
            void stateMatcher;
            void state;
            void percentagePattern;
            if (percentage != null && n > 0) break;
            Matcher matcher = percentagePattern.matcher(string);
            if (matcher.matches()) {
                percentage = matcher.group(1);
                continue;
            }
            Matcher matcher2 = state.matcher((CharSequence)stateMatcher);
            if (!matcher2.matches()) continue;
            n = Integer.valueOf(matcher2.group(1));
        }
        statePattern.setBatteryStatus(new BatteryStatus(batteryRequest2.node, LocalDateTime.now(), BatteryState.getFromUpowerString((String)percentage), Integer.valueOf(n).intValue(), statePattern.getShellCommand()));
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"doAfter", (Object[])new Object[]{batteryRequest}, null, (long)l);
    }
}

