package io.github.qsy7.shell.impl.provider;

import io.github.qsy7.infrastructure.inject.core.NodeId;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.Node;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;

@Singleton
public class NodeProvider implements Provider<Node> {
  // set from the command-line on start-up
  protected final String nodeId;
  protected final Node node;

  @Inject
  public NodeProvider(@Property(NodeId.class) String nodeId) {

    this.nodeId = nodeId;
    this.node = getNode();
  }

  protected Node getNode() {
    return new Node(nodeId);
  }

  //  @Singleton
  @Override
  public Node get() {
    return node;
  }
}
