/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.service.OutputCollector;
import io.github.qsy7.shell.impl.OutputCollectorConfiguration;
import io.github.qsy7.shell.impl.collector.InputConsumable;
import io.github.qsy7.shell.impl.collector.LoggerOutputCollector;
import io.github.qsy7.shell.impl.collector.ShellCommandOutputCollector;
import io.github.qsy7.timeout.TimeConstrainedMethodInvocation;
import io.github.qsy7.timeout.annotation.TimeConstrained;
import io.github.qsy7.timeout.impl.TimeConstrainedMethodCall;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public abstract class AbstractProcessExecution
implements TimeConstrainedMethodInvocation,
AutoCloseable {
    protected final ShellCommand shellCommand;
    protected final Thread inputThread;
    protected final Thread errorThread;
    protected final OutputStream outputStream;
    protected final boolean requiresExplicitExit;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long interruptGracePeriodValue;

    /*
     * WARNING - void declaration
     */
    protected AbstractProcessExecution(ShellCommand shellCommand, InputStream inputStream, InputStream inputStream2, OutputStream outputStream, boolean bl, ChronoUnit chronoUnit, long l) {
        void interruptGracePeriodValue;
        void interruptGracePeriodUnits;
        void requiresExplicitExit;
        void errorStream;
        void inputStream3;
        void outputStream2;
        void shellCommand2;
        long l2 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"<init>", (Object[])new Object[]{shellCommand, inputStream, inputStream2, outputStream, bl, chronoUnit, l});
        AbstractProcessExecution abstractProcessExecution = this;
        ShellCommand shellCommand3 = shellCommand;
        InputStream inputStream4 = inputStream;
        InputStream inputStream5 = inputStream2;
        OutputStream outputStream3 = outputStream;
        boolean bl2 = bl;
        ChronoUnit chronoUnit2 = chronoUnit;
        long l3 = l;
        abstractProcessExecution.shellCommand = shellCommand2;
        abstractProcessExecution.outputStream = outputStream2;
        abstractProcessExecution.inputThread = abstractProcessExecution.setupMonitoringThread((InputStream)inputStream3, false);
        abstractProcessExecution.errorThread = abstractProcessExecution.setupMonitoringThread((InputStream)errorStream, true);
        abstractProcessExecution.requiresExplicitExit = requiresExplicitExit;
        abstractProcessExecution.interruptGracePeriodUnits = interruptGracePeriodUnits;
        abstractProcessExecution.interruptGracePeriodValue = interruptGracePeriodValue;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"<init>", (Object[])new Object[]{shellCommand, inputStream, inputStream2, outputStream, bl, chronoUnit, l}, null, (long)l2);
    }

    /*
     * WARNING - void declaration
     */
    public Thread setupMonitoringThread(InputStream inputStream, boolean bl) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setupMonitoringThread", (Object[])new Object[]{inputStream, bl});
        AbstractProcessExecution abstractProcessExecution = this;
        InputStream inputStream2 = inputStream;
        boolean bl2 = bl;
        Object object = abstractProcessExecution;
        InputStream inputStream3 = inputStream2;
        boolean bl3 = bl2;
        try {
            void isError;
            void inputStream4;
            InputConsumable inputConsumable = new InputConsumable((InputStream)inputStream4, (boolean)isError, ((AbstractProcessExecution)object).getOutputCollectors());
            Thread inputConsumableThread = new Thread(inputConsumable);
            inputConsumableThread.start();
            object = inputConsumableThread;
            return object;
        }
        finally {
            inputStream3 = null;
        }
    }

    protected OutputCollector[] getOutputCollectors() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getOutputCollectors", (Object[])new Object[0]);
        OutputCollector[] outputCollectorArray = this;
        OutputCollector[] outputCollectorArray2 = outputCollectorArray;
        try {
            OutputCollectorConfiguration outputCollectorConfiguration = null;
            outputCollectorArray2 = outputCollectorConfiguration == null ? outputCollectorArray2.registerDefaultOutputCollectors() : outputCollectorArray2.registerConfiguredOutputCollectors(outputCollectorConfiguration);
        }
        catch (Throwable throwable) {
            outputCollectorArray2 = null;
        }
        Throwable throwable = null;
        if (throwable != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getOutputCollectors", (Object[])new Object[0], throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        outputCollectorArray = outputCollectorArray2;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getOutputCollectors", (Object[])new Object[0], (Object)outputCollectorArray, (long)l);
        return outputCollectorArray;
    }

    protected OutputCollector[] registerDefaultOutputCollectors() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"registerDefaultOutputCollectors", (Object[])new Object[0]);
        OutputCollector[] outputCollectorArray = this;
        OutputCollector[] outputCollectorArray2 = outputCollectorArray;
        try {
            outputCollectorArray2 = new OutputCollector[]{new ShellCommandOutputCollector(outputCollectorArray2.shellCommand), new LoggerOutputCollector(outputCollectorArray2.getClass(), outputCollectorArray2.shellCommand.getCommandLine())};
            return outputCollectorArray2;
        }
        finally {
            Object var5_4 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected OutputCollector[] registerConfiguredOutputCollectors(OutputCollectorConfiguration outputCollectorConfiguration) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"registerConfiguredOutputCollectors", (Object[])new Object[]{outputCollectorConfiguration});
        OutputCollector[] outputCollectorArray = this;
        OutputCollectorConfiguration outputCollectorConfiguration2 = outputCollectorConfiguration;
        OutputCollector[] outputCollectorArray2 = outputCollectorArray;
        OutputCollectorConfiguration outputCollectorConfiguration3 = outputCollectorConfiguration2;
        try {
            void outputCollectorConfiguration4;
            OutputCollector[] outputCollectors = new OutputCollector[outputCollectorConfiguration4.getOutputCollectorClasses().size()];
            int i = 0;
            for (Class<? extends OutputCollector> outputCollectorClass : outputCollectorConfiguration4.getOutputCollectorClasses()) {
                outputCollectors[i++] = (OutputCollector)ApplicationHelper.getApplicationInstance().getInjector().getInstance(outputCollectorClass, new AnnotationLiteral[0]);
            }
            outputCollectorArray2 = outputCollectors;
            return outputCollectorArray2;
        }
        finally {
            outputCollectorConfiguration3 = null;
        }
    }

    protected void setTimeout() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setTimeout", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        try {
            int timeout = abstractProcessExecution2.getTimeout();
            if (abstractProcessExecution2.getTimeout() > 0) {
                abstractProcessExecution2.doSetTimeout(timeout);
            }
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setTimeout", (Object[])new Object[0], (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setTimeout", (Object[])new Object[0], null, (long)l);
    }

    protected abstract void doSetTimeout(int var1) throws Exception;

    protected abstract int getTimeout();

    protected abstract int getReturnCode() throws InterruptedException;

    protected void kill(Exception exception) throws IOException, InterruptedException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"kill", (Object[])new Object[]{exception});
        AbstractProcessExecution abstractProcessExecution = this;
        Exception exception2 = exception;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        Exception exception3 = exception2;
        try {
            abstractProcessExecution2.outputStream.write(3);
            abstractProcessExecution2.outputStream.flush();
            Thread.sleep(1000L);
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"kill", (Object[])new Object[]{exception2}, (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"kill", (Object[])new Object[]{exception}, null, (long)l);
    }

    @TimeConstrained
    public void run() throws IOException, InterruptedException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"run", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        try {
            Object object;
            TimeConstrainedMethodCall timeConstrainedMethodCall;
            TimeConstrainedMethodInvocation timeConstrainedMethodInvocation = abstractProcessExecution2;
            if (timeConstrainedMethodInvocation.getAllowedExecutionDuration() == null) {
                timeConstrainedMethodCall = null;
            } else {
                object = timeConstrainedMethodInvocation.getAllowedExecutionDuration();
                timeConstrainedMethodCall = new TimeConstrainedMethodCall((Duration)object);
            }
            timeConstrainedMethodInvocation = timeConstrainedMethodCall;
            object = abstractProcessExecution2;
            ((AbstractProcessExecution)object).doRun();
            ((AbstractProcessExecution)object).setReturnCode();
            ((AbstractProcessExecution)object).syncInputs();
            if (timeConstrainedMethodInvocation != null) {
                timeConstrainedMethodInvocation.cancelInterruption();
            }
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"run", (Object[])new Object[0], (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"run", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"close", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        try {
            abstractProcessExecution2.inputThread.interrupt();
            abstractProcessExecution2.errorThread.interrupt();
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"close", (Object[])new Object[0], (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    public Duration getAllowedExecutionDuration() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getAllowedExecutionDuration", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        Object object = abstractProcessExecution;
        try {
            object = Duration.of(((AbstractProcessExecution)object).getTimeout(), ChronoUnit.SECONDS);
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    protected void doRun() throws IOException, InterruptedException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"doRun", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        try {
            try {
                abstractProcessExecution2.setTimeout();
                if (abstractProcessExecution2.requiresExplicitExit) {
                    abstractProcessExecution2.exitAfterCompletionOfCommand();
                }
            }
            catch (IOException e) {
                if (abstractProcessExecution2.exitedButNotCleanly(e)) {
                    abstractProcessExecution2.kill(e);
                }
            }
            catch (Exception e) {
                abstractProcessExecution2.kill(e);
            }
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"doRun", (Object[])new Object[0], (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"doRun", (Object[])new Object[0], null, (long)l);
    }

    protected void exitAfterCompletionOfCommand() throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitAfterCompletionOfCommand", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        try {
            abstractProcessExecution2.outputStream.write("\nexit\n".getBytes(Charset.defaultCharset()));
            abstractProcessExecution2.outputStream.flush();
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitAfterCompletionOfCommand", (Object[])new Object[0], (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitAfterCompletionOfCommand", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean exitedButNotCleanly(Exception exception) {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitedButNotCleanly", (Object[])new Object[]{exception});
        AbstractProcessExecution abstractProcessExecution = this;
        Exception exception2 = exception;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        Exception exception3 = exception2;
        try {
            void e;
            bl = !e.getMessage().contains("Stream closed") && !e.getMessage().contains("Broken pipe");
        }
        catch (Throwable throwable) {
            bl = false;
        }
        exception3 = null;
        if (exception3 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitedButNotCleanly", (Object[])new Object[]{exception2}, (Throwable)exception3);
        }
        if (exception3 != null) {
            throw exception3;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitedButNotCleanly", (Object[])new Object[]{exception}, (Object)bl2, (long)l);
        return bl2;
    }

    protected void setReturnCode() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setReturnCode", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        try {
            try {
                abstractProcessExecution2.shellCommand.setReturnCode(abstractProcessExecution2.getReturnCode());
            }
            catch (Exception e) {
                abstractProcessExecution2.shellCommand.setReturnCode(-1);
            }
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setReturnCode", (Object[])new Object[0], (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setReturnCode", (Object[])new Object[0], null, (long)l);
    }

    protected void syncInputs() throws InterruptedException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"syncInputs", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        AbstractProcessExecution abstractProcessExecution2 = abstractProcessExecution;
        try {
            abstractProcessExecution2.inputThread.join();
            abstractProcessExecution2.errorThread.join();
            abstractProcessExecution2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractProcessExecution2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"syncInputs", (Object[])new Object[0], (Throwable)((Object)abstractProcessExecution2));
        }
        if (abstractProcessExecution2 != null) {
            throw abstractProcessExecution2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"syncInputs", (Object[])new Object[0], null, (long)l);
    }
}

