/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.ssh.service;

import io.github.qsy7.interruptable.Interruptable;
import io.github.qsy7.interruptable.annotation.InterruptableService;
import io.github.qsy7.interruptable.aspects.InterruptableServiceAspect;
import io.github.qsy7.logging.aspects.AfterThrowingAspect;
import io.github.qsy7.logging.aspects.DebugMethodLoggerAspect;
import io.github.qsy7.logging.aspects.InfoMethodLoggerAspect;
import io.github.qsy7.property.impl.annotation.Property;
import io.github.qsy7.ssh.api.SSHCommandService;
import io.github.qsy7.ssh.api.SSHPublicKeyPath;
import io.github.qsy7.ssh.api.model.command.SSHCommand;
import io.github.qsy7.ssh.api.model.command.SSHExpectCommand;
import io.github.qsy7.ssh.executor.DefaultSSHCommandExecutor;
import io.github.qsy7.ssh.executor.ExpectSSHCommandExecutor;
import io.github.qsy7.ssh.property.InterruptGracePeriodUnits;
import io.github.qsy7.ssh.property.InterruptGracePeriodValue;
import io.github.qsy7.ssh.service.DefaultSSHCommandService$AjcClosure1;
import io.github.qsy7.ssh.service.DefaultSSHCommandService$AjcClosure11;
import io.github.qsy7.ssh.service.DefaultSSHCommandService$AjcClosure3;
import io.github.qsy7.ssh.service.DefaultSSHCommandService$AjcClosure5;
import io.github.qsy7.ssh.service.DefaultSSHCommandService$AjcClosure7;
import io.github.qsy7.ssh.service.DefaultSSHCommandService$AjcClosure9;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@InterruptableService
public class DefaultSSHCommandService
implements SSHCommandService,
Interruptable {
    protected final String sshPublicKeyPath;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long interruptGracePeriodValue;
    protected boolean shutdown;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Inject
    public DefaultSSHCommandService(@Property(value=SSHPublicKeyPath.class) String sshPublicKeyPath, @Property(value=InterruptGracePeriodUnits.class) ChronoUnit interruptGracePeriodUnits, @Property(value=InterruptGracePeriodValue.class) long interruptGracePeriodValue) {
        String string = sshPublicKeyPath;
        ChronoUnit chronoUnit = interruptGracePeriodUnits;
        long l = interruptGracePeriodValue;
        Object[] objectArray = new Object[]{string, chronoUnit, Conversions.longObject((long)l)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        InterruptableServiceAspect.aspectOf().doInterruptableService(joinPoint);
        this.shutdown = false;
        this.sshPublicKeyPath = sshPublicKeyPath;
        this.interruptGracePeriodUnits = interruptGracePeriodUnits;
        this.interruptGracePeriodValue = interruptGracePeriodValue;
    }

    public void execute(SSHCommand ... commands) throws Exception {
        SSHCommand[] sSHCommandArray = commands;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)sSHCommandArray);
        try {
            Object[] objectArray = new Object[]{this, sSHCommandArray, joinPoint};
            DefaultSSHCommandService$AjcClosure1 defaultSSHCommandService$AjcClosure1 = new DefaultSSHCommandService$AjcClosure1(objectArray);
            InfoMethodLoggerAspect.aspectOf().doPublicAround(defaultSSHCommandService$AjcClosure1.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void execute(SSHCommand command) throws Exception {
        SSHCommand sSHCommand = command;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)sSHCommand);
        try {
            Object[] objectArray = new Object[]{this, sSHCommand, joinPoint};
            DefaultSSHCommandService$AjcClosure3 defaultSSHCommandService$AjcClosure3 = new DefaultSSHCommandService$AjcClosure3(objectArray);
            DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultSSHCommandService$AjcClosure3.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void execute(SSHExpectCommand ... commands) throws Exception {
        SSHExpectCommand[] sSHExpectCommandArray = commands;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)sSHExpectCommandArray);
        try {
            Object[] objectArray = new Object[]{this, sSHExpectCommandArray, joinPoint};
            DefaultSSHCommandService$AjcClosure5 defaultSSHCommandService$AjcClosure5 = new DefaultSSHCommandService$AjcClosure5(objectArray);
            InfoMethodLoggerAspect.aspectOf().doPublicAround(defaultSSHCommandService$AjcClosure5.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void execute(SSHExpectCommand command) throws Exception {
        SSHExpectCommand sSHExpectCommand = command;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)sSHExpectCommand);
        try {
            Object[] objectArray = new Object[]{this, sSHExpectCommand, joinPoint};
            DefaultSSHCommandService$AjcClosure7 defaultSSHCommandService$AjcClosure7 = new DefaultSSHCommandService$AjcClosure7(objectArray);
            DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultSSHCommandService$AjcClosure7.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void checkIfShutdown() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            Object[] objectArray = new Object[]{this, joinPoint};
            DefaultSSHCommandService$AjcClosure9 defaultSSHCommandService$AjcClosure9 = new DefaultSSHCommandService$AjcClosure9(objectArray);
            DebugMethodLoggerAspect.aspectOf().doProtectedAround(defaultSSHCommandService$AjcClosure9.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void interrupt() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            Object[] objectArray = new Object[]{this, joinPoint};
            DefaultSSHCommandService$AjcClosure11 defaultSSHCommandService$AjcClosure11 = new DefaultSSHCommandService$AjcClosure11(objectArray);
            InfoMethodLoggerAspect.aspectOf().doPublicAround(defaultSSHCommandService$AjcClosure11.linkClosureAndJoinPoint(69648));
            return;
        }
        catch (Throwable throwable) {
            AfterThrowingAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static {
        DefaultSSHCommandService.ajc$preClinit();
    }

    static final /* synthetic */ void execute_aroundBody0(DefaultSSHCommandService ajc$this, SSHCommand[] commands, JoinPoint joinPoint) {
        for (SSHCommand command : commands) {
            ajc$this.execute(command);
        }
    }

    static final /* synthetic */ void execute_aroundBody2(DefaultSSHCommandService ajc$this, SSHCommand command, JoinPoint joinPoint) {
        ajc$this.checkIfShutdown();
        new DefaultSSHCommandExecutor(ajc$this.sshPublicKeyPath, command, ajc$this.interruptGracePeriodUnits, ajc$this.interruptGracePeriodValue).execute();
    }

    static final /* synthetic */ void execute_aroundBody4(DefaultSSHCommandService ajc$this, SSHExpectCommand[] commands, JoinPoint joinPoint) {
        for (SSHExpectCommand command : commands) {
            ajc$this.execute(command);
        }
    }

    static final /* synthetic */ void execute_aroundBody6(DefaultSSHCommandService ajc$this, SSHExpectCommand command, JoinPoint joinPoint) {
        ajc$this.checkIfShutdown();
        new ExpectSSHCommandExecutor(ajc$this.sshPublicKeyPath, command).execute();
    }

    static final /* synthetic */ void checkIfShutdown_aroundBody8(DefaultSSHCommandService ajc$this, JoinPoint joinPoint) {
        if (ajc$this.shutdown) {
            throw new IllegalStateException("Unable to run new commands as the system is shutting down.");
        }
    }

    static final /* synthetic */ void interrupt_aroundBody10(DefaultSSHCommandService ajc$this, JoinPoint joinPoint) {
        ajc$this.shutdown = true;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultSSHCommandService.java", DefaultSSHCommandService.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "io.github.qsy7.ssh.service.DefaultSSHCommandService", "java.lang.String:java.time.temporal.ChronoUnit:long", "sshPublicKeyPath:interruptGracePeriodUnits:interruptGracePeriodValue", ""), 23);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "execute", "io.github.qsy7.ssh.service.DefaultSSHCommandService", "[Lio.github.qsy7.ssh.api.model.command.SSHCommand;", "commands", "java.lang.Exception", "void"), 38);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "execute", "io.github.qsy7.ssh.service.DefaultSSHCommandService", "io.github.qsy7.ssh.api.model.command.SSHCommand", "command", "java.lang.Exception", "void"), 42);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "execute", "io.github.qsy7.ssh.service.DefaultSSHCommandService", "[Lio.github.qsy7.ssh.api.model.command.SSHExpectCommand;", "commands", "java.lang.Exception", "void"), 49);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "execute", "io.github.qsy7.ssh.service.DefaultSSHCommandService", "io.github.qsy7.ssh.api.model.command.SSHExpectCommand", "command", "java.lang.Exception", "void"), 53);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkIfShutdown", "io.github.qsy7.ssh.service.DefaultSSHCommandService", "", "", "", "void"), 58);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "interrupt", "io.github.qsy7.ssh.service.DefaultSSHCommandService", "", "", "", "void"), 64);
    }
}

