/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.ssh.service;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.ssh.api.SSHCommandService;
import io.github.qsy7.ssh.api.SSHPublicKeyPath;
import io.github.qsy7.ssh.api.model.command.SSHCommand;
import io.github.qsy7.ssh.api.model.command.SSHExpectCommand;
import io.github.qsy7.ssh.executor.DefaultSSHCommandExecutor;
import io.github.qsy7.ssh.executor.ExpectSSHCommandExecutor;
import io.github.qsy7.ssh.property.InterruptGracePeriodUnits;
import io.github.qsy7.ssh.property.InterruptGracePeriodValue;
import jakarta.inject.Inject;
import java.time.temporal.ChronoUnit;

public class DefaultSSHCommandService
implements SSHCommandService,
AutoCloseable {
    protected final String sshPublicKeyPath;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long interruptGracePeriodValue;
    protected boolean shutdown;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultSSHCommandService(@Property(value=SSHPublicKeyPath.class) String string, @Property(value=InterruptGracePeriodUnits.class) ChronoUnit chronoUnit, @Property(value=InterruptGracePeriodValue.class) long l) {
        void interruptGracePeriodValue;
        void interruptGracePeriodUnits;
        void sshPublicKeyPath;
        DefaultSSHCommandService defaultSSHCommandService = this;
        String string2 = string;
        ChronoUnit chronoUnit2 = chronoUnit;
        long l2 = l;
        long l3 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"<init>", (Object[])new Object[]{string2, chronoUnit2, l2});
        DefaultSSHCommandService defaultSSHCommandService2 = defaultSSHCommandService;
        String string3 = string2;
        ChronoUnit chronoUnit3 = chronoUnit2;
        long l4 = l2;
        defaultSSHCommandService2.shutdown = false;
        defaultSSHCommandService2.sshPublicKeyPath = sshPublicKeyPath;
        defaultSSHCommandService2.interruptGracePeriodUnits = interruptGracePeriodUnits;
        defaultSSHCommandService2.interruptGracePeriodValue = interruptGracePeriodValue;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"<init>", (Object[])new Object[]{string2, chronoUnit2, l2}, null, (long)l3);
        CloseableUtil.addAutoCloseable((AutoCloseable)this);
    }

    /*
     * WARNING - void declaration
     */
    public void execute(SSHCommand ... sSHCommandArray) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommandArray});
        DefaultSSHCommandService defaultSSHCommandService = this;
        SSHCommand[] sSHCommandArray2 = sSHCommandArray;
        DefaultSSHCommandService defaultSSHCommandService2 = defaultSSHCommandService;
        SSHCommand[] sSHCommandArray3 = sSHCommandArray2;
        try {
            void commands;
            for (void command : commands) {
                defaultSSHCommandService2.execute((SSHCommand)command);
            }
            defaultSSHCommandService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultSSHCommandService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommandArray2}, (Throwable)((Object)defaultSSHCommandService2));
        }
        if (defaultSSHCommandService2 != null) {
            throw defaultSSHCommandService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommandArray}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(SSHCommand sSHCommand) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommand});
        DefaultSSHCommandService defaultSSHCommandService = this;
        SSHCommand sSHCommand2 = sSHCommand;
        DefaultSSHCommandService defaultSSHCommandService2 = defaultSSHCommandService;
        SSHCommand sSHCommand3 = sSHCommand2;
        try {
            void command;
            defaultSSHCommandService2.checkIfShutdown();
            new DefaultSSHCommandExecutor(defaultSSHCommandService2.sshPublicKeyPath, (SSHCommand)command, defaultSSHCommandService2.interruptGracePeriodUnits, defaultSSHCommandService2.interruptGracePeriodValue).execute();
            defaultSSHCommandService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultSSHCommandService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommand2}, (Throwable)((Object)defaultSSHCommandService2));
        }
        if (defaultSSHCommandService2 != null) {
            throw defaultSSHCommandService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void execute(SSHExpectCommand ... sSHExpectCommandArray) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommandArray});
        DefaultSSHCommandService defaultSSHCommandService = this;
        SSHExpectCommand[] sSHExpectCommandArray2 = sSHExpectCommandArray;
        DefaultSSHCommandService defaultSSHCommandService2 = defaultSSHCommandService;
        SSHExpectCommand[] sSHExpectCommandArray3 = sSHExpectCommandArray2;
        try {
            void commands;
            for (void command : commands) {
                defaultSSHCommandService2.execute((SSHExpectCommand)command);
            }
            defaultSSHCommandService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultSSHCommandService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommandArray2}, (Throwable)((Object)defaultSSHCommandService2));
        }
        if (defaultSSHCommandService2 != null) {
            throw defaultSSHCommandService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommandArray}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(SSHExpectCommand sSHExpectCommand) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommand});
        DefaultSSHCommandService defaultSSHCommandService = this;
        SSHExpectCommand sSHExpectCommand2 = sSHExpectCommand;
        DefaultSSHCommandService defaultSSHCommandService2 = defaultSSHCommandService;
        SSHExpectCommand sSHExpectCommand3 = sSHExpectCommand2;
        try {
            void command;
            defaultSSHCommandService2.checkIfShutdown();
            new ExpectSSHCommandExecutor(defaultSSHCommandService2.sshPublicKeyPath, (SSHExpectCommand)command).execute();
            defaultSSHCommandService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultSSHCommandService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommand2}, (Throwable)((Object)defaultSSHCommandService2));
        }
        if (defaultSSHCommandService2 != null) {
            throw defaultSSHCommandService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"execute", (Object[])new Object[]{sSHExpectCommand}, null, (long)l);
    }

    protected void checkIfShutdown() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"checkIfShutdown", (Object[])new Object[0]);
        DefaultSSHCommandService defaultSSHCommandService = this;
        DefaultSSHCommandService defaultSSHCommandService2 = defaultSSHCommandService;
        try {
            if (defaultSSHCommandService2.shutdown) {
                throw new IllegalStateException("Unable to run new commands as the system is shutting down.");
            }
            defaultSSHCommandService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultSSHCommandService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"checkIfShutdown", (Object[])new Object[0], (Throwable)((Object)defaultSSHCommandService2));
        }
        if (defaultSSHCommandService2 != null) {
            throw defaultSSHCommandService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"checkIfShutdown", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"close", (Object[])new Object[0]);
        DefaultSSHCommandService defaultSSHCommandService = this;
        DefaultSSHCommandService defaultSSHCommandService2 = defaultSSHCommandService;
        try {
            defaultSSHCommandService2.shutdown = true;
            defaultSSHCommandService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultSSHCommandService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"close", (Object[])new Object[0], (Throwable)((Object)defaultSSHCommandService2));
        }
        if (defaultSSHCommandService2 != null) {
            throw defaultSSHCommandService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.ssh.service.DefaultSSHCommandService", (String)"close", (Object[])new Object[0], null, (long)l);
    }
}

