package io.github.robin.code.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;

import io.github.robin.code.constant.BaseConstant;
import io.github.robin.code.constant.DateTimeConstant;
import static io.github.robin.code.constant.DateTimeConstant.DEFAULT_DATE_TIME_PATTERN;

public class DateTimeUtil {

    /**
     * curren datetime remove milliseconds
     * 当前时间，舍去秒小数部分，防止四舍五入进位.
     */
    public static LocalDateTime currentDateTime() {
        return LocalDateTime.now()
            .truncatedTo(ChronoUnit.SECONDS);
    }

    public static LocalDateTime parse(String dateTime) {
        if (StringUtils.isBlank(dateTime)) {
            return null;
        }
        return LocalDateTime.parse(dateTime, DateTimeConstant.DATE_TIME_FORMATTER);
    }

    public static String toDateTimeString(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return BaseConstant.EMPTY;
        }
        return localDateTime.format(DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_PATTERN));
    }

    @Deprecated
    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime())
            .atZone(ZoneId.systemDefault())
            .toLocalDateTime();
    }

    @Deprecated
    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault())
            .toInstant());
    }
}
