/*
 * Decompiled with CFR 0.152.
 */
package io.secidea.security;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

final class CommandLine {
    private final Vector<Argument> arguments = new Vector();
    private final String executable;
    private Map<String, ?> substitutionMap;

    public static CommandLine parse(String line) {
        return CommandLine.parse(line, null);
    }

    static CommandLine parse(String line, Map<String, ?> substitutionMap) {
        if (line == null) {
            throw new IllegalArgumentException("Command line can not be null");
        }
        if (line.trim().isEmpty()) {
            throw new IllegalArgumentException("Command line can not be empty");
        }
        String[] tmp = CommandLine.translateCommandline(line);
        CommandLine cl = new CommandLine(tmp[0]);
        cl.setSubstitutionMap(substitutionMap);
        for (int i = 1; i < tmp.length; ++i) {
            cl.addArgument(tmp[i]);
        }
        return cl;
    }

    CommandLine(String executable) {
        this.executable = this.toCleanExecutable(executable);
    }

    String getExecutable() {
        return StringUtils.fixFileSeparatorChar(this.expandArgument(this.executable));
    }

    CommandLine addArgument(String argument) {
        return this.addArgument(argument, true);
    }

    CommandLine addArgument(String argument, boolean handleQuoting) {
        if (argument == null) {
            return this;
        }
        if (handleQuoting) {
            StringUtils.quoteArgument(argument);
        }
        this.arguments.add(new Argument(argument, handleQuoting));
        return this;
    }

    String[] getArguments() {
        String[] result = new String[this.arguments.size()];
        for (int i = 0; i < result.length; ++i) {
            Argument currArgument = this.arguments.get(i);
            String expandedArgument = this.expandArgument(currArgument.getValue());
            result[i] = currArgument.isHandleQuoting() ? StringUtils.quoteArgument(expandedArgument) : expandedArgument;
        }
        return result;
    }

    Map<String, ?> getSubstitutionMap() {
        return this.substitutionMap;
    }

    void setSubstitutionMap(Map<String, ?> substitutionMap) {
        this.substitutionMap = substitutionMap;
    }

    String[] toStrings() {
        String[] result = new String[this.arguments.size() + 1];
        result[0] = this.getExecutable();
        System.arraycopy(this.getArguments(), 0, result, 1, result.length - 1);
        return result;
    }

    public String toString() {
        return "[" + StringUtils.toString(this.toStrings(), ", ") + "]";
    }

    private String expandArgument(String argument) {
        StringBuffer stringBuffer = StringUtils.stringSubstitution(argument, this.getSubstitutionMap(), true);
        return stringBuffer.toString();
    }

    private static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int inComment = 3;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block5: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 3: {
                    continue block5;
                }
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block5;
                    }
                    current.append(nextTok);
                    continue block5;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block5;
                    }
                    current.append(nextTok);
                    continue block5;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else if ("#".equals(nextTok)) {
                state = 3;
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    private String toCleanExecutable(String dirtyExecutable) {
        if (dirtyExecutable == null) {
            throw new IllegalArgumentException("Executable can not be null");
        }
        if (dirtyExecutable.trim().isEmpty()) {
            throw new IllegalArgumentException("Executable can not be empty");
        }
        return StringUtils.fixFileSeparatorChar(dirtyExecutable);
    }

    private static class StringUtils {
        private static final String SINGLE_QUOTE = "'";
        private static final String DOUBLE_QUOTE = "\"";
        private static final char SLASH_CHAR = '/';
        private static final char BACKSLASH_CHAR = '\\';

        private StringUtils() {
        }

        static StringBuffer stringSubstitution(String argStr, Map<? super String, ?> vars, boolean isLenient) {
            StringBuffer argBuf = new StringBuffer();
            if (argStr == null || argStr.isEmpty()) {
                return argBuf;
            }
            if (vars == null || vars.isEmpty()) {
                return argBuf.append(argStr);
            }
            int argStrLength = argStr.length();
            int cIdx = 0;
            block3: while (cIdx < argStrLength) {
                char ch = argStr.charAt(cIdx);
                int del = 32;
                switch (ch) {
                    case '$': {
                        StringBuilder nameBuf = new StringBuilder();
                        del = argStr.charAt(cIdx + 1);
                        if (del == 123) {
                            ++cIdx;
                            ++cIdx;
                            while (cIdx < argStr.length() && ((ch = argStr.charAt(cIdx)) == '_' || ch == '.' || ch == '-' || ch == '+' || Character.isLetterOrDigit(ch))) {
                                nameBuf.append(ch);
                                ++cIdx;
                            }
                            if (nameBuf.length() >= 0) {
                                String value;
                                Object temp = vars.get(nameBuf.toString());
                                if (temp instanceof File) {
                                    value = StringUtils.fixFileSeparatorChar(((File)temp).getAbsolutePath());
                                } else {
                                    String string = value = temp != null ? temp.toString() : null;
                                }
                                if (value != null) {
                                    argBuf.append(value);
                                } else {
                                    if (!isLenient) {
                                        throw new RuntimeException("No value found for : " + nameBuf);
                                    }
                                    argBuf.append("${").append(nameBuf.toString()).append("}");
                                }
                                del = argStr.charAt(cIdx);
                                if (del != 125) {
                                    throw new RuntimeException("Delimiter not found for : " + nameBuf);
                                }
                            }
                            ++cIdx;
                            continue block3;
                        }
                        argBuf.append(ch);
                        ++cIdx;
                        continue block3;
                    }
                }
                argBuf.append(ch);
                ++cIdx;
            }
            return argBuf;
        }

        static String fixFileSeparatorChar(String arg) {
            return arg.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }

        static String toString(String[] strings, String separator) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < strings.length; ++i) {
                if (i > 0) {
                    sb.append(separator);
                }
                sb.append(strings[i]);
            }
            return sb.toString();
        }

        static String quoteArgument(String argument) {
            String cleanedArgument = argument.trim();
            while (cleanedArgument.startsWith(SINGLE_QUOTE) || cleanedArgument.startsWith(DOUBLE_QUOTE)) {
                cleanedArgument = cleanedArgument.substring(1);
            }
            while (cleanedArgument.endsWith(SINGLE_QUOTE) || cleanedArgument.endsWith(DOUBLE_QUOTE)) {
                cleanedArgument = cleanedArgument.substring(0, cleanedArgument.length() - 1);
            }
            StringBuilder buf = new StringBuilder();
            if (cleanedArgument.indexOf(DOUBLE_QUOTE) > -1) {
                if (cleanedArgument.indexOf(SINGLE_QUOTE) > -1) {
                    throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
                }
                return buf.append(SINGLE_QUOTE).append(cleanedArgument).append(SINGLE_QUOTE).toString();
            }
            if (cleanedArgument.indexOf(SINGLE_QUOTE) > -1 || cleanedArgument.indexOf(" ") > -1) {
                return buf.append(DOUBLE_QUOTE).append(cleanedArgument).append(DOUBLE_QUOTE).toString();
            }
            return cleanedArgument;
        }
    }

    static class Argument {
        private final String value;
        private final boolean handleQuoting;

        private Argument(String value, boolean handleQuoting) {
            this.value = value.trim();
            this.handleQuoting = handleQuoting;
        }

        private String getValue() {
            return this.value;
        }

        private boolean isHandleQuoting() {
            return this.handleQuoting;
        }
    }
}

