/*
 * Decompiled with CFR 0.152.
 */
package io.secidea.security.jakarta;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public final class PathValidator {
    private static final List<PathNormalizer> pathValidators = Collections.unmodifiableList(Arrays.asList(new ApacheFilenameUtilsPathNormalizer(), new UriPathNormalizer()));
    private static final String unsafePathMessage = "unsafe forward destination specified";
    private static final List<String> unsafeDestinations = Collections.unmodifiableList(Arrays.asList("WEB-INF/web.xml", "WEB-INF/classes/", "WEB-INF/lib/"));

    public static String validateDispatcherPath(String path) {
        if (path == null) {
            return null;
        }
        String unixPath = path.replace('\\', '/');
        if (unixPath.indexOf(0) != -1) {
            throw new SecurityException(unsafePathMessage);
        }
        for (PathNormalizer pathValidator : pathValidators) {
            String normalizedPath = pathValidator.normalizeOrNull(unixPath);
            if (normalizedPath == null) continue;
            PathValidator.runCheckOn(normalizedPath);
            return path;
        }
        return path;
    }

    private static void runCheckOn(String normalizedPath) {
        for (String unsafeDestination : unsafeDestinations) {
            if (!normalizedPath.contains(unsafeDestination)) continue;
            throw new SecurityException(unsafePathMessage);
        }
    }

    private static class UriPathNormalizer
    implements PathNormalizer {
        private UriPathNormalizer() {
        }

        @Override
        public String normalizeOrNull(String path) {
            try {
                URI uri = new URI(path);
                uri = uri.normalize();
                return uri.getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
    }

    private static class ApacheFilenameUtilsPathNormalizer
    implements PathNormalizer {
        private ApacheFilenameUtilsPathNormalizer() {
        }

        @Override
        public String normalizeOrNull(String path) {
            return FilenameUtils.normalize((String)path, (boolean)true);
        }
    }

    private static interface PathNormalizer {
        public String normalizeOrNull(String var1);
    }
}

