/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid.resourcepack.api.material;

import io.github.solid.resourcepack.api.material.MaterialType;
import io.github.solid.resourcepack.material.SolidBlockMaterial;
import io.github.solid.resourcepack.material.SolidItemMaterial;
import io.github.solid.resourcepack.material.SolidMaterial;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/github/solid/resourcepack/api/material/SolidMaterialMapper;", "", "()V", "from", "Lio/github/solid/resourcepack/material/SolidMaterial;", "material", "Lorg/bukkit/Material;", "type", "Lio/github/solid/resourcepack/api/material/MaterialType;", "solid-api"})
public final class SolidMaterialMapper {
    @NotNull
    public static final SolidMaterialMapper INSTANCE = new SolidMaterialMapper();

    private SolidMaterialMapper() {
    }

    @ApiStatus.Experimental
    @NotNull
    public final SolidMaterial from(@NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        if (material.isItem()) {
            return SolidItemMaterial.valueOf((String)material.name()).toGeneric();
        }
        if (material.isBlock()) {
            return SolidBlockMaterial.valueOf((String)material.name()).toGeneric();
        }
        throw new IllegalArgumentException("Material " + material + " is not supported");
    }

    @NotNull
    public final SolidMaterial from(@NotNull Material material, @NotNull MaterialType type) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List returned = new ArrayList();
        if (type == MaterialType.ITEM || type == MaterialType.BOTH) {
            try {
                returned.add(SolidItemMaterial.valueOf((String)material.name()).toGeneric());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (type == MaterialType.BLOCK || type == MaterialType.BOTH) {
            try {
                returned.add(SolidBlockMaterial.valueOf((String)material.name()).toGeneric());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (returned.size() != 1) {
            throw new IllegalArgumentException("Material " + material + " is not supported");
        }
        return (SolidMaterial)CollectionsKt.first((List)returned);
    }
}

