/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid.resourcepack.api.util;

import java.lang.reflect.Type;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lio/github/solid/resourcepack/api/util/GenericEnumSerializer;", "Lorg/spongepowered/configurate/serialize/TypeSerializer;", "", "()V", "deserialize", "type", "Ljava/lang/reflect/Type;", "node", "Lorg/spongepowered/configurate/ConfigurationNode;", "serialize", "", "obj", "solid-api"})
public final class GenericEnumSerializer
implements TypeSerializer<Enum<?>> {
    @NotNull
    public static final GenericEnumSerializer INSTANCE = new GenericEnumSerializer();

    private GenericEnumSerializer() {
    }

    @NotNull
    public Enum<?> deserialize(@NotNull Type type, @NotNull ConfigurationNode node) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getString();
        if (string == null) {
            throw new SerializationException("No value present in node");
        }
        String value = string;
        if (!(type instanceof Class) || !((Class)type).isEnum()) {
            throw new SerializationException("Type is not an enum class");
        }
        try {
            Class clazz = (Class)type;
            String string2 = value.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            t = Enum.valueOf(clazz, string2);
            Intrinsics.checkNotNull(t);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Invalid enum constant");
        }
        return t;
    }

    public void serialize(@NotNull Type type, @Nullable Enum<?> obj, @NotNull ConfigurationNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Enum<?> enum_ = obj;
        if (enum_ != null && (enum_ = enum_.name()) != null) {
            String string2 = ((String)((Object)enum_)).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        node.set(string);
    }
}

