/*
 * Decompiled with CFR 0.152.
 */
package io.github.tomdw.java.modules.context.boot.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Attribute;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.ModuleVisitor;

public class ModuleInfoReader {
    private static final Map<Module, ModuleInfoReader> moduleInfoReaders = new HashMap<Module, ModuleInfoReader>();
    private final Module module;
    private Class<?> moduleInfoClazz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleInfoReader of(Module module) {
        if (moduleInfoReaders.get(module) == null) {
            Map<Module, ModuleInfoReader> map = moduleInfoReaders;
            synchronized (map) {
                moduleInfoReaders.put(module, new ModuleInfoReader(module));
            }
        }
        return moduleInfoReaders.get(module);
    }

    ModuleInfoReader(Module module) {
        this.module = module;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.moduleInfoClass(this.module) != null && this.moduleInfoClass(this.module).isAnnotationPresent(annotationClass);
    }

    public <ANNOTATION extends Annotation> ANNOTATION getAnnotation(Class<ANNOTATION> annotationClass) {
        return this.moduleInfoClass(this.module) != null ? (ANNOTATION)this.moduleInfoClass(this.module).getAnnotation(annotationClass) : null;
    }

    private Class<?> moduleInfoClass(Module module) {
        if (this.moduleInfoClazz == null) {
            PrivilegedAction<Class> pa = () -> this.loadModuleInfoClass(module);
            this.moduleInfoClazz = AccessController.doPrivileged(pa);
        }
        return this.moduleInfoClazz;
    }

    private Class<?> loadModuleInfoClass(Module module) {
        Class<?> clazz = null;
        try (InputStream in = module.getResourceAsStream("module-info.class");){
            if (in != null) {
                clazz = this.loadModuleInfoClass(in, module);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private Class<?> loadModuleInfoClass(InputStream in, Module module) throws IOException {
        String MODULE_INFO = "module-info";
        final ClassWriter cw = new ClassWriter(3);
        ClassVisitor cv = new ClassVisitor(393216, (ClassVisitor)cw){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                cw.visit(version, 5632, "module-info", null, "java/lang/Object", null);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return super.visitAnnotation(desc, visible);
            }

            public void visitAttribute(Attribute attr) {
            }

            public ModuleVisitor visitModule(String name, int flags, String version) {
                return null;
            }
        };
        ClassReader cr = new ClassReader(in);
        cr.accept(cv, 0);
        final byte[] bytes = cw.toByteArray();
        ClassLoader cl = new ClassLoader(module.getClassLoader()){

            @Override
            protected Class<?> findClass(String cn) throws ClassNotFoundException {
                if (cn.equals("module-info")) {
                    return super.defineClass(cn, bytes, 0, bytes.length);
                }
                throw new ClassNotFoundException(cn);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
                Object object = this.getClassLoadingLock(cn);
                synchronized (object) {
                    Class<?> c = this.findLoadedClass(cn);
                    if (c == null) {
                        c = cn.equals("module-info") ? this.findClass(cn) : super.loadClass(cn, resolve);
                    }
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
        };
        try {
            return cl.loadClass("module-info");
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }
}

