/*
 * Decompiled with CFR 0.152.
 */
package io.github.tomdw.java.modules.context.boot.internal;

import io.github.tomdw.java.modules.context.boot.api.ModuleContext;
import io.github.tomdw.java.modules.context.boot.internal.ApplicationContextInstantiationException;
import io.github.tomdw.java.modules.context.boot.internal.LazyRetrieveBeanFromContextStrategy;
import io.github.tomdw.java.modules.context.boot.internal.ModuleServiceReferenceAnnotationPostProcessor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.support.GenericApplicationContext;

public class ModuleContextRegistry {
    private static final System.Logger LOGGER = System.getLogger(ModuleContextRegistry.class.getName());
    private static final Map<Module, GenericApplicationContext> moduleContexts = new HashMap<Module, GenericApplicationContext>();
    private static GenericApplicationContext defaultApplicationContext;

    private ModuleContextRegistry() {
    }

    public static void reset() {
        defaultApplicationContext = null;
        moduleContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(Module module, GenericApplicationContext applicationContext) {
        Map<Module, GenericApplicationContext> map = moduleContexts;
        synchronized (map) {
            LOGGER.log(System.Logger.Level.DEBUG, "Registering spring application context for module " + module.getName());
            if (moduleContexts.containsKey(module)) {
                throw new IllegalStateException("An application context for module " + module.getName() + " was already registered");
            }
            moduleContexts.put(module, applicationContext);
        }
    }

    private static GenericApplicationContext getOrPrepareContextFor(Module module) {
        ModuleContextRegistry.prepareApplicationContextForModuleIfNeeded(module);
        Map<Module, GenericApplicationContext> map = moduleContexts;
        synchronized (map) {
            if (moduleContexts.containsKey(module)) {
                return moduleContexts.get(module);
            }
            if (defaultApplicationContext != null) {
                return defaultApplicationContext;
            }
            throw new IllegalStateException("No Application context found for module " + module.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareApplicationContextForModuleIfNeeded(Module module) {
        if (module.isAnnotationPresent(ModuleContext.class)) {
            Map<Module, GenericApplicationContext> map = moduleContexts;
            synchronized (map) {
                if (!moduleContexts.containsKey(module)) {
                    ModuleContextRegistry.prepareApplicationContextFor(module);
                }
            }
        }
    }

    public static <SERVICETYPE> SERVICETYPE retrieveInstanceFromContext(Class<SERVICETYPE> serviceClass) {
        Module moduleToRetrieveFrom = ModuleContextRegistry.getCallerModule();
        GenericApplicationContext context = ModuleContextRegistry.getOrPrepareContextFor(moduleToRetrieveFrom);
        return LazyRetrieveBeanFromContextStrategy.withoutServiceName(moduleToRetrieveFrom, defaultApplicationContext, context, serviceClass).retrieveInstanceFromContext();
    }

    public static <SERVICETYPE> SERVICETYPE retrieveInstanceFromContext(Class<SERVICETYPE> serviceClass, String serviceName) {
        Module moduleToRetrieveFrom = ModuleContextRegistry.getCallerModule();
        GenericApplicationContext context = ModuleContextRegistry.getOrPrepareContextFor(moduleToRetrieveFrom);
        return LazyRetrieveBeanFromContextStrategy.withServiceName(moduleToRetrieveFrom, defaultApplicationContext, context, serviceClass, serviceName).retrieveInstanceFromContext();
    }

    private static void provisionForLayer(ModuleLayer layer) {
        LOGGER.log(System.Logger.Level.INFO, "Preparing modular spring application");
        for (Module module : layer.modules()) {
            if (!module.isAnnotationPresent(ModuleContext.class)) continue;
            ModuleContextRegistry.prepareApplicationContextForModuleIfNeeded(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void boot(ModuleLayer layer) {
        ModuleContextRegistry.provisionForLayer(layer);
        LOGGER.log(System.Logger.Level.INFO, "Booting modular spring application");
        Map<Module, GenericApplicationContext> map = moduleContexts;
        synchronized (map) {
            for (Map.Entry<Module, GenericApplicationContext> contextEntry : moduleContexts.entrySet()) {
                Module module = contextEntry.getKey();
                GenericApplicationContext context = contextEntry.getValue();
                if (!context.isActive()) {
                    LOGGER.log(System.Logger.Level.INFO, "Starting ApplicationContext for Module " + module.getName());
                    context.refresh();
                    continue;
                }
                LOGGER.log(System.Logger.Level.INFO, "ApplicationContext for Module " + module.getName() + " is already active");
            }
        }
    }

    public static void boot() {
        ModuleContextRegistry.boot(ModuleLayer.boot());
    }

    public static void boot(GenericApplicationContext defaultApplicationContext) {
        ModuleContextRegistry.defaultApplicationContext = defaultApplicationContext;
        ModuleContextRegistry.enhanceApplicationContext(defaultApplicationContext);
        ModuleContextRegistry.boot();
    }

    private static void prepareApplicationContextFor(Module module) {
        ModuleContext moduleContext = module.getAnnotation(ModuleContext.class);
        Class<?> mainConfigurationClass = moduleContext.mainConfigurationClass();
        LOGGER.log(System.Logger.Level.INFO, "Preparing ApplicationContext for Module " + module.getName() + " using config class " + mainConfigurationClass.getSimpleName());
        GenericApplicationContext context = ModuleContextRegistry.instantiateApplicationContext(moduleContext);
        context.setId("module-context-" + module.getName());
        AnnotationConfigRegistry annotationConfigRegistry = ModuleContextRegistry.asAnnotationConfigRegistry(context);
        annotationConfigRegistry.register(new Class[]{mainConfigurationClass});
        ModuleContextRegistry.enhanceApplicationContext(context);
        ModuleContextRegistry.register(module, context);
    }

    private static void enhanceApplicationContext(GenericApplicationContext context) {
        AnnotationConfigRegistry annotationConfigRegistry = ModuleContextRegistry.asAnnotationConfigRegistry(context);
        annotationConfigRegistry.register(new Class[]{ModuleServiceReferenceAnnotationPostProcessor.class});
        if (defaultApplicationContext != null && context != defaultApplicationContext) {
            context.setEnvironment(defaultApplicationContext.getEnvironment());
        }
    }

    private static GenericApplicationContext instantiateApplicationContext(ModuleContext moduleContext) {
        try {
            return moduleContext.applicationContextClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Cannot instantiate " + moduleContext.applicationContextClass());
            throw new ApplicationContextInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(System.Logger.Level.ERROR, "No access to default constructor of " + moduleContext.applicationContextClass());
            throw new ApplicationContextInstantiationException(e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Cannot invoke default constructor of " + moduleContext.applicationContextClass());
            throw new ApplicationContextInstantiationException(e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(System.Logger.Level.ERROR, "No Default constructor for " + moduleContext.applicationContextClass());
            throw new ApplicationContextInstantiationException(e);
        }
    }

    private static AnnotationConfigRegistry asAnnotationConfigRegistry(GenericApplicationContext context) {
        try {
            return (AnnotationConfigRegistry)context;
        }
        catch (ClassCastException e) {
            LOGGER.log(System.Logger.Level.ERROR, "The provided Application Context type " + context.getClass() + " should implement org.springframework.context.annotation.AnnotationConfigRegistry");
            throw new ApplicationContextInstantiationException(e);
        }
    }

    private static Module getCallerModule() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stackFrameStream -> stackFrameStream.map(StackWalker.StackFrame::getDeclaringClass).map(Class::getModule).filter(module -> module != ModuleContextRegistry.class.getModule()).findFirst().orElseThrow(() -> new UnsupportedOperationException("Can only get an application context for a Module annotated with @ModuleContext")));
    }

    public static GenericApplicationContext getContextFor(Module module) {
        return ModuleContextRegistry.getOrPrepareContextFor(module);
    }
}

