/*
 * Decompiled with CFR 0.152.
 */
package io.github.tomdw.java.modules.context.boot.internal;

import io.github.tomdw.java.modules.context.boot.internal.InactiveDefaultApplicationContextException;
import io.github.tomdw.java.modules.context.boot.internal.LazyRetrieveBeanFromContextWithServiceNameStrategy;
import io.github.tomdw.java.modules.context.boot.internal.LazyRetrieveBeanFromContextWithoutServiceNameStrategy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.context.support.GenericApplicationContext;

abstract class LazyRetrieveBeanFromContextStrategy<SERVICETYPE>
implements InvocationHandler {
    private static final System.Logger LOGGER = System.getLogger(LazyRetrieveBeanFromContextStrategy.class.getName());
    protected final Module moduleToRetrieveFrom;
    protected final GenericApplicationContext defaultApplicationContext;
    protected final GenericApplicationContext context;
    protected final Class<SERVICETYPE> serviceClass;

    protected LazyRetrieveBeanFromContextStrategy(Module moduleToRetrieveFrom, GenericApplicationContext defaultApplicationContext, GenericApplicationContext context, Class<SERVICETYPE> serviceClass) {
        this.moduleToRetrieveFrom = moduleToRetrieveFrom;
        this.defaultApplicationContext = defaultApplicationContext;
        this.context = context;
        this.serviceClass = serviceClass;
    }

    static <SERVICECLASS> LazyRetrieveBeanFromContextStrategy<SERVICECLASS> withoutServiceName(Module moduleToRetrieveFrom, GenericApplicationContext defaultApplicationContext, GenericApplicationContext context, Class<SERVICECLASS> serviceClass) {
        return new LazyRetrieveBeanFromContextWithoutServiceNameStrategy<SERVICECLASS>(moduleToRetrieveFrom, defaultApplicationContext, context, serviceClass);
    }

    static <SERVICECLASS> LazyRetrieveBeanFromContextStrategy<SERVICECLASS> withServiceName(Module moduleToRetrieveFrom, GenericApplicationContext defaultApplicationContext, GenericApplicationContext context, Class<SERVICECLASS> serviceClass, String serviceName) {
        return new LazyRetrieveBeanFromContextWithServiceNameStrategy<SERVICECLASS>(moduleToRetrieveFrom, defaultApplicationContext, context, serviceClass, serviceName);
    }

    SERVICETYPE retrieveInstanceFromContext() {
        if (this.serviceClass.isInterface()) {
            LOGGER.log(System.Logger.Level.DEBUG, "Providing dynamic proxy for " + this.logMessageDescribingInstanceToProvide() + " from module " + this.moduleToRetrieveFrom.getName());
            return this.createDynamicProxyToPostponeContextLoadingUntilInvocationOfService();
        }
        LOGGER.log(System.Logger.Level.WARNING, "Bean was provided as implementation, better to provide interfaces so dynamic proxies are created: " + this.serviceClass);
        this.lazyStartApplicationContextForModule();
        LOGGER.log(System.Logger.Level.DEBUG, "Providing " + this.logMessageDescribingInstanceToProvide() + " from module " + this.moduleToRetrieveFrom.getName());
        return this.getBeanFromContext();
    }

    private SERVICETYPE createDynamicProxyToPostponeContextLoadingUntilInvocationOfService() {
        return (SERVICETYPE)Proxy.newProxyInstance(this.moduleToRetrieveFrom.getClassLoader(), new Class[]{this.serviceClass}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.lazyStartApplicationContextForModule();
        LOGGER.log(System.Logger.Level.DEBUG, "Resolving dynamic proxy for " + this.logMessageDescribingInstanceToProvide() + " from ApplicationContext for module " + this.moduleToRetrieveFrom.getName());
        try {
            return method.invoke(this.getBeanFromContext(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private void lazyStartApplicationContextForModule() {
        if (!this.context.isActive()) {
            if (this.context.equals(this.defaultApplicationContext)) {
                throw new InactiveDefaultApplicationContextException(this.moduleToRetrieveFrom, this.serviceClass);
            }
            LOGGER.log(System.Logger.Level.INFO, "Lazy starting ApplicationContext for module " + this.moduleToRetrieveFrom.getName());
            this.context.refresh();
        }
    }

    protected abstract SERVICETYPE getBeanFromContext();

    protected abstract String logMessageDescribingInstanceToProvide();
}

