/*
 * Decompiled with CFR 0.152.
 */
package io.github.unknowncoder56.javaslc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.unknowncoder56.javaslc.ErrorListener;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;

public class User {
    protected final String userId;
    protected ErrorListener errorListener;

    public User(String userId, ErrorListener errorListener) {
        this.userId = userId;
        this.errorListener = errorListener;
    }

    public String getUserId() {
        return this.userId;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public CompletableFuture<LocalDateTime> getAccountCreationDate() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return LocalDateTime.parse(this.getUserDetailsJsonObject().get("creation_date").getAsString());
            }
            catch (IOException e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "getAccountCreationDate");
                }
                System.out.println("Failed to fetch account creation date: " + e.getMessage());
                return null;
            }
        });
    }

    public CompletableFuture<JsonObject> getLabelJsonObject() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getUserDetailsJsonObject().get("label").getAsJsonObject();
            }
            catch (IOException e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "getLabelJsonObject");
                }
                System.out.println("Failed to fetch label JSON object: " + e.getMessage());
                return null;
            }
        });
    }

    public CompletableFuture<String> getNickname() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getUserDetailsJsonObject().get("nickname").getAsString();
            }
            catch (IOException e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "getNickname");
                }
                System.out.println("Failed to fetch nickname: " + e.getMessage());
                return null;
            }
        });
    }

    public CompletableFuture<String> getProfileImageUrl() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getUserDetailsJsonObject().get("profile_img").getAsString();
            }
            catch (IOException e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "getProfileImageUrl");
                }
                System.out.println("Failed to fetch profile image URL: " + e.getMessage());
                return null;
            }
        });
    }

    public CompletableFuture<long[]> getJoinedServerIds() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getUserDetailsJsonObject().get("servers").getAsJsonArray().asList().stream().mapToLong(JsonElement::getAsLong).toArray();
            }
            catch (IOException e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "getJoinedServerIds");
                }
                System.out.println("Failed to fetch joined server IDs: " + e.getMessage());
                return null;
            }
        });
    }

    public CompletableFuture<String> getUsername() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getUserDetailsJsonObject().get("username").getAsString();
            }
            catch (IOException e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "getUsername");
                }
                System.out.println("Failed to fetch username: " + e.getMessage());
                return null;
            }
        });
    }

    public CompletableFuture<Boolean> isBot() {
        return this.getLabelJsonObject().thenApplyAsync(jsonObject -> jsonObject.get("name").getAsString().equals("BOT"));
    }

    private JsonObject getUserDetailsJsonObject() throws IOException {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            String responseJsonString = (String)client.execute((ClassicHttpRequest)new HttpGet("https://slchat.alwaysdata.net/api/user/" + this.userId + "/"), classicHttpResponse -> new String(classicHttpResponse.getEntity().getContent().readAllBytes()));
            JsonObject jsonObject = JsonParser.parseString((String)responseJsonString).getAsJsonObject();
            return jsonObject;
        }
    }
}

