/*
 * Decompiled with CFR 0.152.
 */
package io.github.unknowncoder56.javaslc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.unknowncoder56.javaslc.CommandContext;
import io.github.unknowncoder56.javaslc.CommandListener;
import io.github.unknowncoder56.javaslc.ErrorListener;
import io.github.unknowncoder56.javaslc.MessageContext;
import io.github.unknowncoder56.javaslc.MessageListener;
import io.github.unknowncoder56.javaslc.StartListener;
import io.github.unknowncoder56.javaslc.User;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class Bot
extends User {
    private String prefix;
    private StartListener startListener;
    private final String token;
    private final ArrayList<MessageListener> messageListeners;
    private final ArrayList<CommandListener> commandListeners;
    private final Map<String, Socket> serverMap = new HashMap<String, Socket>();

    Bot(String prefix, StartListener startListener, ErrorListener errorListener, String token, String userId, ArrayList<MessageListener> messageListeners, ArrayList<CommandListener> commandListeners) {
        super(userId, errorListener);
        this.prefix = prefix;
        this.startListener = startListener;
        this.token = token;
        this.messageListeners = messageListeners;
        this.commandListeners = commandListeners;
    }

    public void run() throws RuntimeException {
        if (this.prefix.isEmpty()) {
            throw new RuntimeException("Prefix not set.");
        }
        if (this.token.isEmpty()) {
            throw new RuntimeException("Token not set.");
        }
        if (this.userId.isEmpty()) {
            throw new RuntimeException("Bot user ID not set.");
        }
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            try {
                String responseJsonString = (String)client.execute((ClassicHttpRequest)new HttpGet("https://slchat.alwaysdata.net/api/user/" + this.userId + "/"), classicHttpResponse -> new String(classicHttpResponse.getEntity().getContent().readAllBytes()));
                JsonObject responseJson = JsonParser.parseString((String)responseJsonString).getAsJsonObject();
                JsonArray servers = responseJson.getAsJsonArray("servers");
                for (JsonElement server : servers) {
                    String serverId = server.getAsString();
                    if (this.serverMap.containsKey(serverId)) continue;
                    this.makeSocketForServer(serverId);
                }
                if (this.startListener != null) {
                    this.startListener.onStart();
                }
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            if (this.errorListener != null) {
                this.errorListener.onError(e, "run");
            }
            System.out.println("Failed to start bot: " + e.getMessage());
            return;
        }
    }

    private void handleMessage(JsonObject prompt) {
        JsonObject message = prompt.get("message").getAsJsonObject();
        String serverId = prompt.get("server_id").getAsString();
        try {
            if (!Objects.equals(message.get("owner").getAsString(), this.getBotUserId()) && message.get("text").getAsString().startsWith(this.prefix)) {
                String[] commandParts = message.get("text").getAsString().split(" ");
                if (commandParts.length > 1) {
                    String[] arguments = Arrays.copyOfRange(commandParts, 1, commandParts.length - 1);
                    this.commandListeners.forEach(commandListener -> commandListener.onCommand(new CommandContext(message, serverId, this, commandParts[0].substring(1), arguments)));
                } else {
                    this.commandListeners.forEach(commandListener -> commandListener.onCommand(new CommandContext(message, serverId, this, commandParts[0].substring(1))));
                }
            }
            this.messageListeners.forEach(messageListener -> messageListener.onMessage(new MessageContext(message, serverId, this)));
        }
        catch (Exception e) {
            if (this.errorListener != null) {
                this.errorListener.onError(e, "checkNewCommand");
            }
            System.out.println("Failed to handle message from server " + serverId + ": " + e.getMessage());
        }
    }

    public CompletableFuture<Void> send(String text, String serverId) {
        return CompletableFuture.runAsync(() -> {
            if (this.serverMap.containsKey(serverId)) {
                try {
                    JSONObject payload = new JSONObject();
                    payload.put("text", (Object)text);
                    payload.put("server_id", (Object)serverId);
                    payload.put("token", (Object)this.token);
                    payload.put("op", (Object)this.getBotUserId());
                    this.serverMap.get(serverId).emit("message", new Object[]{payload});
                }
                catch (Exception e) {
                    this.errorListener.onError(e, "send");
                    System.out.println("Failed to send message to server " + serverId + ": " + e.getMessage());
                }
            } else {
                if (this.errorListener != null) {
                    this.errorListener.onError(new Exception("Bot is not in server " + serverId), "send");
                }
                System.out.println("Bot is not in server " + serverId);
            }
        });
    }

    public CompletableFuture<Void> join(String serverId) {
        return CompletableFuture.runAsync(() -> {
            if (!this.serverMap.containsKey(serverId)) {
                BasicCookieStore cookieStore = new BasicCookieStore();
                BasicClientCookie tokenCookie = new BasicClientCookie("token", this.token);
                tokenCookie.setDomain("slchat.alwaysdata.net");
                tokenCookie.setAttribute("domain", "true");
                tokenCookie.setPath("/");
                BasicClientCookie opCookie = new BasicClientCookie("op", this.getBotUserId());
                opCookie.setDomain("slchat.alwaysdata.net");
                opCookie.setAttribute("domain", "true");
                opCookie.setPath("/");
                cookieStore.addCookie((Cookie)tokenCookie);
                cookieStore.addCookie((Cookie)opCookie);
                try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();){
                    HttpPost post = new HttpPost("https://slchat.alwaysdata.net/api/new_server");
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("server_id", serverId))));
                    post.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                    ClassicHttpResponse response = (ClassicHttpResponse)client.execute((ClassicHttpRequest)post, classicHttpResponse -> classicHttpResponse);
                    int code = response.getCode();
                    if (400 <= code && code < 500 || 500 <= code && code < 600) {
                        throw new Exception("(" + code + ") " + response.getReasonPhrase());
                    }
                    this.makeSocketForServer(serverId);
                    System.out.println("Current server IDs: " + String.valueOf(this.serverMap.keySet()));
                }
                catch (Exception e) {
                    if (this.errorListener != null) {
                        this.errorListener.onError(e, "join");
                    }
                    System.out.println("Failed to join server " + serverId + ": " + e.getMessage());
                }
            } else {
                if (this.errorListener != null) {
                    this.errorListener.onError(new Exception("Bot is already in server " + serverId), "join");
                }
                System.out.println("Bot is already in server " + serverId);
            }
        });
    }

    public CompletableFuture<Void> change(ChangeKey changeKey, String changeValue) {
        return CompletableFuture.runAsync(() -> {
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicClientCookie tokenCookie = new BasicClientCookie("token", this.token);
            tokenCookie.setDomain("slchat.alwaysdata.net");
            tokenCookie.setAttribute("domain", "true");
            tokenCookie.setPath("/");
            BasicClientCookie opCookie = new BasicClientCookie("op", this.getBotUserId());
            opCookie.setDomain("slchat.alwaysdata.net");
            opCookie.setAttribute("domain", "true");
            opCookie.setPath("/");
            cookieStore.addCookie((Cookie)tokenCookie);
            cookieStore.addCookie((Cookie)opCookie);
            try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();){
                HttpPost post = new HttpPost("https://slchat.alwaysdata.net/api/change");
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("change_key", changeKey.getKeyString()), new BasicNameValuePair("change_value", changeValue), new BasicNameValuePair("token", this.token), new BasicNameValuePair("op", this.getBotUserId()))));
                post.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ClassicHttpResponse response = (ClassicHttpResponse)client.execute((ClassicHttpRequest)post, classicHttpResponse -> classicHttpResponse);
                int code = response.getCode();
                if (400 <= code && code < 500 || 500 <= code && code < 600) {
                    throw new Exception("(" + code + ") " + response.getReasonPhrase());
                }
                System.out.println("Changed key " + changeKey.name() + " into " + changeValue);
            }
            catch (Exception e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "change");
                }
                System.out.println("Failed to change key " + changeKey.name() + " into " + changeValue + ": " + e.getMessage());
            }
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public StartListener getStartListener() {
        return this.startListener;
    }

    public void setStartListener(StartListener startListener) {
        this.startListener = startListener;
    }

    public String getBotUserId() {
        return this.userId;
    }

    public ArrayList<MessageListener> getMessageListeners() {
        return this.messageListeners;
    }

    public void addMessageListener(MessageListener messageListener) {
        this.messageListeners.add(messageListener);
    }

    public ArrayList<CommandListener> getCommandListeners() {
        return this.commandListeners;
    }

    public void addCommandListener(CommandListener commandListener) {
        this.commandListeners.add(commandListener);
    }

    private void makeSocketForServer(String serverId) {
        try {
            Socket socket = IO.socket((String)("https://slchat.alwaysdata.net?server=" + serverId + "&user=" + this.getBotUserId()));
            socket.on("prompt", objects -> this.handleMessage(JsonParser.parseString((String)objects[0].toString()).getAsJsonObject()));
            socket.connect();
            this.serverMap.put(serverId, socket);
        }
        catch (URISyntaxException e) {
            if (this.errorListener != null) {
                this.errorListener.onError(e, "makeSocketForServer");
            }
            System.out.println("Failed to make socket for server " + serverId);
        }
    }

    public static enum ChangeKey {
        PROFILE_IMAGE("profile_img"),
        NICKNAME("nickname");

        private final String key;

        private ChangeKey(String key) {
            this.key = key;
        }

        public String getKeyString() {
            return this.key;
        }
    }
}

