/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.repl;

import io.github.zero88.exceptions.HiddenException;
import io.github.zero88.exceptions.ReflectionException;
import io.github.zero88.repl.Arguments;
import io.github.zero88.repl.ReflectionElement;
import io.github.zero88.repl.ReflectionMember;
import io.github.zero88.repl.ReflectionScanner;
import io.github.zero88.repl.Reflections;
import io.github.zero88.utils.Functions;
import io.github.zero88.utils.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ReflectionClass
implements ReflectionElement {
    private ReflectionClass() {
    }

    public static boolean assertDataType(@NotNull String childClass, @NotNull Class<?> superClass) {
        return ReflectionClass.assertDataType(Objects.requireNonNull(ReflectionClass.findClass(childClass), "Not found class [" + childClass + "]"), superClass);
    }

    public static boolean assertDataType(@NotNull Class<?> childClass, @NotNull Class<?> superClass) {
        if (childClass.isPrimitive() && superClass.isPrimitive()) {
            return childClass == superClass;
        }
        if (childClass.isPrimitive()) {
            Class<?> superPrimitiveClass = ReflectionClass.getPrimitiveClass(superClass);
            return childClass == superPrimitiveClass;
        }
        if (superClass.isPrimitive()) {
            Class<?> childPrimitiveClass = ReflectionClass.getPrimitiveClass(childClass);
            return childPrimitiveClass == superClass;
        }
        return superClass.isAssignableFrom(childClass);
    }

    public static boolean isSystemClass(String clazzName) {
        return ReflectionClass.belongsTo(clazzName, "java", "javax", "sun", "com.sun");
    }

    public static boolean belongsTo(@NotNull String clazzName, String ... packageNames) {
        return Arrays.stream(packageNames).map(p -> p + ".").anyMatch(clazzName::startsWith);
    }

    public static boolean isJavaLangObject(@NotNull Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || !clazz.isArray() && "java.lang".equals(clazz.getPackage().getName());
    }

    public static Class<?> parsePrimitiveType(String className) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return null;
    }

    private static <T> Class<?> getPrimitiveClass(@NotNull Class<T> findClazz) {
        try {
            Field t = findClazz.getField("TYPE");
            if (!ReflectionMember.hasModifiers(1, 8).test(t)) {
                return null;
            }
            Object primitiveClazz = t.get(null);
            if (primitiveClazz instanceof Class) {
                return (Class)primitiveClazz;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Reflections.LOGGER.trace("Try casting primitive class from class " + findClazz.getName(), (Throwable)e);
        }
        return null;
    }

    public static <T> Stream<Class<T>> stream(String pkgName, Class<T> parentCls) {
        return ReflectionClass.stream(pkgName, parentCls, (Class<T> clazz) -> true);
    }

    public static <T> Stream<Class<T>> stream(String pkgName, Class<T> parentCls, @NotNull Class<? extends Annotation> annotationClass) {
        return ReflectionClass.stream(pkgName, parentCls, ReflectionElement.hasAnnotation(annotationClass));
    }

    public static <T> Stream<Class<T>> stream(String pkgName, Class<T> parentCls, @NotNull Predicate<Class<T>> filter) {
        return ReflectionClass.stream(Reflections.loadScanner(), pkgName, parentCls, filter);
    }

    public static <T> Stream<Class<T>> stream(ReflectionScanner scanner, String pkgName, Class<T> parentCls, @NotNull Predicate<Class<T>> filter) {
        return scanner.classStream(pkgName, cls -> ReflectionClass.assertDataType(cls, parentCls)).map(cls -> cls).filter(filter).map(cls -> cls);
    }

    public static boolean hasClass(String cls) {
        return ReflectionClass.hasClass(cls, Reflections.classLoaders(new ClassLoader[0]));
    }

    public static boolean hasClass(String cls, ClassLoader ... classLoaders) {
        if (Objects.nonNull(ReflectionClass.parsePrimitiveType(cls))) {
            return true;
        }
        for (ClassLoader classLoader : classLoaders) {
            try {
                Class.forName(Objects.requireNonNull(cls), false, classLoader);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return false;
    }

    public static <T> Class<T> findClass(String cls) {
        return ReflectionClass.findClass(cls, Reflections.classLoaders(new ClassLoader[0]));
    }

    public static <T> Class<T> findClass(String cls, ClassLoader ... classLoaders) {
        Class<?> aClass = ReflectionClass.parsePrimitiveType(cls);
        if (Objects.nonNull(aClass)) {
            return aClass;
        }
        for (ClassLoader classLoader : classLoaders) {
            try {
                return Class.forName(Strings.requireNotBlank(cls), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static <T> T createObject(String clazz) {
        Class<T> aClass = ReflectionClass.findClass(clazz);
        return Objects.isNull(aClass) ? null : (T)ReflectionClass.createObject(aClass);
    }

    public static <T> T createObject(String clazz, @NotNull Arguments arguments) {
        Class<T> aClass = ReflectionClass.findClass(clazz);
        return Objects.isNull(aClass) ? null : (T)ReflectionClass.createObject(aClass, arguments);
    }

    public static <T> T createObject(Class<T> clazz) {
        return ReflectionClass.createObject(clazz, new Functions.Silencer()).get();
    }

    public static <T> T createObject(Class<T> clazz, Arguments arguments) {
        return ReflectionClass.createObject(clazz, arguments, new Functions.Silencer()).get();
    }

    public static <T> Functions.Silencer<T> createObject(Class<T> clazz, Functions.Silencer<T> silencer) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            silencer.accept(constructor.newInstance(new Object[0]), null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            silencer.accept((Object)null, new HiddenException(new ReflectionException("Cannot init instance of " + clazz.getName(), (Throwable)e)));
        }
        return silencer;
    }

    public static <T> Functions.Silencer<T> createObject(@NotNull Class<T> clazz, @NotNull Arguments arguments, @NotNull Functions.Silencer<T> silencer) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(arguments.argClasses());
            constructor.setAccessible(true);
            silencer.accept(constructor.newInstance(arguments.argValues()), null);
        }
        catch (ReflectiveOperationException e) {
            silencer.accept((Object)null, new HiddenException(new ReflectionException("Cannot init instance of " + clazz.getName(), (Throwable)e)));
        }
        return silencer;
    }
}

