/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.repl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public interface ReflectionElement {
    public static <T extends Class> Predicate<T> hasModifiers(int ... modifiers) {
        int searchMods = Arrays.stream(modifiers).reduce((left, right) -> left | right).orElse(0);
        return cls -> (cls.getModifiers() & searchMods) == searchMods;
    }

    public static <T extends Class> Predicate<T> notModifiers(int ... modifiers) {
        int searchMods = Arrays.stream(modifiers).reduce((left, right) -> left | right).orElse(0);
        return cls -> (cls.getModifiers() & searchMods) != searchMods;
    }

    public static <T extends Class> Predicate<T> isPublicClass() {
        return ReflectionElement.hasModifiers(1).and(ReflectionElement.notModifiers(1024)).and(ReflectionElement.notModifiers(512));
    }

    @SafeVarargs
    public static <T extends AnnotatedElement> Predicate<T> hasAnnotation(Class<? extends Annotation> ... annotations) {
        return element -> Arrays.stream(annotations).filter(Objects::nonNull).anyMatch(a -> Objects.nonNull(element.getAnnotation(a)));
    }
}

