/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import io.github.zero88.utils.FileUtils;
import io.github.zero88.utils.Functions;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings {
    private static final Logger logger = LoggerFactory.getLogger(Strings.class);

    private Strings() {
    }

    public static String toString(Object object) {
        return object == null ? "" : object.toString().trim();
    }

    public static String duplicate(String value, int times) {
        Objects.requireNonNull(value);
        if (times <= 1) {
            throw new IllegalArgumentException("Duplicate time must be greater than 1");
        }
        return IntStream.range(0, times).collect(StringBuilder::new, (s, i) -> s.append(value), (s, i) -> s.append(value)).toString();
    }

    public static boolean isBlank(String text) {
        return text == null || "".equals(text.trim());
    }

    public static boolean isNotBlank(String text) {
        return !Strings.isBlank(text);
    }

    public static String requireNotBlank(String text) {
        return Strings.requireNotBlank(text, "Given input cannot be empty");
    }

    public static String requireNotBlank(String text, String message) {
        if (Strings.isBlank(text)) {
            throw new IllegalArgumentException(message);
        }
        return text.trim();
    }

    public static String requireNotBlank(String text, @NotNull Supplier<? extends RuntimeException> errorSupplier) {
        if (Strings.isBlank(text)) {
            throw errorSupplier.get();
        }
        return text.trim();
    }

    public static String requireNotBlank(Object object, String message) {
        if (Objects.isNull(object) || Strings.isBlank(object.toString())) {
            throw new IllegalArgumentException(message);
        }
        return object.toString().trim();
    }

    public static <T> T requireNotBlank(T obj, @NotNull Supplier<? extends RuntimeException> errorSupplier) {
        if (Objects.isNull(obj) || obj instanceof String && Strings.isBlank(obj.toString())) {
            throw errorSupplier.get();
        }
        return obj;
    }

    public static String optimizeMultipleSpace(String text) {
        String t = Strings.requireNotBlank(text);
        return t.replaceAll("\\s+", " ");
    }

    public static String optimizeNoSpace(String text) {
        String t = Strings.requireNotBlank(text);
        return t.replaceAll("\\s+", "");
    }

    public static String requiredMinLength(String text, int minLength) {
        String t = Strings.requireNotBlank(text);
        if (t.length() < minLength) {
            throw new IllegalArgumentException("Text " + text + " length must be greater than " + minLength);
        }
        return t;
    }

    public static String toSnakeLowerCase(@NotNull String text) {
        return Strings.toSnakeCase(text, false);
    }

    public static String toSnakeUpperCase(@NotNull String text) {
        return Strings.toSnakeCase(text, true);
    }

    private static String toSnakeCase(@NotNull String text, boolean upper) {
        return Strings.transform(text, upper, "_");
    }

    static String transform(@NotNull String text, boolean upper, String separate) {
        if (upper && text.equals(text.toUpperCase())) {
            return text;
        }
        if (!upper && text.equals(text.toLowerCase())) {
            return text;
        }
        String t = text.replaceAll("([A-Z])", separate + "$1").replaceAll("^" + separate, "");
        return upper ? t.toUpperCase() : t.toLowerCase();
    }

    public static int convertToInt(String text, int fallback) {
        if (Strings.isBlank(text)) {
            return fallback;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            logger.debug("Cannot parse " + text + " to int", (Throwable)ex);
            return fallback;
        }
    }

    public static String convertToString(InputStream inputStream) {
        return Objects.isNull(inputStream) ? null : Functions.getOrThrow(t -> new RuntimeException("Unsupported UTF-8 encoding", (Throwable)t), () -> FileUtils.convertToByteArray(inputStream).toString(StandardCharsets.UTF_8.name()));
    }

    public static String format(String msgPattern, Object ... params) {
        Object[] args = Arrays.stream(params).map(String::valueOf).toArray(String[]::new);
        return MessageFormat.format(msgPattern, args);
    }

    public static String fallback(String value, String fallback) {
        return Strings.isBlank(value) ? Strings.requireNotBlank(fallback) : value;
    }

    public static String fallback(String value, @NotNull Supplier<String> fallback) {
        return Strings.isBlank(value) ? fallback.get() : value;
    }

    public static boolean in(String with, boolean equalsIgnoreCase, String ... values) {
        if (Strings.isBlank(with)) {
            return false;
        }
        for (String value : values) {
            if (!(Strings.isNotBlank(value) && equalsIgnoreCase ? with.equalsIgnoreCase(value) : with.equals(value))) continue;
            return true;
        }
        return false;
    }

    public static boolean in(String with, String ... values) {
        return Strings.in(with, false, values);
    }

    public static String getFirstNotNull(String ... strings) {
        for (String string : strings) {
            if (!Strings.isNotBlank(string)) continue;
            return string;
        }
        return strings[0];
    }

    public static Object getFirstNotNull(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return object;
        }
        return objects[0];
    }

    public static String getMatchValueOrFirstOne(String with, String[] withMatch) {
        for (String value : withMatch) {
            if (!with.equals(value)) continue;
            return with;
        }
        return withMatch.length > 0 ? withMatch[0] : null;
    }

    public static String getMatchValue(String with, String[] withMatch) {
        for (String value : withMatch) {
            if (!with.equals(value)) continue;
            return with;
        }
        return null;
    }

    public static String padLeft(String inputString, int length) {
        return Strings.doPadLeft(inputString, length, ' ');
    }

    public static String padLeftZeros(String inputString, int length) {
        return Strings.doPadLeft(inputString, length, '0');
    }

    private static String doPadLeft(String inputString, int length, char c) {
        if (inputString.length() >= length) {
            return inputString;
        }
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length - inputString.length()) {
            sb.append(c);
        }
        return sb.append(inputString).toString();
    }
}

