/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RequestResponseCapture {
    @JsonProperty(value="request_method")
    private String requestMethod;
    @JsonProperty(value="request_uri")
    private URI requestURI;
    @JsonProperty(value="request_headers")
    private Map<String, String> requestHeaders;
    @JsonProperty(value="response_status_code")
    private int responseStatusCode;
    @JsonProperty(value="response_headers")
    private Map<String, String> responseHeaders;
    @JsonProperty(value="response_entity")
    private String responseEntity;
    @JsonProperty(value="request_entity")
    private String requestEntity;

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public Map<String, String> getRequestHeaders() {
        return ImmutableMap.builder().putAll(this.requestHeaders).build();
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Map<String, String> getResponseHeaders() {
        return ImmutableMap.builder().putAll(this.responseHeaders).build();
    }

    public String getResponseEntity() {
        return this.responseEntity;
    }

    public String getRequestEntity() {
        return this.requestEntity;
    }
}

