/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.Company;
import io.intercom.api.CompanyCollection;
import io.intercom.api.DataResource;
import io.intercom.api.InvalidException;
import io.intercom.api.TagCollection;
import io.intercom.api.TypedData;
import io.intercom.api.User;
import io.intercom.api.UserCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Tag
extends TypedData {
    private static final Logger logger = LoggerFactory.getLogger((String)"intercom-java");
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "tag";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    public static Tag tag(Tag tag, UserCollection users) throws InvalidException, AuthorizationException {
        TagTypedCollection tagTypedCollection = Tag.createTagTypedCollection(tag, users);
        return DataResource.create(tagTypedCollection, "tags", Tag.class);
    }

    public static Tag tag(Tag tag, CompanyCollection companies) throws InvalidException, AuthorizationException {
        TagTypedCollection tagTypedCollection = Tag.createTagTypedCollection(tag, companies);
        return DataResource.create(tagTypedCollection, "tags", Tag.class);
    }

    public static Tag create(Tag tag) throws InvalidException, AuthorizationException {
        return DataResource.create(tag, "tags", Tag.class);
    }

    public static Tag update(Tag tag) throws InvalidException, AuthorizationException {
        if (tag.getId() == null) {
            throw new InvalidException("tag updates must supply an id");
        }
        return DataResource.update(tag, "tags", Tag.class);
    }

    public static Tag delete(String id) throws InvalidException, AuthorizationException {
        return DataResource.delete(id, "tags", Tag.class);
    }

    public static Tag delete(Tag tag) throws InvalidException, AuthorizationException {
        return Tag.delete(tag.getId());
    }

    public static TagCollection list() throws InvalidException, AuthorizationException {
        return DataResource.list(SENTINEL, "tags", TagCollection.class);
    }

    @VisibleForTesting
    static TagTypedCollection createTagTypedCollection(Tag tag, UserCollection users) {
        TagTypedCollection tagTypedCollection = new TagTypedCollection();
        tagTypedCollection.setName(tag.getName());
        tagTypedCollection.setId(tag.getId());
        ArrayList usersLite = Lists.newArrayList();
        List<User> pageItems = users.getPageItems();
        for (User user : pageItems) {
            HashMap userMap = Maps.newHashMap();
            String id = user.getId();
            String email = user.getEmail();
            String userId = user.getUserId();
            if (!Strings.isNullOrEmpty((String)id)) {
                userMap.put("id", id);
                usersLite.add(userMap);
                continue;
            }
            if (!Strings.isNullOrEmpty((String)email)) {
                userMap.put("email", email);
                usersLite.add(userMap);
                continue;
            }
            if (!Strings.isNullOrEmpty((String)userId)) {
                userMap.put("user_id", userId);
                usersLite.add(userMap);
                continue;
            }
            logger.warn("no identifiers found for user tag target, skipping [" + tag + "] [" + user.toString() + "]");
        }
        tagTypedCollection.setUsers(usersLite);
        return tagTypedCollection;
    }

    @VisibleForTesting
    static TagTypedCollection createTagTypedCollection(Tag tag, CompanyCollection companies) {
        TagTypedCollection tagTypedCollection = new TagTypedCollection();
        tagTypedCollection.setName(tag.getName());
        tagTypedCollection.setId(tag.getId());
        ArrayList companiesLite = Lists.newArrayList();
        List<Company> pageItems = companies.getPageItems();
        for (Company company : pageItems) {
            HashMap companyMap = Maps.newHashMap();
            String companyID = company.getCompanyID();
            String id1 = company.getId();
            String name = company.getName();
            if (!Strings.isNullOrEmpty((String)companyID)) {
                companyMap.put("company_id", companyID);
                companiesLite.add(companyMap);
            } else if (!Strings.isNullOrEmpty((String)id1)) {
                companyMap.put("id", id1);
                companiesLite.add(companyMap);
            } else if (!Strings.isNullOrEmpty((String)name)) {
                companyMap.put("name", name);
                companiesLite.add(companyMap);
            } else {
                logger.warn("no identifiers found for company tag target, skipping [" + tag + "] [" + company.toString() + "]");
            }
            tagTypedCollection.setCompanies(companiesLite);
        }
        return tagTypedCollection;
    }

    public String getType() {
        return "tag";
    }

    public String getId() {
        return this.id;
    }

    public Tag setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Tag setName(String name) {
        this.name = name;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.createdAt != tag.createdAt) {
            return false;
        }
        if (this.updatedAt != tag.updatedAt) {
            return false;
        }
        if (this.id != null ? !this.id.equals(tag.id) : tag.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(tag.name) : tag.name != null) {
            return false;
        }
        return "tag".equals(tag.type);
    }

    public int hashCode() {
        int result = "tag".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        return result;
    }

    public String toString() {
        return "Tag{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "} " + super.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    static class TagTypedCollection
    extends Tag {
        @JsonProperty(value="users")
        private List<Map<String, String>> users;
        @JsonProperty(value="companies")
        private List<Map<String, String>> companies;

        TagTypedCollection() {
        }

        public List<Map<String, String>> getUsers() {
            return this.users;
        }

        public void setUsers(List<Map<String, String>> usersLite) {
            this.users = usersLite;
        }

        public List<Map<String, String>> getCompanies() {
            return this.companies;
        }

        public void setCompanies(List<Map<String, String>> companies) {
            this.companies = companies;
        }
    }
}

