/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.SegmentCollection;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Segment
extends TypedData {
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "segment";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    public static Segment find(String id) throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("segments").path(id).build());
        return resource.get(Segment.class);
    }

    public static SegmentCollection list() throws InvalidException, AuthorizationException {
        return DataResource.list(SENTINEL, "segments", SegmentCollection.class);
    }

    public static Segment update(Segment segment) throws InvalidException, AuthorizationException {
        if (segment.getId() == null) {
            throw new InvalidException("segment updates must supply an id");
        }
        return DataResource.update(segment, "segments", Segment.class);
    }

    public String getType() {
        return "segment";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Segment setName(String name) {
        this.name = name;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        if (this.createdAt != segment.createdAt) {
            return false;
        }
        if (this.updatedAt != segment.updatedAt) {
            return false;
        }
        if (this.id != null ? !this.id.equals(segment.id) : segment.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(segment.name) : segment.name != null) {
            return false;
        }
        return "segment".equals(segment.type);
    }

    public int hashCode() {
        int result = "segment".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        return result;
    }

    public String toString() {
        return "Segment{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "} " + super.toString();
    }
}

