/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.Avatar;
import io.intercom.api.ClientException;
import io.intercom.api.CompanyCollection;
import io.intercom.api.CompanyWithStringPlan;
import io.intercom.api.ContactCollection;
import io.intercom.api.CustomAttribute;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.LocationData;
import io.intercom.api.RateLimitException;
import io.intercom.api.Replier;
import io.intercom.api.SegmentCollection;
import io.intercom.api.ServerException;
import io.intercom.api.SocialProfileCollection;
import io.intercom.api.TagCollection;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import io.intercom.api.User;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Contact
extends TypedData
implements Replier {
    private static final Map<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private final String type = "contact";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="user_id")
    private String userID;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="pseudonym")
    private String pseudonym;
    @JsonProperty(value="avatar")
    private Avatar avatar;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="unsubscribed_from_emails")
    private Boolean unsubscribedFromEmails;
    @JsonProperty(value="session_count")
    private int sessionCount;
    @JsonProperty(value="last_request_at")
    private long lastRequestAt;
    @JsonProperty(value="last_seen_ip")
    private String lastSeenIP;
    @JsonIgnoreProperties(ignoreUnknown=false)
    @JsonProperty(value="custom_attributes")
    private Map<String, CustomAttribute> customAttributes = Maps.newHashMap();
    @JsonProperty(value="user_agent_data")
    private String userAgentData;
    @JsonProperty(value="location_data")
    private LocationData locationData;
    @JsonIgnoreProperties(ignoreUnknown=false)
    @JsonProperty(value="companies")
    private CompanyCollection companyCollection = new CompanyCollection();
    @JsonProperty(value="social_profiles")
    private SocialProfileCollection socialProfileCollection = new SocialProfileCollection();
    @JsonProperty(value="segments")
    private SegmentCollection segmentCollection = new SegmentCollection();
    @JsonProperty(value="tags")
    private TagCollection tagCollection = new TagCollection();
    @JsonProperty(value="update_last_request_at")
    private Boolean updateLastRequestAt;
    @JsonProperty(value="new_session")
    private Boolean newSession;
    private Boolean untag;

    public static Contact findByID(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return new HttpClient(Contact.contactURI(id)).get(Contact.class);
    }

    public static Contact findByUserID(String userID) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        HashMap params = Maps.newHashMap();
        params.put("user_id", userID);
        return DataResource.find(params, "contacts", Contact.class);
    }

    public static ContactCollection listByEmail(String email) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        HashMap params = Maps.newHashMap();
        params.put("email", email);
        return Contact.list(params);
    }

    public static ContactCollection list(Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(params, "contacts", ContactCollection.class);
    }

    public static ContactCollection list() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(SENTINEL, "contacts", ContactCollection.class);
    }

    public static Contact create(Contact c) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.create(ContactUpdate.buildFrom(c), "contacts", Contact.class);
    }

    public static Contact update(Contact c) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.updatePut(ContactUpdate.buildFrom(c), Contact.contactURI(c.getID()), Contact.class);
    }

    public static Contact delete(Contact c) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.delete(c.getID(), "contacts", Contact.class);
    }

    public static User convert(Contact c, User u) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.post(ContactConvertBuilder.buildConvert(c, u), Contact.convertURI(), User.class);
    }

    private static URI contactURI(String id) {
        return UriBuilder.newBuilder().path("contacts").path(id).build();
    }

    private static URI convertURI() {
        return UriBuilder.newBuilder().path("contacts").path("convert").build();
    }

    public Contact untag() {
        this.untag = Boolean.TRUE;
        return this;
    }

    boolean isUntag() {
        return this.untag == null ? false : this.untag;
    }

    @Override
    @JsonIgnore
    public String getReplyType() {
        return this.getType() + "_reply";
    }

    @Override
    public String getType() {
        return "contact";
    }

    public String getID() {
        return this.id;
    }

    @VisibleForTesting
    Contact setID(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Contact setName(String name) {
        this.name = name;
        return this;
    }

    public String getPseudonym() {
        return this.pseudonym;
    }

    public String getEmail() {
        return this.email;
    }

    public Contact setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getUserID() {
        return this.userID;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public Boolean getUnsubscribedFromEmails() {
        return this.unsubscribedFromEmails;
    }

    public Contact setUnsubscribedFromEmails(boolean unsubscribedFromEmails) {
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        return this;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public long getLastRequestAt() {
        return this.lastRequestAt;
    }

    public Contact setLastRequestAt(long lastRequestAt) {
        this.lastRequestAt = lastRequestAt;
        return this;
    }

    public String getLastSeenIP() {
        return this.lastSeenIP;
    }

    public Contact setLastSeenIP(String lastSeenIP) {
        this.lastSeenIP = lastSeenIP;
        return this;
    }

    public Map<String, CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public Contact setCustomAttributes(Map<String, CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
        return this;
    }

    public Contact addCustomAttribute(CustomAttribute customAttribute) {
        this.customAttributes.put(customAttribute.getName(), customAttribute);
        return this;
    }

    public String getUserAgentData() {
        return this.userAgentData;
    }

    public LocationData getLocationData() {
        return this.locationData;
    }

    public CompanyCollection getCompanyCollection() {
        return this.companyCollection;
    }

    public SocialProfileCollection getSocialProfileCollection() {
        return this.socialProfileCollection;
    }

    public SegmentCollection getSegmentCollection() {
        return this.segmentCollection;
    }

    public TagCollection getTagCollection() {
        return this.tagCollection;
    }

    public Boolean isUpdateLastRequestAt() {
        return this.updateLastRequestAt;
    }

    public Boolean isNewSession() {
        return this.newSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        if (this.createdAt != contact.createdAt) {
            return false;
        }
        if (this.updatedAt != contact.updatedAt) {
            return false;
        }
        if (this.sessionCount != contact.sessionCount) {
            return false;
        }
        if (this.lastRequestAt != contact.lastRequestAt) {
            return false;
        }
        if (!"contact".equals(contact.type)) {
            return false;
        }
        if (this.id != null ? !this.id.equals(contact.id) : contact.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(contact.name) : contact.name != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(contact.email) : contact.email != null) {
            return false;
        }
        if (this.userID != null ? !this.userID.equals(contact.userID) : contact.userID != null) {
            return false;
        }
        if (this.avatar != null ? !this.avatar.equals(contact.avatar) : contact.avatar != null) {
            return false;
        }
        if (this.unsubscribedFromEmails != null ? !this.unsubscribedFromEmails.equals(contact.unsubscribedFromEmails) : contact.unsubscribedFromEmails != null) {
            return false;
        }
        if (this.lastSeenIP != null ? !this.lastSeenIP.equals(contact.lastSeenIP) : contact.lastSeenIP != null) {
            return false;
        }
        if (this.customAttributes != null ? !this.customAttributes.equals(contact.customAttributes) : contact.customAttributes != null) {
            return false;
        }
        if (this.userAgentData != null ? !this.userAgentData.equals(contact.userAgentData) : contact.userAgentData != null) {
            return false;
        }
        if (this.locationData != null ? !this.locationData.equals(contact.locationData) : contact.locationData != null) {
            return false;
        }
        if (this.companyCollection != null ? !this.companyCollection.equals(contact.companyCollection) : contact.companyCollection != null) {
            return false;
        }
        if (this.socialProfileCollection != null ? !this.socialProfileCollection.equals(contact.socialProfileCollection) : contact.socialProfileCollection != null) {
            return false;
        }
        if (this.segmentCollection != null ? !this.segmentCollection.equals(contact.segmentCollection) : contact.segmentCollection != null) {
            return false;
        }
        if (this.tagCollection != null ? !this.tagCollection.equals(contact.tagCollection) : contact.tagCollection != null) {
            return false;
        }
        if (this.updateLastRequestAt != null ? !this.updateLastRequestAt.equals(contact.updateLastRequestAt) : contact.updateLastRequestAt != null) {
            return false;
        }
        if (this.newSession != null ? !this.newSession.equals(contact.newSession) : contact.newSession != null) {
            return false;
        }
        return !(this.untag == null ? contact.untag != null : !this.untag.equals(contact.untag));
    }

    public int hashCode() {
        int result = "contact".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.userID != null ? this.userID.hashCode() : 0);
        result = 31 * result + (this.avatar != null ? this.avatar.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (this.unsubscribedFromEmails != null ? this.unsubscribedFromEmails.hashCode() : 0);
        result = 31 * result + this.sessionCount;
        result = 31 * result + (int)(this.lastRequestAt ^ this.lastRequestAt >>> 32);
        result = 31 * result + (this.lastSeenIP != null ? this.lastSeenIP.hashCode() : 0);
        result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
        result = 31 * result + (this.userAgentData != null ? this.userAgentData.hashCode() : 0);
        result = 31 * result + (this.locationData != null ? this.locationData.hashCode() : 0);
        result = 31 * result + (this.companyCollection != null ? this.companyCollection.hashCode() : 0);
        result = 31 * result + (this.socialProfileCollection != null ? this.socialProfileCollection.hashCode() : 0);
        result = 31 * result + (this.segmentCollection != null ? this.segmentCollection.hashCode() : 0);
        result = 31 * result + (this.tagCollection != null ? this.tagCollection.hashCode() : 0);
        result = 31 * result + (this.updateLastRequestAt != null ? this.updateLastRequestAt.hashCode() : 0);
        result = 31 * result + (this.newSession != null ? this.newSession.hashCode() : 0);
        result = 31 * result + (this.untag != null ? this.untag.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Contact{type='contact', id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", userID='" + this.userID + '\'' + ", avatar=" + this.avatar + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", unsubscribedFromEmails=" + this.unsubscribedFromEmails + ", sessionCount=" + this.sessionCount + ", lastRequestAt=" + this.lastRequestAt + ", lastSeenIP='" + this.lastSeenIP + '\'' + ", customAttributes=" + this.customAttributes + ", userAgentData='" + this.userAgentData + '\'' + ", locationData=" + this.locationData + ", companyCollection=" + this.companyCollection + ", socialProfileCollection=" + this.socialProfileCollection + ", segmentCollection=" + this.segmentCollection + ", tagCollection=" + this.tagCollection + ", updateLastRequestAt=" + this.updateLastRequestAt + ", newSession=" + this.newSession + ", untag=" + this.untag + "} " + super.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    static class ContactUpdate
    extends TypedData {
        @JsonProperty(value="type")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private String type;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="user_id")
        private String userID;
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="last_seen_ip")
        private String lastSeenIP;
        @JsonIgnoreProperties(ignoreUnknown=false)
        @JsonProperty(value="custom_attributes")
        private Map<String, CustomAttribute> customAttributes = Maps.newHashMap();
        @JsonProperty(value="last_seen_user_agent")
        private String lastSeenUserAgent;
        @JsonProperty(value="companies")
        private List<CompanyWithStringPlan> companyCollection;
        @JsonProperty(value="last_request_at")
        private long lastRequestAt;
        @JsonProperty(value="signed_up_at")
        private long signedUpAt;
        @JsonProperty(value="unsubscribed_from_emails")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean unsubscribedFromEmails;
        @JsonProperty(value="update_last_request_at")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean updateLastRequestAt;
        @JsonProperty(value="new_session")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean newSession;

        static ContactUpdate buildFrom(Contact c) {
            ContactUpdate contactUpdate = new ContactUpdate();
            contactUpdate.id = c.getID();
            contactUpdate.userID = c.getUserID();
            contactUpdate.email = c.getEmail();
            contactUpdate.name = c.getName();
            contactUpdate.lastSeenIP = c.getLastSeenIP();
            contactUpdate.customAttributes = c.getCustomAttributes();
            contactUpdate.lastRequestAt = c.getLastRequestAt();
            contactUpdate.unsubscribedFromEmails = c.getUnsubscribedFromEmails();
            return contactUpdate;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getID() {
            return this.id;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getEmail() {
            return this.email;
        }

        public String getName() {
            return this.name;
        }

        public String getLastSeenIP() {
            return this.lastSeenIP;
        }

        public Map<String, CustomAttribute> getCustomAttributes() {
            return this.customAttributes;
        }

        public String getLastSeenUserAgent() {
            return this.lastSeenUserAgent;
        }

        public List<CompanyWithStringPlan> getCompanyCollection() {
            return this.companyCollection;
        }

        public long getLastRequestAt() {
            return this.lastRequestAt;
        }

        public Boolean getUnsubscribedFromEmails() {
            return this.unsubscribedFromEmails;
        }

        public Boolean isUpdateLastRequestAt() {
            return this.updateLastRequestAt;
        }

        public Boolean isNewSession() {
            return this.newSession;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    static class ContactConvert {
        @JsonProperty(value="contact")
        private Map<String, String> contact;
        @JsonProperty(value="user")
        private Map<String, String> user;

        public ContactConvert() {
        }

        public ContactConvert(Map<String, String> contact, Map<String, String> user) {
            this.contact = contact;
            this.user = user;
        }

        public Map<String, String> getContact() {
            return this.contact;
        }

        public void setContact(Map<String, String> contact) {
            this.contact = contact;
        }

        public Map<String, String> getUser() {
            return this.user;
        }

        public void setUser(Map<String, String> user) {
            this.user = user;
        }
    }

    static class ContactConvertBuilder {
        ContactConvertBuilder() {
        }

        static ContactConvert buildConvert(Contact c, User u) throws InvalidException {
            return new ContactConvertBuilder().build(c, u);
        }

        ContactConvert build(Contact c, User u) throws InvalidException {
            return new ContactConvert(this.buildConvertContact(c), this.buildConvertUser(u));
        }

        HashMap<String, String> buildConvertUser(User u) {
            HashMap convertUser = Maps.newHashMap();
            if (u.getId() != null) {
                convertUser.put("id", u.getId());
            }
            if (u.getUserId() != null) {
                convertUser.put("user_id", u.getUserId());
            }
            if (u.getEmail() != null) {
                convertUser.put("email", u.getEmail());
            }
            this.checkValidConvertContact(convertUser);
            return convertUser;
        }

        void checkValidConvertContact(HashMap<String, String> convertUser) {
            if (!(convertUser.containsKey("id") || convertUser.containsKey("user_id") || convertUser.containsKey("email"))) {
                throw new InvalidException("a convert user must include at least one of, an id, user_id or email parameter");
            }
        }

        HashMap<String, String> buildConvertContact(Contact c) {
            HashMap convertContact = Maps.newHashMap();
            if (c.getID() != null) {
                convertContact.put("id", c.getID());
            }
            if (c.getUserID() != null) {
                convertContact.put("user_id", c.getUserID());
            }
            this.checkValidConvertUser(convertContact);
            return convertContact;
        }

        void checkValidConvertUser(HashMap<String, String> convertContact) {
            if (!convertContact.containsKey("id") && !convertContact.containsKey("user_id")) {
                throw new InvalidException("a convert contact must include at least one of, an id or a user_id parameter");
            }
        }
    }
}

