/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.InvalidException;
import io.intercom.api.MapperSupport;
import io.intercom.api.NotificationData;
import io.intercom.api.TypedData;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

@JsonIgnoreProperties(value={"intercom"})
public class Notification
extends TypedData {
    @JsonProperty(value="type")
    private final String type = "notification_event";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="app_id")
    private String appID;
    @JsonProperty(value="data")
    private NotificationData data;
    @JsonProperty(value="delivery_status")
    private String deliveryStatus;
    @JsonProperty(value="delivery_attempts")
    private int deliveryAttempts;
    @JsonProperty(value="delivered_at")
    private long deliveredAt;
    @JsonProperty(value="first_sent_at")
    private long firstSentAt;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty
    private Map<String, URI> links = Maps.newHashMap();
    @JsonProperty(value="self")
    private URI self;

    public static Notification readJSON(String json) throws InvalidException {
        try {
            return (Notification)MapperSupport.objectMapper().readValue(json, Notification.class);
        }
        catch (IOException e) {
            throw new InvalidException("could not parse json string [" + e.getMessage() + "]", (Throwable)e);
        }
    }

    public static Notification readJSON(InputStream json) throws InvalidException {
        try {
            return (Notification)MapperSupport.objectMapper().readValue(json, Notification.class);
        }
        catch (IOException e) {
            throw new InvalidException("could not parse json stream [" + e.getMessage() + "]", (Throwable)e);
        }
    }

    @Override
    public String getType() {
        return "notification_event";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public NotificationData getData() {
        return this.data;
    }

    public void setData(NotificationData data) {
        this.data = data;
    }

    public String getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public void setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public int getDeliveryAttempts() {
        return this.deliveryAttempts;
    }

    public void setDeliveryAttempts(int deliveryAttempts) {
        this.deliveryAttempts = deliveryAttempts;
    }

    public long getDeliveredAt() {
        return this.deliveredAt;
    }

    public void setDeliveredAt(long deliveredAt) {
        this.deliveredAt = deliveredAt;
    }

    public long getFirstSentAt() {
        return this.firstSentAt;
    }

    public void setFirstSentAt(long firstSentAt) {
        this.firstSentAt = firstSentAt;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, URI> links) {
        this.links = links;
    }

    public URI getSelf() {
        return this.self;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.appID != null ? this.appID.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.deliveryStatus != null ? this.deliveryStatus.hashCode() : 0);
        result = 31 * result + this.deliveryAttempts;
        result = 31 * result + (int)(this.deliveredAt ^ this.deliveredAt >>> 32);
        result = 31 * result + (int)(this.firstSentAt ^ this.firstSentAt >>> 32);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.self != null ? this.self.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (this.deliveredAt != that.deliveredAt) {
            return false;
        }
        if (this.deliveryAttempts != that.deliveryAttempts) {
            return false;
        }
        if (this.firstSentAt != that.firstSentAt) {
            return false;
        }
        if (this.appID != null ? !this.appID.equals(that.appID) : that.appID != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.deliveryStatus != null ? !this.deliveryStatus.equals(that.deliveryStatus) : that.deliveryStatus != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.self != null ? !this.self.equals(that.self) : that.self != null) {
            return false;
        }
        return !(this.topic != null ? !this.topic.equals(that.topic) : that.topic != null);
    }

    public String toString() {
        return "Notification{type='notification_event', id='" + this.id + '\'' + ", topic='" + this.topic + '\'' + ", appID='" + this.appID + '\'' + ", data=" + this.data + ", deliveryStatus='" + this.deliveryStatus + '\'' + ", deliveryAttempts=" + this.deliveryAttempts + ", deliveredAt=" + this.deliveredAt + ", firstSentAt=" + this.firstSentAt + ", createdAt=" + this.createdAt + ", links=" + this.links + ", self=" + this.self + "} " + super.toString();
    }
}

