/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.intercom.api.AuthorizationException;
import io.intercom.api.ClientException;
import io.intercom.api.Error;
import io.intercom.api.ErrorCollection;
import io.intercom.api.HttpConnectorSupplier;
import io.intercom.api.IOUtils;
import io.intercom.api.Intercom;
import io.intercom.api.IntercomException;
import io.intercom.api.InvalidException;
import io.intercom.api.MapperSupport;
import io.intercom.api.NotFoundException;
import io.intercom.api.RateLimitException;
import io.intercom.api.ServerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"intercom-java");
    private static final String CLIENT_AGENT_DETAILS = HttpClient.clientAgentDetails();
    private static final String USER_AGENT = "intercom-java/2.2.7";
    private static final String UTF_8 = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    public static final String RATE_LIMIT_HEADER = "X-RateLimit-Limit";
    public static final String RATE_LIMIT_REMAINING_HEADER = "X-RateLimit-Remaining";
    public static final String RATE_LIMIT_RESET_HEADER = "X-RateLimit-Reset";
    private final ObjectMapper objectMapper;
    private final URI uri;
    private final Map<String, String> headers;
    private final HttpConnectorSupplier connection = Intercom.getHttpConnectorSupplier();

    private static String clientAgentDetails() {
        HashMap map = Maps.newHashMap();
        ArrayList propKeys = Lists.newArrayList((Object[])new String[]{"os.arch", "os.name", "os.version", "user.language", "user.timezone", "java.class.version", "java.runtime.version", "java.version", "java.vm.name", "java.vm.vendor", "java.vm.version"});
        for (String propKey : propKeys) {
            map.put(propKey, System.getProperty(propKey));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MapperSupport.objectMapper().disable(SerializationFeature.INDENT_OUTPUT).writeValue((OutputStream)baos, (Object)map);
        }
        catch (IOException e) {
            logger.warn(String.format("could not serialize client agent details [%s]", e.getMessage()), (Throwable)e);
        }
        return baos.toString();
    }

    public HttpClient(URI uri) {
        this(uri, Maps.newHashMap());
    }

    private HttpClient(URI uri, Map<String, String> headers) {
        this.uri = uri;
        this.headers = headers;
        this.objectMapper = MapperSupport.objectMapper();
    }

    public <T> T get(Class<T> reqres) throws IntercomException {
        return this.get(this.getJavaType(reqres));
    }

    <T> T get(JavaType responseType) throws IntercomException {
        return this.executeHttpMethod("GET", null, responseType);
    }

    public <T> T delete(Class<T> reqres) {
        return this.executeHttpMethod("DELETE", null, this.getJavaType(reqres));
    }

    public <T, E> T put(Class<T> reqres, E entity) {
        this.headers.put("Content-Type", APPLICATION_JSON);
        return this.executeHttpMethod("PUT", entity, this.getJavaType(reqres));
    }

    public <T, E> T post(Class<T> reqres, E entity) {
        this.headers.put("Content-Type", APPLICATION_JSON);
        return this.executeHttpMethod("POST", entity, this.getJavaType(reqres));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E> T executeHttpMethod(String method, E entity, JavaType responseType) {
        T t;
        HttpURLConnection conn = null;
        try {
            conn = this.initializeConnection(this.uri, method);
            if (entity != null) {
                this.prepareRequestEntity(entity, conn);
            }
            t = this.runRequest(this.uri, responseType, conn);
        }
        catch (IOException e) {
            T t2;
            try {
                t2 = this.throwLocalException(e);
            }
            catch (Throwable throwable) {
                IOUtils.disconnectQuietly(conn);
                throw throwable;
            }
            IOUtils.disconnectQuietly(conn);
            return t2;
        }
        IOUtils.disconnectQuietly(conn);
        return t;
    }

    private <T> JavaType getJavaType(Class<T> reqres) {
        return this.objectMapper.getTypeFactory().constructType(reqres);
    }

    private <T> T throwLocalException(IOException e) {
        throw new IntercomException(String.format("Local exception calling [%s]. Check connectivity and settings. [%s]", this.uri.toASCIIString(), e.getMessage()), (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareRequestEntity(Object entity, HttpURLConnection conn) throws IOException {
        conn.setDoOutput(true);
        OutputStream stream = null;
        try {
            stream = conn.getOutputStream();
            if (logger.isDebugEnabled()) {
                logger.info(String.format("api server request --\n%s\n-- ", this.objectMapper.writeValueAsString(entity)));
            }
            this.objectMapper.writeValue(stream, entity);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    private HttpURLConnection initializeConnection(URI uri, String method) throws IOException {
        HttpURLConnection conn = this.connection.connect(uri);
        conn.setRequestMethod(method);
        conn = this.prepareConnection(conn);
        conn = this.applyHeaders(conn);
        return conn;
    }

    private <T> T runRequest(URI uri, JavaType javaType, HttpURLConnection conn) throws IOException {
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            return this.handleSuccess(javaType, conn, responseCode);
        }
        return this.handleError(uri, conn, responseCode);
    }

    private <T> T handleError(URI uri, HttpURLConnection conn, int responseCode) throws IOException {
        ErrorCollection errors;
        try {
            errors = (ErrorCollection)this.objectMapper.readValue(conn.getErrorStream(), ErrorCollection.class);
        }
        catch (IOException e) {
            errors = this.createUnprocessableErrorResponse(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("error json follows --\n{}\n-- ", (Object)this.objectMapper.writeValueAsString((Object)errors));
        }
        return this.throwException(responseCode, errors, conn);
    }

    private <T> T handleSuccess(JavaType javaType, HttpURLConnection conn, int responseCode) throws IOException {
        if (this.shouldSkipResponseEntity(javaType, conn, responseCode)) {
            return null;
        }
        return this.readEntity(conn, responseCode, javaType);
    }

    private boolean shouldSkipResponseEntity(JavaType javaType, HttpURLConnection conn, int responseCode) {
        return responseCode == 204 || Void.class.equals((Object)javaType.getRawClass()) || "DELETE".equals(conn.getRequestMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readEntity(HttpURLConnection conn, int responseCode, JavaType javaType) throws IOException {
        InputStream entityStream = conn.getInputStream();
        try {
            if (logger.isDebugEnabled()) {
                String text = CharStreams.toString((Readable)new InputStreamReader(entityStream));
                logger.debug("api server response status[{}] --\n{}\n-- ", (Object)responseCode, (Object)text);
                Object object = this.objectMapper.readValue(text, javaType);
                return (T)object;
            }
            Object object = this.objectMapper.readValue(entityStream, javaType);
            return (T)object;
        }
        finally {
            IOUtils.closeQuietly(entityStream);
        }
    }

    private <T> T throwException(int responseCode, ErrorCollection errors, HttpURLConnection conn) {
        if (responseCode == 403 || responseCode == 401) {
            throw new AuthorizationException(errors);
        }
        if (responseCode == 429) {
            throw new RateLimitException(errors, Ints.tryParse((String)conn.getHeaderField(RATE_LIMIT_HEADER)), Ints.tryParse((String)conn.getHeaderField(RATE_LIMIT_REMAINING_HEADER)), Longs.tryParse((String)conn.getHeaderField(RATE_LIMIT_RESET_HEADER)));
        }
        if (responseCode == 404) {
            throw new NotFoundException(errors);
        }
        if (responseCode == 422) {
            throw new InvalidException(errors);
        }
        if (responseCode == 400 || responseCode == 405 || responseCode == 406) {
            throw new ClientException(errors);
        }
        if (responseCode == 500 || responseCode == 503) {
            throw new ServerException(errors);
        }
        throw new IntercomException(errors);
    }

    private HttpURLConnection applyHeaders(HttpURLConnection conn) {
        for (Map.Entry<String, String> entry : this.createHeaders().entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.createAuthorizationHeaders().entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return conn;
    }

    private HttpURLConnection prepareConnection(HttpURLConnection conn) {
        conn.setConnectTimeout(Intercom.getConnectionTimeout());
        conn.setReadTimeout(Intercom.getRequestTimeout());
        conn.setUseCaches(Intercom.isRequestUsingCaches());
        return conn;
    }

    private Map<String, String> createAuthorizationHeaders() {
        switch (Intercom.getAuthKeyType()) {
            case API_KEY: {
                this.headers.put("Authorization", "Basic " + this.generateAuthString(Intercom.getAppID(), Intercom.getApiKey()));
                break;
            }
            case TOKEN: {
                this.headers.put("Authorization", "Basic " + this.generateAuthString(Intercom.getToken(), ""));
            }
        }
        return this.headers;
    }

    private String generateAuthString(String username, String password) {
        return Base64.encodeBase64String((byte[])(username + ":" + password).getBytes());
    }

    private Map<String, String> createHeaders() {
        this.headers.put("User-Agent", USER_AGENT);
        this.headers.put("X-Client-Platform-Details", CLIENT_AGENT_DETAILS);
        this.headers.put("Accept-Charset", UTF_8);
        this.headers.put("Accept", APPLICATION_JSON);
        return this.headers;
    }

    private ErrorCollection createUnprocessableErrorResponse(IOException e) {
        long grepCode = this.getGrepCode();
        String msg = String.format("could not parse error response: [%s]", e.getLocalizedMessage());
        logger.error(String.format("[%016x] %s", grepCode, msg), (Throwable)e);
        Error err = new Error("unprocessable_entity", String.format("%s logged with code [%016x]", msg, grepCode));
        ErrorCollection errors = new ErrorCollection(Lists.newArrayList((Object[])new Error[]{err}));
        return errors;
    }

    private long getGrepCode() {
        return ThreadLocalRandom.current().nextLong();
    }
}

