/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.Admin;
import io.intercom.api.AuthorizationException;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.UriBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Counts {
    @JsonProperty(value="type")
    private String type = "count";
    @JsonProperty(value="company")
    private Company company;
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="conversation")
    private Conversation conversation;

    static Counts countQuery(Map<String, String> query) {
        URI build = UriBuilder.newBuilder().path("counts").query(query).build();
        HttpClient resource = new HttpClient(build);
        return resource.get(Counts.class);
    }

    public static Totals appTotals() throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("counts").build());
        return resource.get(Totals.class);
    }

    public static List<CountItem> userTags() throws InvalidException, AuthorizationException {
        HashMap params = Maps.newHashMap();
        params.put("type", "user");
        params.put("count", "tag");
        return Counts.countQuery(params).getUser().getTags();
    }

    public static List<CountItem> userSegments() throws InvalidException, AuthorizationException {
        HashMap params = Maps.newHashMap();
        params.put("type", "user");
        params.put("count", "segment");
        return Counts.countQuery(params).getUser().getSegments();
    }

    public static Conversation conversationTotals() throws InvalidException, AuthorizationException {
        HashMap params = Maps.newHashMap();
        params.put("type", "conversation");
        return Counts.countQuery(params).getConversation();
    }

    public static Conversation conversationAdmins() throws InvalidException, AuthorizationException {
        HashMap params = Maps.newHashMap();
        params.put("type", "conversation");
        params.put("count", "admin");
        return Counts.countQuery(params).getConversation();
    }

    public static List<CountItem> companySegments() throws InvalidException, AuthorizationException {
        HashMap params = Maps.newHashMap();
        params.put("type", "company");
        params.put("count", "segment");
        return Counts.countQuery(params).getCompany().getSegments();
    }

    public static List<CountItem> companyTags() throws InvalidException, AuthorizationException {
        HashMap params = Maps.newHashMap();
        params.put("type", "company");
        params.put("count", "tag");
        return Counts.countQuery(params).getCompany().getTags();
    }

    public static List<CountItem> companyUsers() throws InvalidException, AuthorizationException {
        HashMap params = Maps.newHashMap();
        params.put("type", "company");
        params.put("count", "user");
        return Counts.countQuery(params).getCompany().getUsers();
    }

    public String getType() {
        return this.type;
    }

    public Company getCompany() {
        return this.company;
    }

    public User getUser() {
        return this.user;
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public String toString() {
        return "Counts{type='" + this.type + '\'' + ", company=" + this.company + ", user=" + this.user + ", conversation=" + this.conversation + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Company {
        @JsonProperty(value="company")
        private long companies;
        @JsonProperty(value="tag")
        private List<CountItem> tags;
        @JsonProperty(value="user")
        private List<CountItem> users;
        @JsonProperty(value="segment")
        private List<CountItem> segments;

        Company() {
        }

        public long getCompanies() {
            return this.companies;
        }

        public List<CountItem> getTags() {
            return this.tags;
        }

        public List<CountItem> getUsers() {
            return this.users;
        }

        public List<CountItem> getSegments() {
            return this.segments;
        }

        public String toString() {
            return "Company{companies=" + this.companies + ", tags=" + this.tags + ", users=" + this.users + ", segments=" + this.segments + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class User {
        @JsonProperty(value="user")
        private long user;
        @JsonProperty(value="tag")
        private List<CountItem> tags;
        @JsonProperty(value="segment")
        private List<CountItem> segments;

        User() {
        }

        public long getUser() {
            return this.user;
        }

        public List<CountItem> getTags() {
            return this.tags;
        }

        public List<CountItem> getSegments() {
            return this.segments;
        }

        public String toString() {
            return "User{user=" + this.user + ", tags=" + this.tags + ", segments=" + this.segments + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Conversation {
        @JsonProperty(value="admin")
        List<Admin> admins;
        @JsonProperty(value="assigned")
        private long assigned;
        @JsonProperty(value="closed")
        private long closed;
        @JsonProperty(value="open")
        private long open;
        @JsonProperty(value="unassigned")
        private long unassigned;

        Conversation() {
        }

        public List<Admin> getAdmins() {
            return this.admins;
        }

        public long getAssigned() {
            return this.assigned;
        }

        public long getClosed() {
            return this.closed;
        }

        public long getOpen() {
            return this.open;
        }

        public long getUnassigned() {
            return this.unassigned;
        }

        public String toString() {
            return "Conversation{assigned=" + this.assigned + ", closed=" + this.closed + ", open=" + this.open + ", unassigned=" + this.unassigned + ", admins=" + this.admins + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class CountItem {
        private String name;
        private long value;

        public CountItem(String name, long value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        public String toString() {
            return "CountItem{name='" + this.name + '\'' + ", value=" + this.value + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Totals {
        @JsonProperty(value="company")
        private CountItem company;
        @JsonProperty(value="segment")
        private CountItem segment;
        @JsonProperty(value="tag")
        private CountItem tag;
        @JsonProperty(value="user")
        private CountItem user;

        public CountItem getCompany() {
            return this.company;
        }

        public CountItem getSegment() {
            return this.segment;
        }

        public CountItem getTag() {
            return this.tag;
        }

        public CountItem getUser() {
            return this.user;
        }

        public String toString() {
            return "Totals{company=" + this.company + ", segment=" + this.segment + ", tag=" + this.tag + ", user=" + this.user + '}';
        }
    }
}

