/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.intercom.api.Company;
import io.intercom.api.CompanyCollection;
import io.intercom.api.CompanyWithStringPlan;
import java.util.ArrayList;
import java.util.List;

class CompanyUpdateBuilder {
    CompanyUpdateBuilder() {
    }

    static List<CompanyWithStringPlan> buildUserUpdateCompanies(CompanyCollection add, CompanyCollection remove) {
        List<Company> companies;
        ArrayList updatableCompanies = Lists.newArrayList();
        if (add != null) {
            companies = add.getPage();
            for (Company company : companies) {
                if (CompanyUpdateBuilder.isCompanyInList(company, remove)) continue;
                updatableCompanies.add(CompanyUpdateBuilder.prepareUpdatableCompany(company));
            }
        }
        if (remove != null) {
            companies = remove.getPage();
            for (Company company : companies) {
                updatableCompanies.add(CompanyUpdateBuilder.prepareUpdatableCompany(company).setRemove(Boolean.TRUE));
            }
        }
        return updatableCompanies;
    }

    private static boolean isCompanyInList(final Company company, CompanyCollection companyCollection) {
        if (companyCollection == null) {
            return false;
        }
        return Iterables.any(companyCollection.getPage(), (Predicate)new Predicate<Company>(){

            public boolean apply(Company e) {
                return Objects.equal((Object)company.getCompanyID(), (Object)e.getCompanyID()) || Objects.equal((Object)company.getId(), (Object)e.getId());
            }
        });
    }

    private static CompanyWithStringPlan prepareUpdatableCompany(Company company) {
        CompanyWithStringPlan updatableCompany = new CompanyWithStringPlan();
        updatableCompany.setId(company.getId());
        updatableCompany.setCompanyID(company.getCompanyID());
        updatableCompany.setName(company.getName());
        updatableCompany.setSessionCount(company.getSessionCount());
        updatableCompany.setMonthlySpend(company.getMonthlySpend());
        updatableCompany.setRemoteCreatedAt(company.getRemoteCreatedAt());
        updatableCompany.setIndustry(company.getIndustry());
        updatableCompany.setSize(company.getSize());
        updatableCompany.setWebsite(company.getWebsite());
        if (company.getCustomAttributes() != null) {
            updatableCompany.getCustomAttributes().putAll(company.getCustomAttributes());
        }
        if (company.getPlan() != null) {
            updatableCompany.setPlan(company.getPlan().getName());
        }
        return updatableCompany;
    }
}

