/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.Avatar;
import io.intercom.api.ClientException;
import io.intercom.api.Company;
import io.intercom.api.CompanyCollection;
import io.intercom.api.CompanyUpdateBuilder;
import io.intercom.api.CompanyWithStringPlan;
import io.intercom.api.CustomAttribute;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.Job;
import io.intercom.api.JobItem;
import io.intercom.api.JobItemCollection;
import io.intercom.api.JobSupport;
import io.intercom.api.LocationData;
import io.intercom.api.RateLimitException;
import io.intercom.api.Replier;
import io.intercom.api.ScrollableUserCollection;
import io.intercom.api.SegmentCollection;
import io.intercom.api.ServerException;
import io.intercom.api.SocialProfileCollection;
import io.intercom.api.TagCollection;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import io.intercom.api.UserCollection;
import io.intercom.api.UserPermanentDeleteRequest;
import io.intercom.api.UserPermanentDeleteResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class User
extends TypedData
implements Replier {
    private static final Map<String, String> SENTINEL = Maps.newHashMap();
    private static final ArrayList<String> BULK_PATHS = Lists.newArrayListWithExpectedSize((int)2);
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private final String type = "user";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="phone")
    private String phone;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="pseudonym")
    private String pseudonym;
    @JsonProperty(value="avatar")
    private Avatar avatar;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="remote_created_at")
    private long remoteCreatedAt;
    @JsonProperty(value="unsubscribed_from_emails")
    private Boolean unsubscribedFromEmails;
    @JsonProperty(value="session_count")
    private int sessionCount;
    @JsonProperty(value="last_request_at")
    private long lastRequestAt;
    @JsonProperty(value="signed_up_at")
    private long signedUpAt;
    @JsonProperty(value="last_seen_ip")
    private String lastSeenIp;
    @JsonIgnoreProperties(ignoreUnknown=false)
    @JsonProperty(value="custom_attributes")
    private Map<String, CustomAttribute> customAttributes = Maps.newHashMap();
    @JsonProperty(value="user_agent_data")
    private String userAgentData;
    @JsonProperty(value="location_data")
    private LocationData locationData;
    @JsonIgnoreProperties(ignoreUnknown=false)
    @JsonProperty(value="companies")
    private CompanyCollection companyCollection = new CompanyCollection();
    @JsonProperty(value="social_profiles")
    private SocialProfileCollection socialProfileCollection = new SocialProfileCollection();
    @JsonProperty(value="segments")
    private SegmentCollection segmentCollection = new SegmentCollection();
    @JsonProperty(value="tags")
    private TagCollection tagCollection = new TagCollection();
    @JsonProperty(value="update_last_request_at")
    private Boolean updateLastRequestAt;
    @JsonProperty(value="new_session")
    private Boolean newSession;
    private Boolean untag;
    private CompanyCollection removeCompanyCollection = new CompanyCollection();

    private static List<CompanyWithStringPlan> buildUserUpdateCompanies(User user) {
        return CompanyUpdateBuilder.buildUserUpdateCompanies(user.getCompanyCollection(), user.getRemoveCompanyCollection());
    }

    public static User find(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        URI users = UriBuilder.newBuilder().path("users").path(id).build();
        HttpClient resource = new HttpClient(users);
        return resource.get(User.class);
    }

    public static User find(Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        if (!params.containsKey("email") && !params.containsKey("user_id")) {
            throw new InvalidException("a user find must include an email or user_id parameter");
        }
        return DataResource.find(params, "users", User.class);
    }

    public static User create(User user) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.create(UserUpdate.buildFrom(user), "users", User.class);
    }

    public static User update(User user) throws InvalidException, AuthorizationException {
        return DataResource.update(UserUpdate.buildFrom(user), "users", User.class);
    }

    public static User delete(String id) {
        return User.archive(id);
    }

    public static User archive(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.delete(id, "users", User.class);
    }

    public static UserPermanentDeleteResponse permanentDelete(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        URI uri = UriBuilder.newBuilder().path("user_delete_requests").build();
        return new HttpClient(uri).post(UserPermanentDeleteResponse.class, new UserPermanentDeleteRequest(id));
    }

    @Deprecated
    public static User delete(Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return User.archive(params);
    }

    public static User archive(Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.delete(params, "users", User.class);
    }

    public static UserCollection list(Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(params, "users", UserCollection.class);
    }

    public static UserCollection list() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(SENTINEL, "users", UserCollection.class);
    }

    public static ScrollableUserCollection scroll() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.scroll(null, "users", ScrollableUserCollection.class);
    }

    public static Job submit(List<JobItem<User>> items) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return User.submit(items, null);
    }

    public static Job submit(List<JobItem<User>> items, Job job) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return Job.submit(UserUpdate.validateAndConvertJobItems(items), job, BULK_PATHS);
    }

    public static JobItemCollection<User> listJobErrorFeed(String jobID) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return Job.listJobErrorFeed(jobID, User.class);
    }

    public User untag() {
        this.untag = Boolean.TRUE;
        return this;
    }

    boolean isUntag() {
        return this.untag == null ? false : this.untag;
    }

    @Override
    @JsonIgnore
    public String getReplyType() {
        return this.getType() + "_reply";
    }

    @Override
    public String getType() {
        return "user";
    }

    public String getId() {
        return this.id;
    }

    public User setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public User setName(String name) {
        this.name = name;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public User setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public User setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public User setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getPseudonym() {
        return this.pseudonym;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public User setAvatar(Avatar avatar) {
        this.avatar = avatar;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public long getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    public User setRemoteCreatedAt(long remoteCreatedAt) {
        this.remoteCreatedAt = remoteCreatedAt;
        return this;
    }

    public Boolean getUnsubscribedFromEmails() {
        return this.unsubscribedFromEmails;
    }

    public User setUnsubscribedFromEmails(boolean unsubscribedFromEmails) {
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        return this;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public long getLastRequestAt() {
        return this.lastRequestAt;
    }

    public User setLastRequestAt(long lastRequestAt) {
        this.lastRequestAt = lastRequestAt;
        return this;
    }

    public long getSignedUpAt() {
        return this.signedUpAt;
    }

    public User setSignedUpAt(long signedUpAt) {
        this.signedUpAt = signedUpAt;
        return this;
    }

    public String getLastSeenIp() {
        return this.lastSeenIp;
    }

    public User setLastSeenIp(String lastSeenIp) {
        this.lastSeenIp = lastSeenIp;
        return this;
    }

    public Map<String, CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public User setCustomAttributes(Map<String, CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
        return this;
    }

    public User addCustomAttribute(CustomAttribute customAttribute) {
        this.customAttributes.put(customAttribute.getName(), customAttribute);
        return this;
    }

    public String getUserAgentData() {
        return this.userAgentData;
    }

    public User setUserAgentData(String userAgentData) {
        this.userAgentData = userAgentData;
        return this;
    }

    public LocationData getLocationData() {
        return this.locationData;
    }

    public CompanyCollection getCompanyCollection() {
        return this.companyCollection;
    }

    public User setCompanyCollection(CompanyCollection companyCollection) {
        this.companyCollection = companyCollection;
        return this;
    }

    public User addCompany(Company company) {
        this.companyCollection.addCompany(company);
        return this;
    }

    public User removeCompany(Company company) {
        this.removeCompanyCollection.addCompany(company);
        return this;
    }

    public SocialProfileCollection getSocialProfileCollection() {
        return this.socialProfileCollection;
    }

    public SegmentCollection getSegmentCollection() {
        return this.segmentCollection;
    }

    public TagCollection getTagCollection() {
        return this.tagCollection;
    }

    public Boolean isUpdateLastRequestAt() {
        return this.updateLastRequestAt;
    }

    public User setUpdateLastRequestAt(boolean updateLastRequestAt) {
        this.updateLastRequestAt = updateLastRequestAt;
        return this;
    }

    public Boolean isNewSession() {
        return this.newSession;
    }

    public User setNewSession(boolean newSession) {
        this.newSession = newSession;
        return this;
    }

    CompanyCollection getRemoveCompanyCollection() {
        return this.removeCompanyCollection;
    }

    void setRemoveCompanyCollection(CompanyCollection removeCompanyCollection) {
        this.removeCompanyCollection = removeCompanyCollection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (this.createdAt != user.createdAt) {
            return false;
        }
        if (this.lastRequestAt != user.lastRequestAt) {
            return false;
        }
        if (this.signedUpAt != user.signedUpAt) {
            return false;
        }
        if (this.newSession != user.newSession) {
            return false;
        }
        if (this.remoteCreatedAt != user.remoteCreatedAt) {
            return false;
        }
        if (this.sessionCount != user.sessionCount) {
            return false;
        }
        if (this.unsubscribedFromEmails != user.unsubscribedFromEmails) {
            return false;
        }
        if (this.updateLastRequestAt != user.updateLastRequestAt) {
            return false;
        }
        if (this.updatedAt != user.updatedAt) {
            return false;
        }
        if (this.avatar != null ? !this.avatar.equals(user.avatar) : user.avatar != null) {
            return false;
        }
        if (this.companyCollection != null ? !this.companyCollection.equals(user.companyCollection) : user.companyCollection != null) {
            return false;
        }
        if (this.customAttributes != null ? !this.customAttributes.equals(user.customAttributes) : user.customAttributes != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(user.email) : user.email != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(user.phone) : user.phone != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(user.id) : user.id != null) {
            return false;
        }
        if (this.lastSeenIp != null ? !this.lastSeenIp.equals(user.lastSeenIp) : user.lastSeenIp != null) {
            return false;
        }
        if (this.locationData != null ? !this.locationData.equals(user.locationData) : user.locationData != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(user.name) : user.name != null) {
            return false;
        }
        if (this.segmentCollection != null ? !this.segmentCollection.equals(user.segmentCollection) : user.segmentCollection != null) {
            return false;
        }
        if (this.socialProfileCollection != null ? !this.socialProfileCollection.equals(user.socialProfileCollection) : user.socialProfileCollection != null) {
            return false;
        }
        if (this.tagCollection != null ? !this.tagCollection.equals(user.tagCollection) : user.tagCollection != null) {
            return false;
        }
        if (!"user".equals(user.type)) {
            return false;
        }
        if (this.untag != null ? !this.untag.equals(user.untag) : user.untag != null) {
            return false;
        }
        if (this.userAgentData != null ? !this.userAgentData.equals(user.userAgentData) : user.userAgentData != null) {
            return false;
        }
        return !(this.userId != null ? !this.userId.equals(user.userId) : user.userId != null);
    }

    public int hashCode() {
        int result = "user" != null ? "user".hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        result = 31 * result + (this.pseudonym != null ? this.pseudonym.hashCode() : 0);
        result = 31 * result + (this.avatar != null ? this.avatar.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (int)(this.remoteCreatedAt ^ this.remoteCreatedAt >>> 32);
        result = 31 * result + (this.unsubscribedFromEmails != null ? this.unsubscribedFromEmails.hashCode() : 0);
        result = 31 * result + this.sessionCount;
        result = 31 * result + (int)(this.lastRequestAt ^ this.lastRequestAt >>> 32);
        result = 31 * result + (int)(this.signedUpAt ^ this.signedUpAt >>> 32);
        result = 31 * result + (this.lastSeenIp != null ? this.lastSeenIp.hashCode() : 0);
        result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
        result = 31 * result + (this.userAgentData != null ? this.userAgentData.hashCode() : 0);
        result = 31 * result + (this.locationData != null ? this.locationData.hashCode() : 0);
        result = 31 * result + (this.companyCollection != null ? this.companyCollection.hashCode() : 0);
        result = 31 * result + (this.socialProfileCollection != null ? this.socialProfileCollection.hashCode() : 0);
        result = 31 * result + (this.segmentCollection != null ? this.segmentCollection.hashCode() : 0);
        result = 31 * result + (this.tagCollection != null ? this.tagCollection.hashCode() : 0);
        result = 31 * result + (this.updateLastRequestAt != null ? this.updateLastRequestAt.hashCode() : 0);
        result = 31 * result + (this.newSession != null ? this.newSession.hashCode() : 0);
        result = 31 * result + (this.untag != null ? this.untag.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "User{type='user', id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", phone='" + this.phone + '\'' + ", userId='" + this.userId + '\'' + ", avatar=" + this.avatar + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", remoteCreatedAt=" + this.remoteCreatedAt + ", unsubscribedFromEmails=" + this.unsubscribedFromEmails + ", sessionCount=" + this.sessionCount + ", lastRequestAt=" + this.lastRequestAt + ", signedUpAt=" + this.signedUpAt + ", lastSeenIp='" + this.lastSeenIp + '\'' + ", customAttributes=" + this.customAttributes + ", userAgentData='" + this.userAgentData + '\'' + ", locationData=" + this.locationData + ", companyCollection=" + this.companyCollection + ", socialProfileCollection=" + this.socialProfileCollection + ", segmentCollection=" + this.segmentCollection + ", tagCollection=" + this.tagCollection + ", updateLastRequestAt=" + this.updateLastRequestAt + ", newSession=" + this.newSession + ", untag=" + this.untag + "} " + super.toString();
    }

    static {
        BULK_PATHS.add("bulk");
        BULK_PATHS.add("users");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    static class UserUpdate
    extends TypedData {
        private static final List<String> BULK_METHODS = Lists.newArrayList((Object[])new String[]{"post", "delete"});
        @JsonProperty(value="type")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private String type;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="user_id")
        private String userId;
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="phone")
        private String phone;
        @JsonProperty(value="remote_created_at")
        private long remoteCreatedAt;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="last_seen_ip")
        private String lastSeenIp;
        @JsonProperty(value="avatar")
        private Avatar avatar;
        @JsonIgnoreProperties(ignoreUnknown=false)
        @JsonProperty(value="custom_attributes")
        private Map<String, CustomAttribute> customAttributes = Maps.newHashMap();
        @JsonProperty(value="last_seen_user_agent")
        private String lastSeenUserAgent;
        @JsonProperty(value="companies")
        private List<CompanyWithStringPlan> companyCollection;
        @JsonProperty(value="last_request_at")
        private long lastRequestAt;
        @JsonProperty(value="signed_up_at")
        private long signedUpAt;
        @JsonProperty(value="unsubscribed_from_emails")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean unsubscribedFromEmails;
        @JsonProperty(value="update_last_request_at")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean updateLastRequestAt;
        @JsonProperty(value="new_session")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean newSession;

        static UserUpdate buildFrom(User user) {
            UserUpdate userUpdate = new UserUpdate();
            userUpdate.userId = user.getUserId();
            userUpdate.email = user.getEmail();
            userUpdate.phone = user.getPhone();
            userUpdate.id = user.getId();
            userUpdate.remoteCreatedAt = user.getRemoteCreatedAt();
            userUpdate.name = user.getName();
            userUpdate.lastSeenIp = user.getLastSeenIp();
            userUpdate.customAttributes = user.getCustomAttributes();
            userUpdate.lastSeenUserAgent = user.getUserAgentData();
            if (!User.buildUserUpdateCompanies(user).isEmpty()) {
                userUpdate.companyCollection = User.buildUserUpdateCompanies(user);
            }
            userUpdate.avatar = user.getAvatar();
            userUpdate.lastRequestAt = user.getLastRequestAt();
            userUpdate.signedUpAt = user.getSignedUpAt();
            userUpdate.unsubscribedFromEmails = user.getUnsubscribedFromEmails();
            userUpdate.updateLastRequestAt = user.isUpdateLastRequestAt();
            userUpdate.newSession = user.isNewSession();
            return userUpdate;
        }

        static List<JobItem<UserUpdate>> validateAndConvertJobItems(List<JobItem<User>> items) {
            ArrayList updateItems = Lists.newArrayList();
            JobSupport jobSupport = new JobSupport();
            for (JobItem<User> item : items) {
                jobSupport.validateJobItem(item, BULK_METHODS);
                JobItem<UserUpdate> jobItem = new JobItem<UserUpdate>(item.getMethod(), UserUpdate.buildFrom(item.getData()), item.getData().getType());
                updateItems.add(jobItem);
            }
            return updateItems;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPhone() {
            return this.phone;
        }

        public long getRemoteCreatedAt() {
            return this.remoteCreatedAt;
        }

        public String getName() {
            return this.name;
        }

        public String getLastSeenIp() {
            return this.lastSeenIp;
        }

        public Map<String, CustomAttribute> getCustomAttributes() {
            return this.customAttributes;
        }

        public String getLastSeenUserAgent() {
            return this.lastSeenUserAgent;
        }

        public List<CompanyWithStringPlan> getCompanyCollection() {
            return this.companyCollection;
        }

        public long getLastRequestAt() {
            return this.lastRequestAt;
        }

        public long getSignedUpAt() {
            return this.signedUpAt;
        }

        public Boolean getUnsubscribedFromEmails() {
            return this.unsubscribedFromEmails;
        }

        public Boolean isUpdateLastRequestAt() {
            return this.updateLastRequestAt;
        }

        public Boolean isNewSession() {
            return this.newSession;
        }

        public Avatar getAvatar() {
            return this.avatar;
        }
    }
}

