/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.Avatar;
import io.intercom.api.ClientException;
import io.intercom.api.CompanyCollection;
import io.intercom.api.CompanyWithStringPlan;
import io.intercom.api.Contact;
import io.intercom.api.CustomAttribute;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.LocationData;
import io.intercom.api.RateLimitException;
import io.intercom.api.SegmentCollection;
import io.intercom.api.ServerException;
import io.intercom.api.SocialProfileCollection;
import io.intercom.api.TagCollection;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import io.intercom.api.User;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Visitor
extends TypedData {
    private static final Map<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private final String type = "visitor";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="user_id")
    private String userID;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="phone")
    private String phone;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="pseudonym")
    private String pseudonym;
    @JsonProperty(value="avatar")
    private Avatar avatar;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="last_seen_user_agent")
    private String lastSeenUserAgent;
    @JsonProperty(value="referrer")
    private String referrer;
    @JsonProperty(value="utm_campaign")
    private String utmCampaign;
    @JsonProperty(value="utm_content")
    private String utmContent;
    @JsonProperty(value="utm_medium")
    private String utmMedium;
    @JsonProperty(value="utm_source")
    private String utmSource;
    @JsonProperty(value="utm_term")
    private String utmTerm;
    @JsonProperty(value="unsubscribed_from_emails")
    private Boolean unsubscribedFromEmails;
    @JsonProperty(value="session_count")
    private int sessionCount;
    @JsonProperty(value="last_request_at")
    private long lastRequestAt;
    @JsonProperty(value="last_seen_ip")
    private String lastSeenIP;
    @JsonIgnoreProperties(ignoreUnknown=false)
    @JsonProperty(value="custom_attributes")
    private Map<String, CustomAttribute> customAttributes = Maps.newHashMap();
    @JsonProperty(value="user_agent_data")
    private String userAgentData;
    @JsonProperty(value="location_data")
    private LocationData locationData;
    @JsonIgnoreProperties(ignoreUnknown=false)
    @JsonProperty(value="companies")
    private CompanyCollection companyCollection = new CompanyCollection();
    @JsonProperty(value="social_profiles")
    private SocialProfileCollection socialProfileCollection = new SocialProfileCollection();
    @JsonProperty(value="segments")
    private SegmentCollection segmentCollection = new SegmentCollection();
    @JsonProperty(value="tags")
    private TagCollection tagCollection = new TagCollection();
    @JsonProperty(value="update_last_request_at")
    private Boolean updateLastRequestAt;

    public static Visitor findByID(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return new HttpClient(Visitor.visitorURI(id)).get(Visitor.class);
    }

    public static Visitor findByUserID(String userID) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        HashMap params = Maps.newHashMap();
        params.put("user_id", userID);
        return DataResource.find(params, "visitors", Visitor.class);
    }

    public static Visitor update(Visitor v) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.updatePut(VisitorUpdate.buildFrom(v), Visitor.visitorURI(""), Visitor.class);
    }

    public static Visitor delete(Visitor v) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.delete(v.getID(), "visitors", Visitor.class);
    }

    public static Visitor delete(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.delete(id, "visitors", Visitor.class);
    }

    public static Contact convertToContact(Visitor v) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.post(VisitorConvertBuilder.buildConvertToLead(v), Visitor.convertURI(), Contact.class);
    }

    public static User convertToUser(Visitor v, User u) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.post(VisitorConvertBuilder.buildConvertToUser(v, u), Visitor.convertURI(), User.class);
    }

    private static URI visitorURI(String id) {
        return UriBuilder.newBuilder().path("visitors").path(id).build();
    }

    private static URI convertURI() {
        return UriBuilder.newBuilder().path("visitors").path("convert").build();
    }

    @Override
    public String getType() {
        return "visitor";
    }

    public String getID() {
        return this.id;
    }

    public Visitor setID(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Visitor setName(String name) {
        this.name = name;
        return this;
    }

    public String getPseudonym() {
        return this.pseudonym;
    }

    public String getEmail() {
        return this.email;
    }

    public Visitor setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public Visitor setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getUserID() {
        return this.userID;
    }

    public Visitor setUserID(String userID) {
        this.userID = userID;
        return this;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public Visitor setAvatar(Avatar avatar) {
        this.avatar = avatar;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public Boolean getUnsubscribedFromEmails() {
        return this.unsubscribedFromEmails;
    }

    public Visitor setUnsubscribedFromEmails(boolean unsubscribedFromEmails) {
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        return this;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public long getLastRequestAt() {
        return this.lastRequestAt;
    }

    public Visitor setLastRequestAt(long lastRequestAt) {
        this.lastRequestAt = lastRequestAt;
        return this;
    }

    public String getLastSeenIP() {
        return this.lastSeenIP;
    }

    public Visitor setLastSeenIP(String lastSeenIP) {
        this.lastSeenIP = lastSeenIP;
        return this;
    }

    public String getLastSeenUserAgent() {
        return this.lastSeenUserAgent;
    }

    public Visitor setLastSeenUserAgent(String lastSeenUserAgent) {
        this.lastSeenUserAgent = lastSeenUserAgent;
        return this;
    }

    public Map<String, CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public Visitor setCustomAttributes(Map<String, CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
        return this;
    }

    public Visitor addCustomAttribute(CustomAttribute customAttribute) {
        this.customAttributes.put(customAttribute.getName(), customAttribute);
        return this;
    }

    public String getUserAgentData() {
        return this.userAgentData;
    }

    public LocationData getLocationData() {
        return this.locationData;
    }

    public CompanyCollection getCompanyCollection() {
        return this.companyCollection;
    }

    public SocialProfileCollection getSocialProfileCollection() {
        return this.socialProfileCollection;
    }

    public SegmentCollection getSegmentCollection() {
        return this.segmentCollection;
    }

    public TagCollection getTagCollection() {
        return this.tagCollection;
    }

    public Boolean isUpdateLastRequestAt() {
        return this.updateLastRequestAt;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String getUtmCampaign() {
        return this.utmCampaign;
    }

    public Visitor setUtmCampaign(String utmCampaign) {
        this.utmCampaign = utmCampaign;
        return this;
    }

    public String getUtmContent() {
        return this.utmContent;
    }

    public Visitor setUtmContent(String utmContent) {
        this.utmContent = utmContent;
        return this;
    }

    public String getUtmMedium() {
        return this.utmMedium;
    }

    public Visitor setUtmMedium(String utmMedium) {
        this.utmMedium = utmMedium;
        return this;
    }

    public String getUtmSource() {
        return this.utmSource;
    }

    public Visitor setUtmSource(String utmSource) {
        this.utmSource = utmSource;
        return this;
    }

    public String getUtmTerm() {
        return this.utmTerm;
    }

    public Visitor setUtmTerm(String utmTerm) {
        this.utmTerm = utmTerm;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Visitor Visitor2 = (Visitor)o;
        if (this.createdAt != Visitor2.createdAt) {
            return false;
        }
        if (this.updatedAt != Visitor2.updatedAt) {
            return false;
        }
        if (this.sessionCount != Visitor2.sessionCount) {
            return false;
        }
        if (this.lastRequestAt != Visitor2.lastRequestAt) {
            return false;
        }
        if (!"visitor".equals(Visitor2.type)) {
            return false;
        }
        if (this.id != null ? !this.id.equals(Visitor2.id) : Visitor2.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(Visitor2.name) : Visitor2.name != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(Visitor2.email) : Visitor2.email != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(Visitor2.phone) : Visitor2.phone != null) {
            return false;
        }
        if (this.userID != null ? !this.userID.equals(Visitor2.userID) : Visitor2.userID != null) {
            return false;
        }
        if (this.avatar != null ? !this.avatar.equals(Visitor2.avatar) : Visitor2.avatar != null) {
            return false;
        }
        if (this.unsubscribedFromEmails != null ? !this.unsubscribedFromEmails.equals(Visitor2.unsubscribedFromEmails) : Visitor2.unsubscribedFromEmails != null) {
            return false;
        }
        if (this.lastSeenIP != null ? !this.lastSeenIP.equals(Visitor2.lastSeenIP) : Visitor2.lastSeenIP != null) {
            return false;
        }
        if (this.customAttributes != null ? !this.customAttributes.equals(Visitor2.customAttributes) : Visitor2.customAttributes != null) {
            return false;
        }
        if (this.userAgentData != null ? !this.userAgentData.equals(Visitor2.userAgentData) : Visitor2.userAgentData != null) {
            return false;
        }
        if (this.locationData != null ? !this.locationData.equals(Visitor2.locationData) : Visitor2.locationData != null) {
            return false;
        }
        if (this.companyCollection != null ? !this.companyCollection.equals(Visitor2.companyCollection) : Visitor2.companyCollection != null) {
            return false;
        }
        if (this.socialProfileCollection != null ? !this.socialProfileCollection.equals(Visitor2.socialProfileCollection) : Visitor2.socialProfileCollection != null) {
            return false;
        }
        if (this.segmentCollection != null ? !this.segmentCollection.equals(Visitor2.segmentCollection) : Visitor2.segmentCollection != null) {
            return false;
        }
        if (this.tagCollection != null ? !this.tagCollection.equals(Visitor2.tagCollection) : Visitor2.tagCollection != null) {
            return false;
        }
        if (this.updateLastRequestAt != null ? !this.updateLastRequestAt.equals(Visitor2.updateLastRequestAt) : Visitor2.updateLastRequestAt != null) {
            return false;
        }
        if (this.referrer != null ? !this.referrer.equals(Visitor2.referrer) : Visitor2.referrer != null) {
            return false;
        }
        if (this.utmCampaign != null ? !this.utmCampaign.equals(Visitor2.utmCampaign) : Visitor2.utmCampaign != null) {
            return false;
        }
        if (this.utmContent != null ? !this.utmContent.equals(Visitor2.utmContent) : Visitor2.utmContent != null) {
            return false;
        }
        if (this.utmMedium != null ? !this.utmMedium.equals(Visitor2.utmMedium) : Visitor2.utmMedium != null) {
            return false;
        }
        if (this.utmSource != null ? !this.utmSource.equals(Visitor2.utmSource) : Visitor2.utmSource != null) {
            return false;
        }
        return !(this.utmTerm != null ? !this.utmTerm.equals(Visitor2.utmTerm) : Visitor2.utmTerm != null);
    }

    public int hashCode() {
        int result = "visitor".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.userID != null ? this.userID.hashCode() : 0);
        result = 31 * result + (this.avatar != null ? this.avatar.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (this.unsubscribedFromEmails != null ? this.unsubscribedFromEmails.hashCode() : 0);
        result = 31 * result + this.sessionCount;
        result = 31 * result + (int)(this.lastRequestAt ^ this.lastRequestAt >>> 32);
        result = 31 * result + (this.lastSeenIP != null ? this.lastSeenIP.hashCode() : 0);
        result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
        result = 31 * result + (this.userAgentData != null ? this.userAgentData.hashCode() : 0);
        result = 31 * result + (this.locationData != null ? this.locationData.hashCode() : 0);
        result = 31 * result + (this.companyCollection != null ? this.companyCollection.hashCode() : 0);
        result = 31 * result + (this.socialProfileCollection != null ? this.socialProfileCollection.hashCode() : 0);
        result = 31 * result + (this.segmentCollection != null ? this.segmentCollection.hashCode() : 0);
        result = 31 * result + (this.tagCollection != null ? this.tagCollection.hashCode() : 0);
        result = 31 * result + (this.updateLastRequestAt != null ? this.updateLastRequestAt.hashCode() : 0);
        result = 31 * result + (this.referrer != null ? this.referrer.hashCode() : 0);
        result = 31 * result + (this.utmContent != null ? this.utmContent.hashCode() : 0);
        result = 31 * result + (this.utmCampaign != null ? this.utmCampaign.hashCode() : 0);
        result = 31 * result + (this.utmMedium != null ? this.utmMedium.hashCode() : 0);
        result = 31 * result + (this.utmSource != null ? this.utmSource.hashCode() : 0);
        result = 31 * result + (this.utmTerm != null ? this.utmTerm.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Visitor{type='visitor', id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", phone='" + this.phone + '\'' + ", userID='" + this.userID + '\'' + ", avatar=" + this.avatar + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", unsubscribedFromEmails=" + this.unsubscribedFromEmails + ", sessionCount=" + this.sessionCount + ", lastRequestAt=" + this.lastRequestAt + ", lastSeenIP='" + this.lastSeenIP + '\'' + ", customAttributes=" + this.customAttributes + ", userAgentData='" + this.userAgentData + '\'' + ", locationData=" + this.locationData + ", companyCollection=" + this.companyCollection + ", socialProfileCollection=" + this.socialProfileCollection + ", segmentCollection=" + this.segmentCollection + ", tagCollection=" + this.tagCollection + ", updateLastRequestAt=" + this.updateLastRequestAt + ", referrer=" + this.referrer + ", utmCampaign='" + this.utmCampaign + '\'' + ", utmContent='" + this.utmContent + '\'' + ", utmMedium='" + this.utmMedium + '\'' + ", utmSource='" + this.utmSource + '\'' + ", utmTerm='" + this.utmTerm + '\'' + "} " + super.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    static class VisitorUpdate
    extends TypedData {
        @JsonProperty(value="type")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private String type;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="user_id")
        private String userID;
        @JsonProperty(value="email")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String email;
        @JsonProperty(value="phone")
        private String phone;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="utm_campaign")
        private String utmCampaign;
        @JsonProperty(value="utm_content")
        private String utmContent;
        @JsonProperty(value="utm_medium")
        private String utmMedium;
        @JsonProperty(value="utm_source")
        private String utmSource;
        @JsonProperty(value="utm_term")
        private String utmTerm;
        @JsonProperty(value="last_seen_ip")
        private String lastSeenIP;
        @JsonProperty(value="avatar")
        private Avatar avatar;
        @JsonIgnoreProperties(ignoreUnknown=false)
        @JsonProperty(value="custom_attributes")
        private Map<String, CustomAttribute> customAttributes = Maps.newHashMap();
        @JsonProperty(value="last_seen_user_agent")
        private String lastSeenUserAgent;
        @JsonProperty(value="companies")
        private List<CompanyWithStringPlan> companyCollection;
        @JsonProperty(value="last_request_at")
        private long lastRequestAt;
        @JsonProperty(value="signed_up_at")
        private String signedUpAt;
        @JsonProperty(value="unsubscribed_from_emails")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean unsubscribedFromEmails;
        @JsonProperty(value="update_last_request_at")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private Boolean updateLastRequestAt;

        static VisitorUpdate buildFrom(Visitor v) {
            VisitorUpdate visitorUpdate = new VisitorUpdate();
            visitorUpdate.id = v.getID();
            visitorUpdate.userID = v.getUserID();
            if (v.getEmail() != null && v.getEmail() != "") {
                visitorUpdate.email = v.getEmail();
            }
            visitorUpdate.phone = v.getPhone();
            visitorUpdate.name = v.getName();
            visitorUpdate.lastSeenIP = v.getLastSeenIP();
            visitorUpdate.customAttributes = v.getCustomAttributes();
            visitorUpdate.avatar = v.getAvatar();
            visitorUpdate.lastRequestAt = v.getLastRequestAt();
            visitorUpdate.lastSeenUserAgent = v.getLastSeenUserAgent();
            visitorUpdate.unsubscribedFromEmails = v.getUnsubscribedFromEmails();
            visitorUpdate.utmCampaign = v.getUtmCampaign();
            visitorUpdate.utmContent = v.getUtmContent();
            visitorUpdate.utmMedium = v.getUtmMedium();
            visitorUpdate.utmSource = v.getUtmSource();
            visitorUpdate.utmTerm = v.getUtmTerm();
            return visitorUpdate;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getID() {
            return this.id;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPhone() {
            return this.phone;
        }

        public String getName() {
            return this.name;
        }

        public Avatar getAvatar() {
            return this.avatar;
        }

        public String getUtmCampaign() {
            return this.utmCampaign;
        }

        public String getUtmContent() {
            return this.utmContent;
        }

        public String getUtmMedium() {
            return this.utmMedium;
        }

        public String getUtmSource() {
            return this.utmSource;
        }

        public String getUtmTerm() {
            return this.utmTerm;
        }

        public String getLastSeenIP() {
            return this.lastSeenIP;
        }

        public Map<String, CustomAttribute> getCustomAttributes() {
            return this.customAttributes;
        }

        public String getLastSeenUserAgent() {
            return this.lastSeenUserAgent;
        }

        public List<CompanyWithStringPlan> getCompanyCollection() {
            return this.companyCollection;
        }

        public long getLastRequestAt() {
            return this.lastRequestAt;
        }

        public Boolean getUnsubscribedFromEmails() {
            return this.unsubscribedFromEmails;
        }

        public Boolean isUpdateLastRequestAt() {
            return this.updateLastRequestAt;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    static class VisitorConvert {
        @JsonProperty(value="visitor")
        private Map<String, String> visitor;
        @JsonProperty(value="user")
        private Map<String, String> user;
        @JsonProperty(value="type")
        private String type;

        public VisitorConvert() {
        }

        public VisitorConvert(Map<String, String> visitor) {
            this.visitor = visitor;
            this.type = "lead";
        }

        public VisitorConvert(Map<String, String> visitor, Map<String, String> user) {
            this.visitor = visitor;
            this.user = user;
            this.type = "user";
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, String> getVisitor() {
            return this.visitor;
        }

        public void setVisitor(Map<String, String> visitor) {
            this.visitor = visitor;
        }

        public Map<String, String> getUser() {
            return this.user;
        }

        public void setUser(Map<String, String> user) {
            this.user = user;
        }
    }

    static class VisitorConvertBuilder {
        VisitorConvertBuilder() {
        }

        static VisitorConvert buildConvertToLead(Visitor v) throws InvalidException {
            return new VisitorConvertBuilder().build(v);
        }

        static VisitorConvert buildConvertToUser(Visitor v, User u) throws InvalidException {
            return new VisitorConvertBuilder().build(v, u);
        }

        VisitorConvert build(Visitor v) throws InvalidException {
            return new VisitorConvert(this.buildConvertVisitor(v));
        }

        VisitorConvert build(Visitor v, User u) throws InvalidException {
            return new VisitorConvert(this.buildConvertVisitor(v), this.buildConvertUser(u));
        }

        HashMap<String, String> buildConvertVisitor(Visitor v) {
            HashMap convertVisitor = Maps.newHashMap();
            if (v.getID() != null) {
                convertVisitor.put("id", v.getID());
            }
            if (v.getUserID() != null) {
                convertVisitor.put("user_id", v.getUserID());
            }
            this.checkValidConvertVisitor(convertVisitor);
            return convertVisitor;
        }

        HashMap<String, String> buildConvertUser(User u) {
            HashMap convertUser = Maps.newHashMap();
            if (u.getId() != null) {
                convertUser.put("id", u.getId());
            }
            if (u.getUserId() != null) {
                convertUser.put("user_id", u.getUserId());
            }
            if (u.getEmail() != null) {
                convertUser.put("email", u.getEmail());
            }
            this.checkValidConvertUser(convertUser);
            return convertUser;
        }

        void checkValidConvertVisitor(HashMap<String, String> convertUser) {
            if (!convertUser.containsKey("id") && !convertUser.containsKey("user_id")) {
                throw new InvalidException("a convert visitor must include at least one of, an id or user_id parameter");
            }
        }

        void checkValidConvertUser(HashMap<String, String> convertUser) {
            if (!(convertUser.containsKey("id") || convertUser.containsKey("user_id") || convertUser.containsKey("email"))) {
                throw new InvalidException("a convert user must include at least one of, an id, user_id or email parameter");
            }
        }
    }
}

