/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.Environment;
import okhttp3.OkHttpClient;

public final class AsyncIntercomBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();

    private String token = System.getenv("INTERCOM_API_KEY");

    private Environment environment = Environment.US_PRODUCTION;

    /**
     * Sets token.
     * Defaults to the INTERCOM_API_KEY environment variable.
     */
    public AsyncIntercomBuilder token(String token) {
        this.token = token;
        return this;
    }

    public AsyncIntercomBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public AsyncIntercomBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    /**
     * Sets the timeout (in seconds) for the client. Defaults to 60 seconds.
     */
    public AsyncIntercomBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    /**
     * Sets the maximum number of retries for the client. Defaults to 2 retries.
     */
    public AsyncIntercomBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    /**
     * Sets the underlying OkHttp client
     */
    public AsyncIntercomBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public AsyncIntercom build() {
        if (token == null) {
            throw new RuntimeException("Please provide token or set the INTERCOM_API_KEY environment variable.");
        }
        this.clientOptionsBuilder.addHeader("Authorization", "Bearer " + this.token);
        clientOptionsBuilder.environment(this.environment);
        return new AsyncIntercom(clientOptionsBuilder.build());
    }
}
