/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aiagent.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContentSourcesList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AiAgent.Builder.class)
public final class AiAgent {
    private final SourceType sourceType;

    private final Optional<String> sourceTitle;

    private final Optional<String> lastAnswerType;

    private final Optional<String> resolutionState;

    private final Optional<Integer> rating;

    private final Optional<String> ratingRemark;

    private final Optional<ContentSourcesList> contentSources;

    private final Map<String, Object> additionalProperties;

    private AiAgent(
            SourceType sourceType,
            Optional<String> sourceTitle,
            Optional<String> lastAnswerType,
            Optional<String> resolutionState,
            Optional<Integer> rating,
            Optional<String> ratingRemark,
            Optional<ContentSourcesList> contentSources,
            Map<String, Object> additionalProperties) {
        this.sourceType = sourceType;
        this.sourceTitle = sourceTitle;
        this.lastAnswerType = lastAnswerType;
        this.resolutionState = resolutionState;
        this.rating = rating;
        this.ratingRemark = ratingRemark;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the source that triggered AI Agent involvement in the conversation.
     */
    @JsonProperty("source_type")
    public SourceType getSourceType() {
        return sourceType;
    }

    /**
     * @return The title of the source that triggered AI Agent involvement in the conversation. If this is <code>essentials_plan_setup</code> then it will return <code>null</code>.
     */
    @JsonProperty("source_title")
    public Optional<String> getSourceTitle() {
        return sourceTitle;
    }

    /**
     * @return The type of the last answer delivered by AI Agent. If no answer was delivered then this will return <code>null</code>
     */
    @JsonProperty("last_answer_type")
    public Optional<String> getLastAnswerType() {
        return lastAnswerType;
    }

    /**
     * @return The resolution state of AI Agent. If no AI or custom answer has been delivered then this will return <code>null</code>.
     */
    @JsonProperty("resolution_state")
    public Optional<String> getResolutionState() {
        return resolutionState;
    }

    /**
     * @return The customer satisfaction rating given to AI Agent, from 1-5.
     */
    @JsonProperty("rating")
    public Optional<Integer> getRating() {
        return rating;
    }

    /**
     * @return The customer satisfaction rating remark given to AI Agent.
     */
    @JsonProperty("rating_remark")
    public Optional<String> getRatingRemark() {
        return ratingRemark;
    }

    @JsonProperty("content_sources")
    public Optional<ContentSourcesList> getContentSources() {
        return contentSources;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AiAgent && equalTo((AiAgent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AiAgent other) {
        return sourceType.equals(other.sourceType)
                && sourceTitle.equals(other.sourceTitle)
                && lastAnswerType.equals(other.lastAnswerType)
                && resolutionState.equals(other.resolutionState)
                && rating.equals(other.rating)
                && ratingRemark.equals(other.ratingRemark)
                && contentSources.equals(other.contentSources);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.sourceType,
                this.sourceTitle,
                this.lastAnswerType,
                this.resolutionState,
                this.rating,
                this.ratingRemark,
                this.contentSources);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SourceTypeStage builder() {
        return new Builder();
    }

    public interface SourceTypeStage {
        /**
         * The type of the source that triggered AI Agent involvement in the conversation.
         */
        _FinalStage sourceType(@NotNull SourceType sourceType);

        Builder from(AiAgent other);
    }

    public interface _FinalStage {
        AiAgent build();

        /**
         * <p>The title of the source that triggered AI Agent involvement in the conversation. If this is <code>essentials_plan_setup</code> then it will return <code>null</code>.</p>
         */
        _FinalStage sourceTitle(Optional<String> sourceTitle);

        _FinalStage sourceTitle(String sourceTitle);

        /**
         * <p>The type of the last answer delivered by AI Agent. If no answer was delivered then this will return <code>null</code></p>
         */
        _FinalStage lastAnswerType(Optional<String> lastAnswerType);

        _FinalStage lastAnswerType(String lastAnswerType);

        /**
         * <p>The resolution state of AI Agent. If no AI or custom answer has been delivered then this will return <code>null</code>.</p>
         */
        _FinalStage resolutionState(Optional<String> resolutionState);

        _FinalStage resolutionState(String resolutionState);

        /**
         * <p>The customer satisfaction rating given to AI Agent, from 1-5.</p>
         */
        _FinalStage rating(Optional<Integer> rating);

        _FinalStage rating(Integer rating);

        /**
         * <p>The customer satisfaction rating remark given to AI Agent.</p>
         */
        _FinalStage ratingRemark(Optional<String> ratingRemark);

        _FinalStage ratingRemark(String ratingRemark);

        _FinalStage contentSources(Optional<ContentSourcesList> contentSources);

        _FinalStage contentSources(ContentSourcesList contentSources);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SourceTypeStage, _FinalStage {
        private SourceType sourceType;

        private Optional<ContentSourcesList> contentSources = Optional.empty();

        private Optional<String> ratingRemark = Optional.empty();

        private Optional<Integer> rating = Optional.empty();

        private Optional<String> resolutionState = Optional.empty();

        private Optional<String> lastAnswerType = Optional.empty();

        private Optional<String> sourceTitle = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AiAgent other) {
            sourceType(other.getSourceType());
            sourceTitle(other.getSourceTitle());
            lastAnswerType(other.getLastAnswerType());
            resolutionState(other.getResolutionState());
            rating(other.getRating());
            ratingRemark(other.getRatingRemark());
            contentSources(other.getContentSources());
            return this;
        }

        /**
         * The type of the source that triggered AI Agent involvement in the conversation.<p>The type of the source that triggered AI Agent involvement in the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("source_type")
        public _FinalStage sourceType(@NotNull SourceType sourceType) {
            this.sourceType = Objects.requireNonNull(sourceType, "sourceType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage contentSources(ContentSourcesList contentSources) {
            this.contentSources = Optional.ofNullable(contentSources);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "content_sources", nulls = Nulls.SKIP)
        public _FinalStage contentSources(Optional<ContentSourcesList> contentSources) {
            this.contentSources = contentSources;
            return this;
        }

        /**
         * <p>The customer satisfaction rating remark given to AI Agent.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ratingRemark(String ratingRemark) {
            this.ratingRemark = Optional.ofNullable(ratingRemark);
            return this;
        }

        /**
         * <p>The customer satisfaction rating remark given to AI Agent.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "rating_remark", nulls = Nulls.SKIP)
        public _FinalStage ratingRemark(Optional<String> ratingRemark) {
            this.ratingRemark = ratingRemark;
            return this;
        }

        /**
         * <p>The customer satisfaction rating given to AI Agent, from 1-5.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage rating(Integer rating) {
            this.rating = Optional.ofNullable(rating);
            return this;
        }

        /**
         * <p>The customer satisfaction rating given to AI Agent, from 1-5.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "rating", nulls = Nulls.SKIP)
        public _FinalStage rating(Optional<Integer> rating) {
            this.rating = rating;
            return this;
        }

        /**
         * <p>The resolution state of AI Agent. If no AI or custom answer has been delivered then this will return <code>null</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage resolutionState(String resolutionState) {
            this.resolutionState = Optional.ofNullable(resolutionState);
            return this;
        }

        /**
         * <p>The resolution state of AI Agent. If no AI or custom answer has been delivered then this will return <code>null</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "resolution_state", nulls = Nulls.SKIP)
        public _FinalStage resolutionState(Optional<String> resolutionState) {
            this.resolutionState = resolutionState;
            return this;
        }

        /**
         * <p>The type of the last answer delivered by AI Agent. If no answer was delivered then this will return <code>null</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastAnswerType(String lastAnswerType) {
            this.lastAnswerType = Optional.ofNullable(lastAnswerType);
            return this;
        }

        /**
         * <p>The type of the last answer delivered by AI Agent. If no answer was delivered then this will return <code>null</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_answer_type", nulls = Nulls.SKIP)
        public _FinalStage lastAnswerType(Optional<String> lastAnswerType) {
            this.lastAnswerType = lastAnswerType;
            return this;
        }

        /**
         * <p>The title of the source that triggered AI Agent involvement in the conversation. If this is <code>essentials_plan_setup</code> then it will return <code>null</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage sourceTitle(String sourceTitle) {
            this.sourceTitle = Optional.ofNullable(sourceTitle);
            return this;
        }

        /**
         * <p>The title of the source that triggered AI Agent involvement in the conversation. If this is <code>essentials_plan_setup</code> then it will return <code>null</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "source_title", nulls = Nulls.SKIP)
        public _FinalStage sourceTitle(Optional<String> sourceTitle) {
            this.sourceTitle = sourceTitle;
            return this;
        }

        @java.lang.Override
        public AiAgent build() {
            return new AiAgent(
                    sourceType,
                    sourceTitle,
                    lastAnswerType,
                    resolutionState,
                    rating,
                    ratingRemark,
                    contentSources,
                    additionalProperties);
        }
    }

    public static final class SourceType {
        public static final SourceType WORKFLOW = new SourceType(Value.WORKFLOW, "workflow");

        public static final SourceType WORKFLOW_PREVIEW = new SourceType(Value.WORKFLOW_PREVIEW, "workflow_preview");

        public static final SourceType FIN_PREVIEW = new SourceType(Value.FIN_PREVIEW, "fin_preview");

        public static final SourceType ESSENTIALS_PLAN_SETUP =
                new SourceType(Value.ESSENTIALS_PLAN_SETUP, "essentials_plan_setup");

        public static final SourceType PROFILE = new SourceType(Value.PROFILE, "profile");

        private final Value value;

        private final String string;

        SourceType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof SourceType && this.string.equals(((SourceType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case WORKFLOW:
                    return visitor.visitWorkflow();
                case WORKFLOW_PREVIEW:
                    return visitor.visitWorkflowPreview();
                case FIN_PREVIEW:
                    return visitor.visitFinPreview();
                case ESSENTIALS_PLAN_SETUP:
                    return visitor.visitEssentialsPlanSetup();
                case PROFILE:
                    return visitor.visitProfile();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SourceType valueOf(String value) {
            switch (value) {
                case "workflow":
                    return WORKFLOW;
                case "workflow_preview":
                    return WORKFLOW_PREVIEW;
                case "fin_preview":
                    return FIN_PREVIEW;
                case "essentials_plan_setup":
                    return ESSENTIALS_PLAN_SETUP;
                case "profile":
                    return PROFILE;
                default:
                    return new SourceType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ESSENTIALS_PLAN_SETUP,

            PROFILE,

            WORKFLOW,

            WORKFLOW_PREVIEW,

            FIN_PREVIEW,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitEssentialsPlanSetup();

            T visitProfile();

            T visitWorkflow();

            T visitWorkflowPreview();

            T visitFinPreview();

            T visitUnknown(String unknownType);
        }
    }
}
