/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aicontentsource.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContentSource.Builder.class)
public final class ContentSource {
    private final String url;

    private final String title;

    private final String locale;

    private final Map<String, Object> additionalProperties;

    private ContentSource(String url, String title, String locale, Map<String, Object> additionalProperties) {
        this.url = url;
        this.title = title;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the content source.
     */
    @JsonProperty("content_type")
    public String getContentType() {
        return "custom_answer";
    }

    /**
     * @return The internal URL linking to the content source for teammates.
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * @return The title of the content source.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The ISO 639 language code of the content source.
     */
    @JsonProperty("locale")
    public String getLocale() {
        return locale;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentSource && equalTo((ContentSource) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSource other) {
        return url.equals(other.url) && title.equals(other.title) && locale.equals(other.locale);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.url, this.title, this.locale);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    public interface UrlStage {
        /**
         * The internal URL linking to the content source for teammates.
         */
        TitleStage url(@NotNull String url);

        Builder from(ContentSource other);
    }

    public interface TitleStage {
        /**
         * The title of the content source.
         */
        LocaleStage title(@NotNull String title);
    }

    public interface LocaleStage {
        /**
         * The ISO 639 language code of the content source.
         */
        _FinalStage locale(@NotNull String locale);
    }

    public interface _FinalStage {
        ContentSource build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements UrlStage, TitleStage, LocaleStage, _FinalStage {
        private String url;

        private String title;

        private String locale;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContentSource other) {
            url(other.getUrl());
            title(other.getTitle());
            locale(other.getLocale());
            return this;
        }

        /**
         * The internal URL linking to the content source for teammates.<p>The internal URL linking to the content source for teammates.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public TitleStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        /**
         * The title of the content source.<p>The title of the content source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public LocaleStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * The ISO 639 language code of the content source.<p>The ISO 639 language code of the content source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("locale")
        public _FinalStage locale(@NotNull String locale) {
            this.locale = Objects.requireNonNull(locale, "locale must not be null");
            return this;
        }

        @java.lang.Override
        public ContentSource build() {
            return new ContentSource(url, title, locale, additionalProperties);
        }
    }
}
