/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.articles.requests.CreateArticleRequest;
import com.intercom.api.resources.articles.requests.DeleteArticleRequest;
import com.intercom.api.resources.articles.requests.FindArticleRequest;
import com.intercom.api.resources.articles.requests.ListArticlesRequest;
import com.intercom.api.resources.articles.requests.SearchArticlesRequest;
import com.intercom.api.resources.articles.requests.UpdateArticleRequest;
import com.intercom.api.resources.articles.types.Article;
import com.intercom.api.resources.articles.types.ArticleListItem;
import com.intercom.api.resources.articles.types.SearchArticlesResponse;
import com.intercom.api.types.DeletedArticleObject;

public class ArticlesClient {
    protected final ClientOptions clientOptions;

    private final RawArticlesClient rawClient;

    public ArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawArticlesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawArticlesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public SyncPagingIterable<ArticleListItem> list() {
        return this.rawClient.list().body();
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public SyncPagingIterable<ArticleListItem> list(ListArticlesRequest request) {
        return this.rawClient.list(request).body();
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public SyncPagingIterable<ArticleListItem> list(ListArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    /**
     * You can create a new article by making a POST request to <code>https://api.intercom.io/articles</code>.
     */
    public Article create(CreateArticleRequest request) {
        return this.rawClient.create(request).body();
    }

    /**
     * You can create a new article by making a POST request to <code>https://api.intercom.io/articles</code>.
     */
    public Article create(CreateArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single article by making a GET request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public Article find(FindArticleRequest request) {
        return this.rawClient.find(request).body();
    }

    /**
     * You can fetch the details of a single article by making a GET request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public Article find(FindArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    /**
     * You can update the details of a single article by making a PUT request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public Article update(UpdateArticleRequest request) {
        return this.rawClient.update(request).body();
    }

    /**
     * You can update the details of a single article by making a PUT request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public Article update(UpdateArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    /**
     * You can delete a single article by making a DELETE request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public DeletedArticleObject delete(DeleteArticleRequest request) {
        return this.rawClient.delete(request).body();
    }

    /**
     * You can delete a single article by making a DELETE request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public DeletedArticleObject delete(DeleteArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public SearchArticlesResponse search() {
        return this.rawClient.search().body();
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public SearchArticlesResponse search(SearchArticlesRequest request) {
        return this.rawClient.search(request).body();
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public SearchArticlesResponse search(SearchArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }
}
