/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.articles.requests.CreateArticleRequest;
import com.intercom.api.resources.articles.requests.DeleteArticleRequest;
import com.intercom.api.resources.articles.requests.FindArticleRequest;
import com.intercom.api.resources.articles.requests.ListArticlesRequest;
import com.intercom.api.resources.articles.requests.SearchArticlesRequest;
import com.intercom.api.resources.articles.requests.UpdateArticleRequest;
import com.intercom.api.resources.articles.types.Article;
import com.intercom.api.resources.articles.types.ArticleListItem;
import com.intercom.api.resources.articles.types.SearchArticlesResponse;
import com.intercom.api.types.DeletedArticleObject;
import java.util.concurrent.CompletableFuture;

public class AsyncArticlesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawArticlesClient rawClient;

    public AsyncArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawArticlesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawArticlesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public CompletableFuture<SyncPagingIterable<ArticleListItem>> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public CompletableFuture<SyncPagingIterable<ArticleListItem>> list(ListArticlesRequest request) {
        return this.rawClient.list(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all articles by making a GET request to <code>https://api.intercom.io/articles</code>.
     * <blockquote>
     * <p>📘 How are the articles sorted and ordered?</p>
     * <p>Articles will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.</p>
     * </blockquote>
     */
    public CompletableFuture<SyncPagingIterable<ArticleListItem>> list(
            ListArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new article by making a POST request to <code>https://api.intercom.io/articles</code>.
     */
    public CompletableFuture<Article> create(CreateArticleRequest request) {
        return this.rawClient.create(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new article by making a POST request to <code>https://api.intercom.io/articles</code>.
     */
    public CompletableFuture<Article> create(CreateArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single article by making a GET request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<Article> find(FindArticleRequest request) {
        return this.rawClient.find(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single article by making a GET request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<Article> find(FindArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update the details of a single article by making a PUT request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<Article> update(UpdateArticleRequest request) {
        return this.rawClient.update(request).thenApply(response -> response.body());
    }

    /**
     * You can update the details of a single article by making a PUT request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<Article> update(UpdateArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a single article by making a DELETE request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedArticleObject> delete(DeleteArticleRequest request) {
        return this.rawClient.delete(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a single article by making a DELETE request to <code>https://api.intercom.io/articles/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedArticleObject> delete(DeleteArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public CompletableFuture<SearchArticlesResponse> search() {
        return this.rawClient.search().thenApply(response -> response.body());
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public CompletableFuture<SearchArticlesResponse> search(SearchArticlesRequest request) {
        return this.rawClient.search(request).thenApply(response -> response.body());
    }

    /**
     * You can search for articles by making a GET request to <code>https://api.intercom.io/articles/search</code>.
     */
    public CompletableFuture<SearchArticlesResponse> search(
            SearchArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> response.body());
    }
}
