/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DeleteArticleRequest.Builder.class)
public final class DeleteArticleRequest {
    private final String articleId;

    private final Map<String, Object> additionalProperties;

    private DeleteArticleRequest(String articleId, Map<String, Object> additionalProperties) {
        this.articleId = articleId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the article which is given by Intercom.
     */
    @JsonProperty("article_id")
    public String getArticleId() {
        return articleId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DeleteArticleRequest && equalTo((DeleteArticleRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteArticleRequest other) {
        return articleId.equals(other.articleId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.articleId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ArticleIdStage builder() {
        return new Builder();
    }

    public interface ArticleIdStage {
        /**
         * The unique identifier for the article which is given by Intercom.
         */
        _FinalStage articleId(@NotNull String articleId);

        Builder from(DeleteArticleRequest other);
    }

    public interface _FinalStage {
        DeleteArticleRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ArticleIdStage, _FinalStage {
        private String articleId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DeleteArticleRequest other) {
            articleId(other.getArticleId());
            return this;
        }

        /**
         * The unique identifier for the article which is given by Intercom.<p>The unique identifier for the article which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("article_id")
        public _FinalStage articleId(@NotNull String articleId) {
            this.articleId = Objects.requireNonNull(articleId, "articleId must not be null");
            return this;
        }

        @java.lang.Override
        public DeleteArticleRequest build() {
            return new DeleteArticleRequest(articleId, additionalProperties);
        }
    }
}
