/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CursorPages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SearchArticlesResponse.Builder.class)
public final class SearchArticlesResponse {
    private final int totalCount;

    private final Data data;

    private final Optional<CursorPages> pages;

    private final Map<String, Object> additionalProperties;

    private SearchArticlesResponse(
            int totalCount, Data data, Optional<CursorPages> pages, Map<String, Object> additionalProperties) {
        this.totalCount = totalCount;
        this.data = data;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - <code>list</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    /**
     * @return The total number of Articles matching the search query
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @return An object containing the results of the search.
     */
    @JsonProperty("data")
    public Data getData() {
        return data;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SearchArticlesResponse && equalTo((SearchArticlesResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchArticlesResponse other) {
        return totalCount == other.totalCount && data.equals(other.data) && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.totalCount, this.data, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * The total number of Articles matching the search query
         */
        DataStage totalCount(int totalCount);

        Builder from(SearchArticlesResponse other);
    }

    public interface DataStage {
        /**
         * An object containing the results of the search.
         */
        _FinalStage data(@NotNull Data data);
    }

    public interface _FinalStage {
        SearchArticlesResponse build();

        _FinalStage pages(Optional<CursorPages> pages);

        _FinalStage pages(CursorPages pages);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, DataStage, _FinalStage {
        private int totalCount;

        private Data data;

        private Optional<CursorPages> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SearchArticlesResponse other) {
            totalCount(other.getTotalCount());
            data(other.getData());
            pages(other.getPages());
            return this;
        }

        /**
         * The total number of Articles matching the search query<p>The total number of Articles matching the search query</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public DataStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * An object containing the results of the search.<p>An object containing the results of the search.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("data")
        public _FinalStage data(@NotNull Data data) {
            this.data = Objects.requireNonNull(data, "data must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        @java.lang.Override
        public SearchArticlesResponse build() {
            return new SearchArticlesResponse(totalCount, data, pages, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Data.Builder.class)
    public static final class Data {
        private final Optional<List<Article>> articles;

        private final Optional<List<ArticleSearchHighlights>> highlights;

        private final Map<String, Object> additionalProperties;

        private Data(
                Optional<List<Article>> articles,
                Optional<List<ArticleSearchHighlights>> highlights,
                Map<String, Object> additionalProperties) {
            this.articles = articles;
            this.highlights = highlights;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return An array of Article objects
         */
        @JsonProperty("articles")
        public Optional<List<Article>> getArticles() {
            return articles;
        }

        /**
         * @return A corresponding array of highlighted Article content
         */
        @JsonProperty("highlights")
        public Optional<List<ArticleSearchHighlights>> getHighlights() {
            return highlights;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Data && equalTo((Data) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Data other) {
            return articles.equals(other.articles) && highlights.equals(other.highlights);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.articles, this.highlights);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<List<Article>> articles = Optional.empty();

            private Optional<List<ArticleSearchHighlights>> highlights = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Data other) {
                articles(other.getArticles());
                highlights(other.getHighlights());
                return this;
            }

            /**
             * <p>An array of Article objects</p>
             */
            @JsonSetter(value = "articles", nulls = Nulls.SKIP)
            public Builder articles(Optional<List<Article>> articles) {
                this.articles = articles;
                return this;
            }

            public Builder articles(List<Article> articles) {
                this.articles = Optional.ofNullable(articles);
                return this;
            }

            /**
             * <p>A corresponding array of highlighted Article content</p>
             */
            @JsonSetter(value = "highlights", nulls = Nulls.SKIP)
            public Builder highlights(Optional<List<ArticleSearchHighlights>> highlights) {
                this.highlights = highlights;
                return this;
            }

            public Builder highlights(List<ArticleSearchHighlights> highlights) {
                this.highlights = Optional.ofNullable(highlights);
                return this;
            }

            public Data build() {
                return new Data(articles, highlights, additionalProperties);
            }
        }
    }
}
