/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListCompaniesRequest.Builder.class)
public final class ListCompaniesRequest {
    private final Optional<Integer> page;

    private final Optional<Integer> perPage;

    private final Optional<String> order;

    private final Map<String, Object> additionalProperties;

    private ListCompaniesRequest(
            Optional<Integer> page,
            Optional<Integer> perPage,
            Optional<String> order,
            Map<String, Object> additionalProperties) {
        this.page = page;
        this.perPage = perPage;
        this.order = order;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The page of results to fetch. Defaults to first page
     */
    @JsonProperty("page")
    public Optional<Integer> getPage() {
        return page;
    }

    /**
     * @return How many results to return per page. Defaults to 15
     */
    @JsonProperty("per_page")
    public Optional<Integer> getPerPage() {
        return perPage;
    }

    /**
     * @return <code>asc</code> or <code>desc</code>. Return the companies in ascending or descending order. Defaults to desc
     */
    @JsonProperty("order")
    public Optional<String> getOrder() {
        return order;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListCompaniesRequest && equalTo((ListCompaniesRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCompaniesRequest other) {
        return page.equals(other.page) && perPage.equals(other.perPage) && order.equals(other.order);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.page, this.perPage, this.order);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();

        private Optional<Integer> perPage = Optional.empty();

        private Optional<String> order = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListCompaniesRequest other) {
            page(other.getPage());
            perPage(other.getPerPage());
            order(other.getOrder());
            return this;
        }

        /**
         * <p>The page of results to fetch. Defaults to first page</p>
         */
        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        /**
         * <p>How many results to return per page. Defaults to 15</p>
         */
        @JsonSetter(value = "per_page", nulls = Nulls.SKIP)
        public Builder perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        /**
         * <p><code>asc</code> or <code>desc</code>. Return the companies in ascending or descending order. Defaults to desc</p>
         */
        @JsonSetter(value = "order", nulls = Nulls.SKIP)
        public Builder order(Optional<String> order) {
            this.order = order;
            return this;
        }

        public Builder order(String order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        public ListCompaniesRequest build() {
            return new ListCompaniesRequest(page, perPage, order, additionalProperties);
        }
    }
}
