/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = MergeContactsRequest.Builder.class)
public final class MergeContactsRequest {
    private final String leadId;

    private final String contactId;

    private final Map<String, Object> additionalProperties;

    private MergeContactsRequest(String leadId, String contactId, Map<String, Object> additionalProperties) {
        this.leadId = leadId;
        this.contactId = contactId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact to merge away from. Must be a lead.
     */
    @JsonProperty("from")
    public String getLeadId() {
        return leadId;
    }

    /**
     * @return The unique identifier for the contact to merge into. Must be a user.
     */
    @JsonProperty("into")
    public String getContactId() {
        return contactId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof MergeContactsRequest && equalTo((MergeContactsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MergeContactsRequest other) {
        return leadId.equals(other.leadId) && contactId.equals(other.contactId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.leadId, this.contactId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LeadIdStage builder() {
        return new Builder();
    }

    public interface LeadIdStage {
        /**
         * The unique identifier for the contact to merge away from. Must be a lead.
         */
        ContactIdStage leadId(@NotNull String leadId);

        Builder from(MergeContactsRequest other);
    }

    public interface ContactIdStage {
        /**
         * The unique identifier for the contact to merge into. Must be a user.
         */
        _FinalStage contactId(@NotNull String contactId);
    }

    public interface _FinalStage {
        MergeContactsRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LeadIdStage, ContactIdStage, _FinalStage {
        private String leadId;

        private String contactId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(MergeContactsRequest other) {
            leadId(other.getLeadId());
            contactId(other.getContactId());
            return this;
        }

        /**
         * The unique identifier for the contact to merge away from. Must be a lead.<p>The unique identifier for the contact to merge away from. Must be a lead.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("from")
        public ContactIdStage leadId(@NotNull String leadId) {
            this.leadId = Objects.requireNonNull(leadId, "leadId must not be null");
            return this;
        }

        /**
         * The unique identifier for the contact to merge into. Must be a user.<p>The unique identifier for the contact to merge into. Must be a user.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("into")
        public _FinalStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @java.lang.Override
        public MergeContactsRequest build() {
            return new MergeContactsRequest(leadId, contactId, additionalProperties);
        }
    }
}
