/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.items;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.news.items.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.news.items.requests.FindNewsItemRequest;
import com.intercom.api.resources.news.items.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.news.types.NewsItem;
import com.intercom.api.types.DeletedObject;
import com.intercom.api.types.NewsItemRequest;
import com.intercom.api.types.PaginatedNewsItemResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncItemsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawItemsClient rawClient;

    public AsyncItemsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawItemsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawItemsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all news items
     */
    public CompletableFuture<PaginatedNewsItemResponse> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all news items
     */
    public CompletableFuture<PaginatedNewsItemResponse> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a news item
     */
    public CompletableFuture<NewsItem> create(NewsItemRequest request) {
        return this.rawClient.create(request).thenApply(response -> response.body());
    }

    /**
     * You can create a news item
     */
    public CompletableFuture<NewsItem> create(NewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single news item.
     */
    public CompletableFuture<NewsItem> find(FindNewsItemRequest request) {
        return this.rawClient.find(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single news item.
     */
    public CompletableFuture<NewsItem> find(FindNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<NewsItem> update(UpdateNewsItemRequest request) {
        return this.rawClient.update(request).thenApply(response -> response.body());
    }

    public CompletableFuture<NewsItem> update(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a single news item.
     */
    public CompletableFuture<DeletedObject> delete(DeleteNewsItemRequest request) {
        return this.rawClient.delete(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a single news item.
     */
    public CompletableFuture<DeletedObject> delete(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> response.body());
    }
}
