/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.notes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateContactNoteRequest.Builder.class)
public final class CreateContactNoteRequest {
    private final String contactId;

    private final String body;

    private final Optional<String> adminId;

    private final Map<String, Object> additionalProperties;

    private CreateContactNoteRequest(
            String contactId, String body, Optional<String> adminId, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.body = body;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of a given contact.
     */
    @JsonProperty("contact_id")
    public String getContactId() {
        return contactId;
    }

    /**
     * @return The text of the note.
     */
    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    /**
     * @return The unique identifier of a given admin.
     */
    @JsonProperty("admin_id")
    public Optional<String> getAdminId() {
        return adminId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateContactNoteRequest && equalTo((CreateContactNoteRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateContactNoteRequest other) {
        return contactId.equals(other.contactId) && body.equals(other.body) && adminId.equals(other.adminId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contactId, this.body, this.adminId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    public interface ContactIdStage {
        /**
         * The unique identifier of a given contact.
         */
        BodyStage contactId(@NotNull String contactId);

        Builder from(CreateContactNoteRequest other);
    }

    public interface BodyStage {
        /**
         * The text of the note.
         */
        _FinalStage body(@NotNull String body);
    }

    public interface _FinalStage {
        CreateContactNoteRequest build();

        /**
         * <p>The unique identifier of a given admin.</p>
         */
        _FinalStage adminId(Optional<String> adminId);

        _FinalStage adminId(String adminId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ContactIdStage, BodyStage, _FinalStage {
        private String contactId;

        private String body;

        private Optional<String> adminId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateContactNoteRequest other) {
            contactId(other.getContactId());
            body(other.getBody());
            adminId(other.getAdminId());
            return this;
        }

        /**
         * The unique identifier of a given contact.<p>The unique identifier of a given contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact_id")
        public BodyStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        /**
         * The text of the note.<p>The text of the note.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        /**
         * <p>The unique identifier of a given admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        /**
         * <p>The unique identifier of a given admin.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
        public _FinalStage adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        @java.lang.Override
        public CreateContactNoteRequest build() {
            return new CreateContactNoteRequest(contactId, body, adminId, additionalProperties);
        }
    }
}
