/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tags;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.tags.requests.DeleteTagRequest;
import com.intercom.api.resources.tags.requests.FindTagRequest;
import com.intercom.api.resources.tags.requests.TagContactRequest;
import com.intercom.api.resources.tags.requests.TagConversationRequest;
import com.intercom.api.resources.tags.requests.TagTicketRequest;
import com.intercom.api.resources.tags.requests.UntagContactRequest;
import com.intercom.api.resources.tags.requests.UntagConversationRequest;
import com.intercom.api.resources.tags.requests.UntagTicketRequest;
import com.intercom.api.resources.tags.types.Tag;
import com.intercom.api.resources.tags.types.TagsCreateRequestBody;
import com.intercom.api.types.TagList;
import java.util.concurrent.CompletableFuture;

public class AsyncTagsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTagsClient rawClient;

    public AsyncTagsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTagsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTagsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can tag a specific contact. This will return a tag object for the tag that was added to the contact.
     */
    public CompletableFuture<Tag> tagContact(TagContactRequest request) {
        return this.rawClient.tagContact(request).thenApply(response -> response.body());
    }

    /**
     * You can tag a specific contact. This will return a tag object for the tag that was added to the contact.
     */
    public CompletableFuture<Tag> tagContact(TagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can remove tag from a specific contact. This will return a tag object for the tag that was removed from the contact.
     */
    public CompletableFuture<Tag> untagContact(UntagContactRequest request) {
        return this.rawClient.untagContact(request).thenApply(response -> response.body());
    }

    /**
     * You can remove tag from a specific contact. This will return a tag object for the tag that was removed from the contact.
     */
    public CompletableFuture<Tag> untagContact(UntagContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can tag a specific conversation. This will return a tag object for the tag that was added to the conversation.
     */
    public CompletableFuture<Tag> tagConversation(TagConversationRequest request) {
        return this.rawClient.tagConversation(request).thenApply(response -> response.body());
    }

    /**
     * You can tag a specific conversation. This will return a tag object for the tag that was added to the conversation.
     */
    public CompletableFuture<Tag> tagConversation(TagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagConversation(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can remove tag from a specific conversation. This will return a tag object for the tag that was removed from the conversation.
     */
    public CompletableFuture<Tag> untagConversation(UntagConversationRequest request) {
        return this.rawClient.untagConversation(request).thenApply(response -> response.body());
    }

    /**
     * You can remove tag from a specific conversation. This will return a tag object for the tag that was removed from the conversation.
     */
    public CompletableFuture<Tag> untagConversation(UntagConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagConversation(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all tags for a given workspace.
     */
    public CompletableFuture<TagList> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all tags for a given workspace.
     */
    public CompletableFuture<TagList> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can use this endpoint to perform the following operations:
     * <p><strong>1. Create a new tag:</strong> You can create a new tag by passing in the tag name as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>2. Update an existing tag:</strong> You can update an existing tag by passing the id of the tag as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>3. Tag Companies:</strong> You can tag single company or a list of companies. You can tag a company by passing in the tag name and the company details as specified in &quot;Tag Company Request Payload&quot; described below. Also, if the tag doesn't exist then a new one will be created automatically.</p>
     * <p><strong>4. Untag Companies:</strong> You can untag a single company or a list of companies. You can untag a company by passing in the tag id and the company details as specified in &quot;Untag Company Request Payload&quot; described below.</p>
     * <p><strong>5. Tag Multiple Users:</strong> You can tag a list of users. You can tag the users by passing in the tag name and the user details as specified in &quot;Tag Users Request Payload&quot; described below.</p>
     * <p>Each operation will return a tag object.</p>
     */
    public CompletableFuture<Tag> create(TagsCreateRequestBody request) {
        return this.rawClient.create(request).thenApply(response -> response.body());
    }

    /**
     * You can use this endpoint to perform the following operations:
     * <p><strong>1. Create a new tag:</strong> You can create a new tag by passing in the tag name as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>2. Update an existing tag:</strong> You can update an existing tag by passing the id of the tag as specified in &quot;Create or Update Tag Request Payload&quot; described below.</p>
     * <p><strong>3. Tag Companies:</strong> You can tag single company or a list of companies. You can tag a company by passing in the tag name and the company details as specified in &quot;Tag Company Request Payload&quot; described below. Also, if the tag doesn't exist then a new one will be created automatically.</p>
     * <p><strong>4. Untag Companies:</strong> You can untag a single company or a list of companies. You can untag a company by passing in the tag id and the company details as specified in &quot;Untag Company Request Payload&quot; described below.</p>
     * <p><strong>5. Tag Multiple Users:</strong> You can tag a list of users. You can tag the users by passing in the tag name and the user details as specified in &quot;Tag Users Request Payload&quot; described below.</p>
     * <p>Each operation will return a tag object.</p>
     */
    public CompletableFuture<Tag> create(TagsCreateRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of tags that are on the workspace by their id.
     * This will return a tag object.
     */
    public CompletableFuture<Tag> find(FindTagRequest request) {
        return this.rawClient.find(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of tags that are on the workspace by their id.
     * This will return a tag object.
     */
    public CompletableFuture<Tag> find(FindTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete the details of tags that are on the workspace by passing in the id.
     */
    public CompletableFuture<Void> delete(DeleteTagRequest request) {
        return this.rawClient.delete(request).thenApply(response -> response.body());
    }

    /**
     * You can delete the details of tags that are on the workspace by passing in the id.
     */
    public CompletableFuture<Void> delete(DeleteTagRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can tag a specific ticket. This will return a tag object for the tag that was added to the ticket.
     */
    public CompletableFuture<Tag> tagTicket(TagTicketRequest request) {
        return this.rawClient.tagTicket(request).thenApply(response -> response.body());
    }

    /**
     * You can tag a specific ticket. This will return a tag object for the tag that was added to the ticket.
     */
    public CompletableFuture<Tag> tagTicket(TagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.tagTicket(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can remove tag from a specific ticket. This will return a tag object for the tag that was removed from the ticket.
     */
    public CompletableFuture<Tag> untagTicket(UntagTicketRequest request) {
        return this.rawClient.untagTicket(request).thenApply(response -> response.body());
    }

    /**
     * You can remove tag from a specific ticket. This will return a tag object for the tag that was removed from the ticket.
     */
    public CompletableFuture<Tag> untagTicket(UntagTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.untagTicket(request, requestOptions).thenApply(response -> response.body());
    }
}
