/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tags.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Tag.Builder.class)
public final class Tag {
    private final String id;

    private final String name;

    private final int appliedAt;

    private final Reference appliedBy;

    private final Map<String, Object> additionalProperties;

    private Tag(String id, String name, int appliedAt, Reference appliedBy, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.appliedAt = appliedAt;
        this.appliedBy = appliedBy;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return value is &quot;tag&quot;
     */
    @JsonProperty("type")
    public String getType() {
        return "tag";
    }

    /**
     * @return The id of the tag
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the tag
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The time when the tag was applied to the object
     */
    @JsonProperty("applied_at")
    public int getAppliedAt() {
        return appliedAt;
    }

    @JsonProperty("applied_by")
    public Reference getAppliedBy() {
        return appliedBy;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Tag && equalTo((Tag) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tag other) {
        return id.equals(other.id)
                && name.equals(other.name)
                && appliedAt == other.appliedAt
                && appliedBy.equals(other.appliedBy);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.appliedAt, this.appliedBy);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id of the tag
         */
        NameStage id(@NotNull String id);

        Builder from(Tag other);
    }

    public interface NameStage {
        /**
         * The name of the tag
         */
        AppliedAtStage name(@NotNull String name);
    }

    public interface AppliedAtStage {
        /**
         * The time when the tag was applied to the object
         */
        AppliedByStage appliedAt(int appliedAt);
    }

    public interface AppliedByStage {
        _FinalStage appliedBy(@NotNull Reference appliedBy);
    }

    public interface _FinalStage {
        Tag build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, NameStage, AppliedAtStage, AppliedByStage, _FinalStage {
        private String id;

        private String name;

        private int appliedAt;

        private Reference appliedBy;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Tag other) {
            id(other.getId());
            name(other.getName());
            appliedAt(other.getAppliedAt());
            appliedBy(other.getAppliedBy());
            return this;
        }

        /**
         * The id of the tag<p>The id of the tag</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The name of the tag<p>The name of the tag</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public AppliedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The time when the tag was applied to the object<p>The time when the tag was applied to the object</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("applied_at")
        public AppliedByStage appliedAt(int appliedAt) {
            this.appliedAt = appliedAt;
            return this;
        }

        @java.lang.Override
        @JsonSetter("applied_by")
        public _FinalStage appliedBy(@NotNull Reference appliedBy) {
            this.appliedBy = Objects.requireNonNull(appliedBy, "appliedBy must not be null");
            return this;
        }

        @java.lang.Override
        public Tag build() {
            return new Tag(id, name, appliedAt, appliedBy, additionalProperties);
        }
    }
}
