/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.teams.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindTeamRequest.Builder.class)
public final class FindTeamRequest {
    private final String teamId;

    private final Map<String, Object> additionalProperties;

    private FindTeamRequest(String teamId, Map<String, Object> additionalProperties) {
        this.teamId = teamId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of a given team.
     */
    @JsonProperty("team_id")
    public String getTeamId() {
        return teamId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindTeamRequest && equalTo((FindTeamRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindTeamRequest other) {
        return teamId.equals(other.teamId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.teamId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TeamIdStage builder() {
        return new Builder();
    }

    public interface TeamIdStage {
        /**
         * The unique identifier of a given team.
         */
        _FinalStage teamId(@NotNull String teamId);

        Builder from(FindTeamRequest other);
    }

    public interface _FinalStage {
        FindTeamRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TeamIdStage, _FinalStage {
        private String teamId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindTeamRequest other) {
            teamId(other.getTeamId());
            return this;
        }

        /**
         * The unique identifier of a given team.<p>The unique identifier of a given team.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("team_id")
        public _FinalStage teamId(@NotNull String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId must not be null");
            return this;
        }

        @java.lang.Override
        public FindTeamRequest build() {
            return new FindTeamRequest(teamId, additionalProperties);
        }
    }
}
