/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.teams.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.AdminPriorityLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Team.Builder.class)
public final class Team {
    private final String id;

    private final String name;

    private final List<Integer> adminIds;

    private final Optional<AdminPriorityLevel> adminPriorityLevel;

    private final Map<String, Object> additionalProperties;

    private Team(
            String id,
            String name,
            List<Integer> adminIds,
            Optional<AdminPriorityLevel> adminPriorityLevel,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.adminIds = adminIds;
        this.adminPriorityLevel = adminPriorityLevel;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Value is always &quot;team&quot;
     */
    @JsonProperty("type")
    public String getType() {
        return "team";
    }

    /**
     * @return The id of the team
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the team
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The list of admin IDs that are a part of the team.
     */
    @JsonProperty("admin_ids")
    public List<Integer> getAdminIds() {
        return adminIds;
    }

    @JsonProperty("admin_priority_level")
    public Optional<AdminPriorityLevel> getAdminPriorityLevel() {
        return adminPriorityLevel;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Team && equalTo((Team) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Team other) {
        return id.equals(other.id)
                && name.equals(other.name)
                && adminIds.equals(other.adminIds)
                && adminPriorityLevel.equals(other.adminPriorityLevel);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.adminIds, this.adminPriorityLevel);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id of the team
         */
        NameStage id(@NotNull String id);

        Builder from(Team other);
    }

    public interface NameStage {
        /**
         * The name of the team
         */
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        Team build();

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         */
        _FinalStage adminIds(List<Integer> adminIds);

        _FinalStage addAdminIds(Integer adminIds);

        _FinalStage addAllAdminIds(List<Integer> adminIds);

        _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel);

        _FinalStage adminPriorityLevel(AdminPriorityLevel adminPriorityLevel);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, NameStage, _FinalStage {
        private String id;

        private String name;

        private Optional<AdminPriorityLevel> adminPriorityLevel = Optional.empty();

        private List<Integer> adminIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Team other) {
            id(other.getId());
            name(other.getName());
            adminIds(other.getAdminIds());
            adminPriorityLevel(other.getAdminPriorityLevel());
            return this;
        }

        /**
         * The id of the team<p>The id of the team</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The name of the team<p>The name of the team</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage adminPriorityLevel(AdminPriorityLevel adminPriorityLevel) {
            this.adminPriorityLevel = Optional.ofNullable(adminPriorityLevel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "admin_priority_level", nulls = Nulls.SKIP)
        public _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel) {
            this.adminPriorityLevel = adminPriorityLevel;
            return this;
        }

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllAdminIds(List<Integer> adminIds) {
            this.adminIds.addAll(adminIds);
            return this;
        }

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAdminIds(Integer adminIds) {
            this.adminIds.add(adminIds);
            return this;
        }

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_ids", nulls = Nulls.SKIP)
        public _FinalStage adminIds(List<Integer> adminIds) {
            this.adminIds.clear();
            this.adminIds.addAll(adminIds);
            return this;
        }

        @java.lang.Override
        public Team build() {
            return new Team(id, name, adminIds, adminPriorityLevel, additionalProperties);
        }
    }
}
