/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateTicketRequest.Builder.class)
public final class UpdateTicketRequest {
    private final String ticketId;

    private final Optional<Map<String, Object>> ticketAttributes;

    private final Optional<State> state;

    private final Optional<Boolean> open;

    private final Optional<Boolean> isShared;

    private final Optional<Integer> snoozedUntil;

    private final Optional<Assignment> assignment;

    private final Map<String, Object> additionalProperties;

    private UpdateTicketRequest(
            String ticketId,
            Optional<Map<String, Object>> ticketAttributes,
            Optional<State> state,
            Optional<Boolean> open,
            Optional<Boolean> isShared,
            Optional<Integer> snoozedUntil,
            Optional<Assignment> assignment,
            Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.ticketAttributes = ticketAttributes;
        this.state = state;
        this.open = open;
        this.isShared = isShared;
        this.snoozedUntil = snoozedUntil;
        this.assignment = assignment;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the ticket which is given by Intercom
     */
    @JsonProperty("ticket_id")
    public String getTicketId() {
        return ticketId;
    }

    /**
     * @return The attributes set on the ticket.
     */
    @JsonProperty("ticket_attributes")
    public Optional<Map<String, Object>> getTicketAttributes() {
        return ticketAttributes;
    }

    /**
     * @return The state of the ticket.
     */
    @JsonProperty("state")
    public Optional<State> getState() {
        return state;
    }

    /**
     * @return Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.
     */
    @JsonProperty("open")
    public Optional<Boolean> getOpen() {
        return open;
    }

    /**
     * @return Specify whether the ticket is visible to users.
     */
    @JsonProperty("is_shared")
    public Optional<Boolean> getIsShared() {
        return isShared;
    }

    /**
     * @return The time you want the ticket to reopen.
     */
    @JsonProperty("snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return snoozedUntil;
    }

    @JsonProperty("assignment")
    public Optional<Assignment> getAssignment() {
        return assignment;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateTicketRequest && equalTo((UpdateTicketRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketRequest other) {
        return ticketId.equals(other.ticketId)
                && ticketAttributes.equals(other.ticketAttributes)
                && state.equals(other.state)
                && open.equals(other.open)
                && isShared.equals(other.isShared)
                && snoozedUntil.equals(other.snoozedUntil)
                && assignment.equals(other.assignment);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.ticketId,
                this.ticketAttributes,
                this.state,
                this.open,
                this.isShared,
                this.snoozedUntil,
                this.assignment);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    public interface TicketIdStage {
        /**
         * The unique identifier for the ticket which is given by Intercom
         */
        _FinalStage ticketId(@NotNull String ticketId);

        Builder from(UpdateTicketRequest other);
    }

    public interface _FinalStage {
        UpdateTicketRequest build();

        /**
         * <p>The attributes set on the ticket.</p>
         */
        _FinalStage ticketAttributes(Optional<Map<String, Object>> ticketAttributes);

        _FinalStage ticketAttributes(Map<String, Object> ticketAttributes);

        /**
         * <p>The state of the ticket.</p>
         */
        _FinalStage state(Optional<State> state);

        _FinalStage state(State state);

        /**
         * <p>Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.</p>
         */
        _FinalStage open(Optional<Boolean> open);

        _FinalStage open(Boolean open);

        /**
         * <p>Specify whether the ticket is visible to users.</p>
         */
        _FinalStage isShared(Optional<Boolean> isShared);

        _FinalStage isShared(Boolean isShared);

        /**
         * <p>The time you want the ticket to reopen.</p>
         */
        _FinalStage snoozedUntil(Optional<Integer> snoozedUntil);

        _FinalStage snoozedUntil(Integer snoozedUntil);

        _FinalStage assignment(Optional<Assignment> assignment);

        _FinalStage assignment(Assignment assignment);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TicketIdStage, _FinalStage {
        private String ticketId;

        private Optional<Assignment> assignment = Optional.empty();

        private Optional<Integer> snoozedUntil = Optional.empty();

        private Optional<Boolean> isShared = Optional.empty();

        private Optional<Boolean> open = Optional.empty();

        private Optional<State> state = Optional.empty();

        private Optional<Map<String, Object>> ticketAttributes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateTicketRequest other) {
            ticketId(other.getTicketId());
            ticketAttributes(other.getTicketAttributes());
            state(other.getState());
            open(other.getOpen());
            isShared(other.getIsShared());
            snoozedUntil(other.getSnoozedUntil());
            assignment(other.getAssignment());
            return this;
        }

        /**
         * The unique identifier for the ticket which is given by Intercom<p>The unique identifier for the ticket which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_id")
        public _FinalStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage assignment(Assignment assignment) {
            this.assignment = Optional.ofNullable(assignment);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "assignment", nulls = Nulls.SKIP)
        public _FinalStage assignment(Optional<Assignment> assignment) {
            this.assignment = assignment;
            return this;
        }

        /**
         * <p>The time you want the ticket to reopen.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        /**
         * <p>The time you want the ticket to reopen.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "snoozed_until", nulls = Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        /**
         * <p>Specify whether the ticket is visible to users.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        /**
         * <p>Specify whether the ticket is visible to users.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "is_shared", nulls = Nulls.SKIP)
        public _FinalStage isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        /**
         * <p>Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        /**
         * <p>Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "open", nulls = Nulls.SKIP)
        public _FinalStage open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        /**
         * <p>The state of the ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * <p>The state of the ticket.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public _FinalStage state(Optional<State> state) {
            this.state = state;
            return this;
        }

        /**
         * <p>The attributes set on the ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ticketAttributes(Map<String, Object> ticketAttributes) {
            this.ticketAttributes = Optional.ofNullable(ticketAttributes);
            return this;
        }

        /**
         * <p>The attributes set on the ticket.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ticket_attributes", nulls = Nulls.SKIP)
        public _FinalStage ticketAttributes(Optional<Map<String, Object>> ticketAttributes) {
            this.ticketAttributes = ticketAttributes;
            return this;
        }

        @java.lang.Override
        public UpdateTicketRequest build() {
            return new UpdateTicketRequest(
                    ticketId, ticketAttributes, state, open, isShared, snoozedUntil, assignment, additionalProperties);
        }
    }

    public static final class State {
        public static final State IN_PROGRESS = new State(Value.IN_PROGRESS, "in_progress");

        public static final State RESOLVED = new State(Value.RESOLVED, "resolved");

        public static final State WAITING_ON_CUSTOMER = new State(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case IN_PROGRESS:
                    return visitor.visitInProgress();
                case RESOLVED:
                    return visitor.visitResolved();
                case WAITING_ON_CUSTOMER:
                    return visitor.visitWaitingOnCustomer();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "in_progress":
                    return IN_PROGRESS;
                case "resolved":
                    return RESOLVED;
                case "waiting_on_customer":
                    return WAITING_ON_CUSTOMER;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            IN_PROGRESS,

            WAITING_ON_CUSTOMER,

            RESOLVED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitInProgress();

            T visitWaitingOnCustomer();

            T visitResolved();

            T visitUnknown(String unknownType);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Assignment.Builder.class)
    public static final class Assignment {
        private final Optional<String> adminId;

        private final Optional<String> assigneeId;

        private final Map<String, Object> additionalProperties;

        private Assignment(
                Optional<String> adminId, Optional<String> assigneeId, Map<String, Object> additionalProperties) {
            this.adminId = adminId;
            this.assigneeId = assigneeId;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The ID of the admin performing the action.
         */
        @JsonProperty("admin_id")
        public Optional<String> getAdminId() {
            return adminId;
        }

        /**
         * @return The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.
         */
        @JsonProperty("assignee_id")
        public Optional<String> getAssigneeId() {
            return assigneeId;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Assignment && equalTo((Assignment) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Assignment other) {
            return adminId.equals(other.adminId) && assigneeId.equals(other.assigneeId);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.adminId, this.assigneeId);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> adminId = Optional.empty();

            private Optional<String> assigneeId = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Assignment other) {
                adminId(other.getAdminId());
                assigneeId(other.getAssigneeId());
                return this;
            }

            /**
             * <p>The ID of the admin performing the action.</p>
             */
            @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
            public Builder adminId(Optional<String> adminId) {
                this.adminId = adminId;
                return this;
            }

            public Builder adminId(String adminId) {
                this.adminId = Optional.ofNullable(adminId);
                return this;
            }

            /**
             * <p>The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.</p>
             */
            @JsonSetter(value = "assignee_id", nulls = Nulls.SKIP)
            public Builder assigneeId(Optional<String> assigneeId) {
                this.assigneeId = assigneeId;
                return this;
            }

            public Builder assigneeId(String assigneeId) {
                this.assigneeId = Optional.ofNullable(assigneeId);
                return this;
            }

            public Assignment build() {
                return new Assignment(adminId, assigneeId, additionalProperties);
            }
        }
    }
}
