/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.PartAttachment;
import com.intercom.api.types.Reference;
import com.intercom.api.types.TicketPartAuthor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketPart.Builder.class)
public final class TicketPart {
    private final String id;

    private final String partType;

    private final Optional<String> body;

    private final Optional<PreviousTicketState> previousTicketState;

    private final TicketState ticketState;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<Reference> assignedTo;

    private final Optional<TicketPartAuthor> author;

    private final Optional<List<PartAttachment>> attachments;

    private final Optional<String> externalId;

    private final Optional<Boolean> redacted;

    private final Map<String, Object> additionalProperties;

    private TicketPart(
            String id,
            String partType,
            Optional<String> body,
            Optional<PreviousTicketState> previousTicketState,
            TicketState ticketState,
            int createdAt,
            Optional<Integer> updatedAt,
            Optional<Reference> assignedTo,
            Optional<TicketPartAuthor> author,
            Optional<List<PartAttachment>> attachments,
            Optional<String> externalId,
            Optional<Boolean> redacted,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.previousTicketState = previousTicketState;
        this.ticketState = ticketState;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always ticket_part
     */
    @JsonProperty("type")
    public String getType() {
        return "ticket_part";
    }

    /**
     * @return The id representing the ticket part.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The type of ticket part.
     */
    @JsonProperty("part_type")
    public String getPartType() {
        return partType;
    }

    /**
     * @return The message body, which may contain HTML.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The previous state of the ticket.
     */
    @JsonProperty("previous_ticket_state")
    public Optional<PreviousTicketState> getPreviousTicketState() {
        return previousTicketState;
    }

    /**
     * @return The state of the ticket.
     */
    @JsonProperty("ticket_state")
    public TicketState getTicketState() {
        return ticketState;
    }

    /**
     * @return The time the ticket part was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the ticket part was updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The id of the admin that was assigned the ticket by this ticket_part (null if there has been no change in assignment.)
     */
    @JsonProperty("assigned_to")
    public Optional<Reference> getAssignedTo() {
        return assignedTo;
    }

    @JsonProperty("author")
    public Optional<TicketPartAuthor> getAuthor() {
        return author;
    }

    /**
     * @return A list of attachments for the part.
     */
    @JsonProperty("attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return attachments;
    }

    /**
     * @return The external id of the ticket part
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return Whether or not the ticket part has been redacted.
     */
    @JsonProperty("redacted")
    public Optional<Boolean> getRedacted() {
        return redacted;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketPart && equalTo((TicketPart) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketPart other) {
        return id.equals(other.id)
                && partType.equals(other.partType)
                && body.equals(other.body)
                && previousTicketState.equals(other.previousTicketState)
                && ticketState.equals(other.ticketState)
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt)
                && assignedTo.equals(other.assignedTo)
                && author.equals(other.author)
                && attachments.equals(other.attachments)
                && externalId.equals(other.externalId)
                && redacted.equals(other.redacted);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.partType,
                this.body,
                this.previousTicketState,
                this.ticketState,
                this.createdAt,
                this.updatedAt,
                this.assignedTo,
                this.author,
                this.attachments,
                this.externalId,
                this.redacted);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the ticket part.
         */
        PartTypeStage id(@NotNull String id);

        Builder from(TicketPart other);
    }

    public interface PartTypeStage {
        /**
         * The type of ticket part.
         */
        TicketStateStage partType(@NotNull String partType);
    }

    public interface TicketStateStage {
        /**
         * The state of the ticket.
         */
        CreatedAtStage ticketState(@NotNull TicketState ticketState);
    }

    public interface CreatedAtStage {
        /**
         * The time the ticket part was created.
         */
        _FinalStage createdAt(int createdAt);
    }

    public interface _FinalStage {
        TicketPart build();

        /**
         * <p>The message body, which may contain HTML.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);

        /**
         * <p>The previous state of the ticket.</p>
         */
        _FinalStage previousTicketState(Optional<PreviousTicketState> previousTicketState);

        _FinalStage previousTicketState(PreviousTicketState previousTicketState);

        /**
         * <p>The last time the ticket part was updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        /**
         * <p>The id of the admin that was assigned the ticket by this ticket_part (null if there has been no change in assignment.)</p>
         */
        _FinalStage assignedTo(Optional<Reference> assignedTo);

        _FinalStage assignedTo(Reference assignedTo);

        _FinalStage author(Optional<TicketPartAuthor> author);

        _FinalStage author(TicketPartAuthor author);

        /**
         * <p>A list of attachments for the part.</p>
         */
        _FinalStage attachments(Optional<List<PartAttachment>> attachments);

        _FinalStage attachments(List<PartAttachment> attachments);

        /**
         * <p>The external id of the ticket part</p>
         */
        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);

        /**
         * <p>Whether or not the ticket part has been redacted.</p>
         */
        _FinalStage redacted(Optional<Boolean> redacted);

        _FinalStage redacted(Boolean redacted);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, PartTypeStage, TicketStateStage, CreatedAtStage, _FinalStage {
        private String id;

        private String partType;

        private TicketState ticketState;

        private int createdAt;

        private Optional<Boolean> redacted = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        private Optional<List<PartAttachment>> attachments = Optional.empty();

        private Optional<TicketPartAuthor> author = Optional.empty();

        private Optional<Reference> assignedTo = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<PreviousTicketState> previousTicketState = Optional.empty();

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TicketPart other) {
            id(other.getId());
            partType(other.getPartType());
            body(other.getBody());
            previousTicketState(other.getPreviousTicketState());
            ticketState(other.getTicketState());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            assignedTo(other.getAssignedTo());
            author(other.getAuthor());
            attachments(other.getAttachments());
            externalId(other.getExternalId());
            redacted(other.getRedacted());
            return this;
        }

        /**
         * The id representing the ticket part.<p>The id representing the ticket part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The type of ticket part.<p>The type of ticket part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("part_type")
        public TicketStateStage partType(@NotNull String partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        /**
         * The state of the ticket.<p>The state of the ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_state")
        public CreatedAtStage ticketState(@NotNull TicketState ticketState) {
            this.ticketState = Objects.requireNonNull(ticketState, "ticketState must not be null");
            return this;
        }

        /**
         * The time the ticket part was created.<p>The time the ticket part was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>Whether or not the ticket part has been redacted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        /**
         * <p>Whether or not the ticket part has been redacted.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "redacted", nulls = Nulls.SKIP)
        public _FinalStage redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        /**
         * <p>The external id of the ticket part</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The external id of the ticket part</p>
         */
        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "attachments", nulls = Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        @java.lang.Override
        public _FinalStage author(TicketPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "author", nulls = Nulls.SKIP)
        public _FinalStage author(Optional<TicketPartAuthor> author) {
            this.author = author;
            return this;
        }

        /**
         * <p>The id of the admin that was assigned the ticket by this ticket_part (null if there has been no change in assignment.)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        /**
         * <p>The id of the admin that was assigned the ticket by this ticket_part (null if there has been no change in assignment.)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "assigned_to", nulls = Nulls.SKIP)
        public _FinalStage assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        /**
         * <p>The last time the ticket part was updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The last time the ticket part was updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The previous state of the ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage previousTicketState(PreviousTicketState previousTicketState) {
            this.previousTicketState = Optional.ofNullable(previousTicketState);
            return this;
        }

        /**
         * <p>The previous state of the ticket.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "previous_ticket_state", nulls = Nulls.SKIP)
        public _FinalStage previousTicketState(Optional<PreviousTicketState> previousTicketState) {
            this.previousTicketState = previousTicketState;
            return this;
        }

        /**
         * <p>The message body, which may contain HTML.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The message body, which may contain HTML.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public TicketPart build() {
            return new TicketPart(
                    id,
                    partType,
                    body,
                    previousTicketState,
                    ticketState,
                    createdAt,
                    updatedAt,
                    assignedTo,
                    author,
                    attachments,
                    externalId,
                    redacted,
                    additionalProperties);
        }
    }

    public static final class PreviousTicketState {
        public static final PreviousTicketState IN_PROGRESS = new PreviousTicketState(Value.IN_PROGRESS, "in_progress");

        public static final PreviousTicketState SUBMITTED = new PreviousTicketState(Value.SUBMITTED, "submitted");

        public static final PreviousTicketState RESOLVED = new PreviousTicketState(Value.RESOLVED, "resolved");

        public static final PreviousTicketState WAITING_ON_CUSTOMER =
                new PreviousTicketState(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");

        private final Value value;

        private final String string;

        PreviousTicketState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof PreviousTicketState
                            && this.string.equals(((PreviousTicketState) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case IN_PROGRESS:
                    return visitor.visitInProgress();
                case SUBMITTED:
                    return visitor.visitSubmitted();
                case RESOLVED:
                    return visitor.visitResolved();
                case WAITING_ON_CUSTOMER:
                    return visitor.visitWaitingOnCustomer();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static PreviousTicketState valueOf(String value) {
            switch (value) {
                case "in_progress":
                    return IN_PROGRESS;
                case "submitted":
                    return SUBMITTED;
                case "resolved":
                    return RESOLVED;
                case "waiting_on_customer":
                    return WAITING_ON_CUSTOMER;
                default:
                    return new PreviousTicketState(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            SUBMITTED,

            IN_PROGRESS,

            WAITING_ON_CUSTOMER,

            RESOLVED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitSubmitted();

            T visitInProgress();

            T visitWaitingOnCustomer();

            T visitResolved();

            T visitUnknown(String unknownType);
        }
    }

    public static final class TicketState {
        public static final TicketState IN_PROGRESS = new TicketState(Value.IN_PROGRESS, "in_progress");

        public static final TicketState SUBMITTED = new TicketState(Value.SUBMITTED, "submitted");

        public static final TicketState RESOLVED = new TicketState(Value.RESOLVED, "resolved");

        public static final TicketState WAITING_ON_CUSTOMER =
                new TicketState(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");

        private final Value value;

        private final String string;

        TicketState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof TicketState && this.string.equals(((TicketState) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case IN_PROGRESS:
                    return visitor.visitInProgress();
                case SUBMITTED:
                    return visitor.visitSubmitted();
                case RESOLVED:
                    return visitor.visitResolved();
                case WAITING_ON_CUSTOMER:
                    return visitor.visitWaitingOnCustomer();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static TicketState valueOf(String value) {
            switch (value) {
                case "in_progress":
                    return IN_PROGRESS;
                case "submitted":
                    return SUBMITTED;
                case "resolved":
                    return RESOLVED;
                case "waiting_on_customer":
                    return WAITING_ON_CUSTOMER;
                default:
                    return new TicketState(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            SUBMITTED,

            IN_PROGRESS,

            WAITING_ON_CUSTOMER,

            RESOLVED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitSubmitted();

            T visitInProgress();

            T visitWaitingOnCustomer();

            T visitResolved();

            T visitUnknown(String unknownType);
        }
    }
}
