/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.TicketTypeAttributeList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketType.Builder.class)
public final class TicketType {
    private final String id;

    private final Category category;

    private final String name;

    private final String description;

    private final String icon;

    private final String workspaceId;

    private final TicketTypeAttributeList ticketTypeAttributes;

    private final boolean archived;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final Map<String, Object> additionalProperties;

    private TicketType(
            String id,
            Category category,
            String name,
            String description,
            String icon,
            String workspaceId,
            TicketTypeAttributeList ticketTypeAttributes,
            boolean archived,
            int createdAt,
            Optional<Integer> updatedAt,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.category = category;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.workspaceId = workspaceId;
        this.ticketTypeAttributes = ticketTypeAttributes;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>ticket_type</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "ticket_type";
    }

    /**
     * @return The id representing the ticket type.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return Category of the Ticket Type.
     */
    @JsonProperty("category")
    public Category getCategory() {
        return category;
    }

    /**
     * @return The name of the ticket type
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The description of the ticket type
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * @return The icon of the ticket type
     */
    @JsonProperty("icon")
    public String getIcon() {
        return icon;
    }

    /**
     * @return The id of the workspace that the ticket type belongs to.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    @JsonProperty("ticket_type_attributes")
    public TicketTypeAttributeList getTicketTypeAttributes() {
        return ticketTypeAttributes;
    }

    /**
     * @return Whether the ticket type is archived or not.
     */
    @JsonProperty("archived")
    public boolean getArchived() {
        return archived;
    }

    /**
     * @return The date and time the ticket type was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The date and time the ticket type was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketType && equalTo((TicketType) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketType other) {
        return id.equals(other.id)
                && category.equals(other.category)
                && name.equals(other.name)
                && description.equals(other.description)
                && icon.equals(other.icon)
                && workspaceId.equals(other.workspaceId)
                && ticketTypeAttributes.equals(other.ticketTypeAttributes)
                && archived == other.archived
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.category,
                this.name,
                this.description,
                this.icon,
                this.workspaceId,
                this.ticketTypeAttributes,
                this.archived,
                this.createdAt,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the ticket type.
         */
        CategoryStage id(@NotNull String id);

        Builder from(TicketType other);
    }

    public interface CategoryStage {
        /**
         * Category of the Ticket Type.
         */
        NameStage category(@NotNull Category category);
    }

    public interface NameStage {
        /**
         * The name of the ticket type
         */
        DescriptionStage name(@NotNull String name);
    }

    public interface DescriptionStage {
        /**
         * The description of the ticket type
         */
        IconStage description(@NotNull String description);
    }

    public interface IconStage {
        /**
         * The icon of the ticket type
         */
        WorkspaceIdStage icon(@NotNull String icon);
    }

    public interface WorkspaceIdStage {
        /**
         * The id of the workspace that the ticket type belongs to.
         */
        TicketTypeAttributesStage workspaceId(@NotNull String workspaceId);
    }

    public interface TicketTypeAttributesStage {
        ArchivedStage ticketTypeAttributes(@NotNull TicketTypeAttributeList ticketTypeAttributes);
    }

    public interface ArchivedStage {
        /**
         * Whether the ticket type is archived or not.
         */
        CreatedAtStage archived(boolean archived);
    }

    public interface CreatedAtStage {
        /**
         * The date and time the ticket type was created.
         */
        _FinalStage createdAt(int createdAt);
    }

    public interface _FinalStage {
        TicketType build();

        /**
         * <p>The date and time the ticket type was last updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    CategoryStage,
                    NameStage,
                    DescriptionStage,
                    IconStage,
                    WorkspaceIdStage,
                    TicketTypeAttributesStage,
                    ArchivedStage,
                    CreatedAtStage,
                    _FinalStage {
        private String id;

        private Category category;

        private String name;

        private String description;

        private String icon;

        private String workspaceId;

        private TicketTypeAttributeList ticketTypeAttributes;

        private boolean archived;

        private int createdAt;

        private Optional<Integer> updatedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TicketType other) {
            id(other.getId());
            category(other.getCategory());
            name(other.getName());
            description(other.getDescription());
            icon(other.getIcon());
            workspaceId(other.getWorkspaceId());
            ticketTypeAttributes(other.getTicketTypeAttributes());
            archived(other.getArchived());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * The id representing the ticket type.<p>The id representing the ticket type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public CategoryStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * Category of the Ticket Type.<p>Category of the Ticket Type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("category")
        public NameStage category(@NotNull Category category) {
            this.category = Objects.requireNonNull(category, "category must not be null");
            return this;
        }

        /**
         * The name of the ticket type<p>The name of the ticket type</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The description of the ticket type<p>The description of the ticket type</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        /**
         * The icon of the ticket type<p>The icon of the ticket type</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("icon")
        public WorkspaceIdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        /**
         * The id of the workspace that the ticket type belongs to.<p>The id of the workspace that the ticket type belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public TicketTypeAttributesStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("ticket_type_attributes")
        public ArchivedStage ticketTypeAttributes(@NotNull TicketTypeAttributeList ticketTypeAttributes) {
            this.ticketTypeAttributes =
                    Objects.requireNonNull(ticketTypeAttributes, "ticketTypeAttributes must not be null");
            return this;
        }

        /**
         * Whether the ticket type is archived or not.<p>Whether the ticket type is archived or not.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("archived")
        public CreatedAtStage archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        /**
         * The date and time the ticket type was created.<p>The date and time the ticket type was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The date and time the ticket type was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The date and time the ticket type was last updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @java.lang.Override
        public TicketType build() {
            return new TicketType(
                    id,
                    category,
                    name,
                    description,
                    icon,
                    workspaceId,
                    ticketTypeAttributes,
                    archived,
                    createdAt,
                    updatedAt,
                    additionalProperties);
        }
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");

        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");

        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");

        private final Value value;

        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Category && this.string.equals(((Category) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BACK_OFFICE:
                    return visitor.visitBackOffice();
                case CUSTOMER:
                    return visitor.visitCustomer();
                case TRACKER:
                    return visitor.visitTracker();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office":
                    return BACK_OFFICE;
                case "Customer":
                    return CUSTOMER;
                case "Tracker":
                    return TRACKER;
                default:
                    return new Category(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CUSTOMER,

            BACK_OFFICE,

            TRACKER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitCustomer();

            T visitBackOffice();

            T visitTracker();

            T visitUnknown(String unknownType);
        }
    }
}
