/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.companies;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.companies.requests.AttachContactToACompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.DeleteCompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.DetachContactFromACompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAllCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAttachedContactsRequest;
import com.intercom.api.resources.unstable.companies.requests.ListAttachedSegmentsForCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.RetrieveACompanyByIdRequest;
import com.intercom.api.resources.unstable.companies.requests.RetrieveCompanyRequest;
import com.intercom.api.resources.unstable.companies.requests.ScrollOverAllCompaniesRequest;
import com.intercom.api.resources.unstable.companies.requests.UpdateCompanyRequest;
import com.intercom.api.resources.unstable.companies.types.Company;
import com.intercom.api.resources.unstable.types.CompanyAttachedContacts;
import com.intercom.api.resources.unstable.types.CompanyAttachedSegments;
import com.intercom.api.resources.unstable.types.CompanyList;
import com.intercom.api.resources.unstable.types.CompanyScroll;
import com.intercom.api.resources.unstable.types.DeletedCompanyObject;
import java.util.Optional;

public class CompaniesClient {
    protected final ClientOptions clientOptions;

    private final RawCompaniesClient rawClient;

    public CompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCompaniesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCompaniesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a single company by passing in <code>company_id</code> or <code>name</code>.
     * <p><code>https://api.intercom.io/companies?name={name}</code></p>
     * <p><code>https://api.intercom.io/companies?company_id={company_id}</code></p>
     * <p>You can fetch all companies and filter by <code>segment_id</code> or <code>tag_id</code> as a query parameter.</p>
     * <p><code>https://api.intercom.io/companies?tag_id={tag_id}</code></p>
     * <p><code>https://api.intercom.io/companies?segment_id={segment_id}</code></p>
     */
    public CompanyList retrieveCompany() {
        return this.rawClient.retrieveCompany().body();
    }

    /**
     * You can fetch a single company by passing in <code>company_id</code> or <code>name</code>.
     * <p><code>https://api.intercom.io/companies?name={name}</code></p>
     * <p><code>https://api.intercom.io/companies?company_id={company_id}</code></p>
     * <p>You can fetch all companies and filter by <code>segment_id</code> or <code>tag_id</code> as a query parameter.</p>
     * <p><code>https://api.intercom.io/companies?tag_id={tag_id}</code></p>
     * <p><code>https://api.intercom.io/companies?segment_id={segment_id}</code></p>
     */
    public CompanyList retrieveCompany(RetrieveCompanyRequest request) {
        return this.rawClient.retrieveCompany(request).body();
    }

    /**
     * You can fetch a single company by passing in <code>company_id</code> or <code>name</code>.
     * <p><code>https://api.intercom.io/companies?name={name}</code></p>
     * <p><code>https://api.intercom.io/companies?company_id={company_id}</code></p>
     * <p>You can fetch all companies and filter by <code>segment_id</code> or <code>tag_id</code> as a query parameter.</p>
     * <p><code>https://api.intercom.io/companies?tag_id={tag_id}</code></p>
     * <p><code>https://api.intercom.io/companies?segment_id={segment_id}</code></p>
     */
    public CompanyList retrieveCompany(RetrieveCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveCompany(request, requestOptions).body();
    }

    /**
     * You can create or update a company.
     * <p>Companies will be only visible in Intercom when there is at least one associated user.</p>
     * <p>Companies are looked up via <code>company_id</code> in a <code>POST</code> request, if not found via <code>company_id</code>, the new company will be created, if found, that company will be updated.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Using <code>company_id</code>&quot; %}
     * You can set a unique <code>company_id</code> value when creating a company. However, it is not possible to update <code>company_id</code>. Be sure to set a unique value once upon creation of the company.
     * {% /admonition %}</p>
     */
    public Company createOrUpdateCompany(Object request) {
        return this.rawClient.createOrUpdateCompany(request).body();
    }

    /**
     * You can create or update a company.
     * <p>Companies will be only visible in Intercom when there is at least one associated user.</p>
     * <p>Companies are looked up via <code>company_id</code> in a <code>POST</code> request, if not found via <code>company_id</code>, the new company will be created, if found, that company will be updated.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Using <code>company_id</code>&quot; %}
     * You can set a unique <code>company_id</code> value when creating a company. However, it is not possible to update <code>company_id</code>. Be sure to set a unique value once upon creation of the company.
     * {% /admonition %}</p>
     */
    public Company createOrUpdateCompany(Object request, RequestOptions requestOptions) {
        return this.rawClient.createOrUpdateCompany(request, requestOptions).body();
    }

    /**
     * You can fetch a single company.
     */
    public Company retrieveACompanyById(RetrieveACompanyByIdRequest request) {
        return this.rawClient.retrieveACompanyById(request).body();
    }

    /**
     * You can fetch a single company.
     */
    public Company retrieveACompanyById(RetrieveACompanyByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveACompanyById(request, requestOptions).body();
    }

    /**
     * You can update a single company using the Intercom provisioned <code>id</code>.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Using <code>company_id</code>&quot; %}
     * When updating a company it is not possible to update <code>company_id</code>. This can only be set once upon creation of the company.
     * {% /admonition %}</p>
     */
    public Company updateCompany(UpdateCompanyRequest request) {
        return this.rawClient.updateCompany(request).body();
    }

    /**
     * You can update a single company using the Intercom provisioned <code>id</code>.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Using <code>company_id</code>&quot; %}
     * When updating a company it is not possible to update <code>company_id</code>. This can only be set once upon creation of the company.
     * {% /admonition %}</p>
     */
    public Company updateCompany(UpdateCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateCompany(request, requestOptions).body();
    }

    /**
     * You can delete a single company.
     */
    public DeletedCompanyObject deleteCompany(DeleteCompanyRequest request) {
        return this.rawClient.deleteCompany(request).body();
    }

    /**
     * You can delete a single company.
     */
    public DeletedCompanyObject deleteCompany(DeleteCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCompany(request, requestOptions).body();
    }

    /**
     * You can fetch a list of all contacts that belong to a company.
     */
    public CompanyAttachedContacts listAttachedContacts(ListAttachedContactsRequest request) {
        return this.rawClient.listAttachedContacts(request).body();
    }

    /**
     * You can fetch a list of all contacts that belong to a company.
     */
    public CompanyAttachedContacts listAttachedContacts(
            ListAttachedContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedContacts(request, requestOptions).body();
    }

    /**
     * You can fetch a list of all segments that belong to a company.
     */
    public CompanyAttachedSegments listAttachedSegmentsForCompanies(ListAttachedSegmentsForCompaniesRequest request) {
        return this.rawClient.listAttachedSegmentsForCompanies(request).body();
    }

    /**
     * You can fetch a list of all segments that belong to a company.
     */
    public CompanyAttachedSegments listAttachedSegmentsForCompanies(
            ListAttachedSegmentsForCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .listAttachedSegmentsForCompanies(request, requestOptions)
                .body();
    }

    /**
     * You can list companies. The company list is sorted by the <code>last_request_at</code> field and by default is ordered descending, most recently requested first.
     * <p>Note that the API does not include companies who have no associated users in list responses.</p>
     * <p>When using the Companies endpoint and the pages object to iterate through the returned companies, there is a limit of 10,000 Companies that can be returned. If you need to list or iterate on more than 10,000 Companies, please use the <a href="https://developers.intercom.com/reference#iterating-over-all-companies">Scroll API</a>.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public CompanyList listAllCompanies() {
        return this.rawClient.listAllCompanies().body();
    }

    /**
     * You can list companies. The company list is sorted by the <code>last_request_at</code> field and by default is ordered descending, most recently requested first.
     * <p>Note that the API does not include companies who have no associated users in list responses.</p>
     * <p>When using the Companies endpoint and the pages object to iterate through the returned companies, there is a limit of 10,000 Companies that can be returned. If you need to list or iterate on more than 10,000 Companies, please use the <a href="https://developers.intercom.com/reference#iterating-over-all-companies">Scroll API</a>.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public CompanyList listAllCompanies(ListAllCompaniesRequest request) {
        return this.rawClient.listAllCompanies(request).body();
    }

    /**
     * You can list companies. The company list is sorted by the <code>last_request_at</code> field and by default is ordered descending, most recently requested first.
     * <p>Note that the API does not include companies who have no associated users in list responses.</p>
     * <p>When using the Companies endpoint and the pages object to iterate through the returned companies, there is a limit of 10,000 Companies that can be returned. If you need to list or iterate on more than 10,000 Companies, please use the <a href="https://developers.intercom.com/reference#iterating-over-all-companies">Scroll API</a>.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public CompanyList listAllCompanies(ListAllCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAllCompanies(request, requestOptions).body();
    }

    /**
     * The <code>list all companies</code> functionality does not work well for huge datasets, and can result in errors and performance problems when paging deeply. The Scroll API provides an efficient mechanism for iterating over all companies in a dataset.
     * <ul>
     * <li>Each app can only have 1 scroll open at a time. You'll get an error message if you try to have more than one open per app.</li>
     * <li>If the scroll isn't used for 1 minute, it expires and calls with that scroll param will fail</li>
     * <li>If the end of the scroll is reached, &quot;companies&quot; will be empty and the scroll parameter will expire</li>
     * </ul>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Scroll Parameter&quot; %}
     * You can get the first page of companies by simply sending a GET request to the scroll endpoint.
     * For subsequent requests you will need to use the scroll parameter from the response.
     * {% /admonition %}
     * {% admonition type=&quot;danger&quot; name=&quot;Scroll network timeouts&quot; %}
     * Since scroll is often used on large datasets network errors such as timeouts can be encountered. When this occurs you will see a HTTP 500 error with the following message:
     * &quot;Request failed due to an internal network error. Please restart the scroll operation.&quot;
     * If this happens, you will need to restart your scroll query: It is not possible to continue from a specific point when using scroll.
     * {% /admonition %}</p>
     */
    public Optional<CompanyScroll> scrollOverAllCompanies() {
        return this.rawClient.scrollOverAllCompanies().body();
    }

    /**
     * The <code>list all companies</code> functionality does not work well for huge datasets, and can result in errors and performance problems when paging deeply. The Scroll API provides an efficient mechanism for iterating over all companies in a dataset.
     * <ul>
     * <li>Each app can only have 1 scroll open at a time. You'll get an error message if you try to have more than one open per app.</li>
     * <li>If the scroll isn't used for 1 minute, it expires and calls with that scroll param will fail</li>
     * <li>If the end of the scroll is reached, &quot;companies&quot; will be empty and the scroll parameter will expire</li>
     * </ul>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Scroll Parameter&quot; %}
     * You can get the first page of companies by simply sending a GET request to the scroll endpoint.
     * For subsequent requests you will need to use the scroll parameter from the response.
     * {% /admonition %}
     * {% admonition type=&quot;danger&quot; name=&quot;Scroll network timeouts&quot; %}
     * Since scroll is often used on large datasets network errors such as timeouts can be encountered. When this occurs you will see a HTTP 500 error with the following message:
     * &quot;Request failed due to an internal network error. Please restart the scroll operation.&quot;
     * If this happens, you will need to restart your scroll query: It is not possible to continue from a specific point when using scroll.
     * {% /admonition %}</p>
     */
    public Optional<CompanyScroll> scrollOverAllCompanies(ScrollOverAllCompaniesRequest request) {
        return this.rawClient.scrollOverAllCompanies(request).body();
    }

    /**
     * The <code>list all companies</code> functionality does not work well for huge datasets, and can result in errors and performance problems when paging deeply. The Scroll API provides an efficient mechanism for iterating over all companies in a dataset.
     * <ul>
     * <li>Each app can only have 1 scroll open at a time. You'll get an error message if you try to have more than one open per app.</li>
     * <li>If the scroll isn't used for 1 minute, it expires and calls with that scroll param will fail</li>
     * <li>If the end of the scroll is reached, &quot;companies&quot; will be empty and the scroll parameter will expire</li>
     * </ul>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Scroll Parameter&quot; %}
     * You can get the first page of companies by simply sending a GET request to the scroll endpoint.
     * For subsequent requests you will need to use the scroll parameter from the response.
     * {% /admonition %}
     * {% admonition type=&quot;danger&quot; name=&quot;Scroll network timeouts&quot; %}
     * Since scroll is often used on large datasets network errors such as timeouts can be encountered. When this occurs you will see a HTTP 500 error with the following message:
     * &quot;Request failed due to an internal network error. Please restart the scroll operation.&quot;
     * If this happens, you will need to restart your scroll query: It is not possible to continue from a specific point when using scroll.
     * {% /admonition %}</p>
     */
    public Optional<CompanyScroll> scrollOverAllCompanies(
            ScrollOverAllCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.scrollOverAllCompanies(request, requestOptions).body();
    }

    /**
     * You can attach a company to a single contact.
     */
    public Company attachContactToACompany(AttachContactToACompanyRequest request) {
        return this.rawClient.attachContactToACompany(request).body();
    }

    /**
     * You can attach a company to a single contact.
     */
    public Company attachContactToACompany(AttachContactToACompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContactToACompany(request, requestOptions).body();
    }

    /**
     * You can detach a company from a single contact.
     */
    public Company detachContactFromACompany(DetachContactFromACompanyRequest request) {
        return this.rawClient.detachContactFromACompany(request).body();
    }

    /**
     * You can detach a company from a single contact.
     */
    public Company detachContactFromACompany(DetachContactFromACompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContactFromACompany(request, requestOptions).body();
    }
}
