/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.contacts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ContactCompanies;
import com.intercom.api.resources.unstable.types.ContactLocation;
import com.intercom.api.resources.unstable.types.ContactNotes;
import com.intercom.api.resources.unstable.types.ContactSocialProfiles;
import com.intercom.api.resources.unstable.types.ContactTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShowContactByExternalIdResponse.Builder.class)
public final class ShowContactByExternalIdResponse implements IContact {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> externalId;

    private final Optional<String> workspaceId;

    private final Optional<String> role;

    private final Optional<String> email;

    private final Optional<String> emailDomain;

    private final Optional<String> phone;

    private final Optional<String> formattedPhone;

    private final Optional<String> name;

    private final Optional<Integer> ownerId;

    private final Optional<Boolean> hasHardBounced;

    private final Optional<Boolean> markedEmailAsSpam;

    private final Optional<Boolean> unsubscribedFromEmails;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<Integer> signedUpAt;

    private final Optional<Integer> lastSeenAt;

    private final Optional<Integer> lastRepliedAt;

    private final Optional<Integer> lastContactedAt;

    private final Optional<Integer> lastEmailOpenedAt;

    private final Optional<Integer> lastEmailClickedAt;

    private final Optional<String> languageOverride;

    private final Optional<String> browser;

    private final Optional<String> browserVersion;

    private final Optional<String> browserLanguage;

    private final Optional<String> os;

    private final Optional<String> androidAppName;

    private final Optional<String> androidAppVersion;

    private final Optional<String> androidDevice;

    private final Optional<String> androidOsVersion;

    private final Optional<String> androidSdkVersion;

    private final Optional<Integer> androidLastSeenAt;

    private final Optional<String> iosAppName;

    private final Optional<String> iosAppVersion;

    private final Optional<String> iosDevice;

    private final Optional<String> iosOsVersion;

    private final Optional<String> iosSdkVersion;

    private final Optional<Integer> iosLastSeenAt;

    private final Optional<Map<String, Object>> customAttributes;

    private final Optional<Avatar> avatar;

    private final Optional<ContactTags> tags;

    private final Optional<ContactNotes> notes;

    private final Optional<ContactCompanies> companies;

    private final Optional<ContactLocation> location;

    private final Optional<ContactSocialProfiles> socialProfiles;

    private final Optional<Boolean> enabledPushMessaging;

    private final Map<String, Object> additionalProperties;

    private ShowContactByExternalIdResponse(
            Optional<String> type,
            Optional<String> id,
            Optional<String> externalId,
            Optional<String> workspaceId,
            Optional<String> role,
            Optional<String> email,
            Optional<String> emailDomain,
            Optional<String> phone,
            Optional<String> formattedPhone,
            Optional<String> name,
            Optional<Integer> ownerId,
            Optional<Boolean> hasHardBounced,
            Optional<Boolean> markedEmailAsSpam,
            Optional<Boolean> unsubscribedFromEmails,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<Integer> signedUpAt,
            Optional<Integer> lastSeenAt,
            Optional<Integer> lastRepliedAt,
            Optional<Integer> lastContactedAt,
            Optional<Integer> lastEmailOpenedAt,
            Optional<Integer> lastEmailClickedAt,
            Optional<String> languageOverride,
            Optional<String> browser,
            Optional<String> browserVersion,
            Optional<String> browserLanguage,
            Optional<String> os,
            Optional<String> androidAppName,
            Optional<String> androidAppVersion,
            Optional<String> androidDevice,
            Optional<String> androidOsVersion,
            Optional<String> androidSdkVersion,
            Optional<Integer> androidLastSeenAt,
            Optional<String> iosAppName,
            Optional<String> iosAppVersion,
            Optional<String> iosDevice,
            Optional<String> iosOsVersion,
            Optional<String> iosSdkVersion,
            Optional<Integer> iosLastSeenAt,
            Optional<Map<String, Object>> customAttributes,
            Optional<Avatar> avatar,
            Optional<ContactTags> tags,
            Optional<ContactNotes> notes,
            Optional<ContactCompanies> companies,
            Optional<ContactLocation> location,
            Optional<ContactSocialProfiles> socialProfiles,
            Optional<Boolean> enabledPushMessaging,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.externalId = externalId;
        this.workspaceId = workspaceId;
        this.role = role;
        this.email = email;
        this.emailDomain = emailDomain;
        this.phone = phone;
        this.formattedPhone = formattedPhone;
        this.name = name;
        this.ownerId = ownerId;
        this.hasHardBounced = hasHardBounced;
        this.markedEmailAsSpam = markedEmailAsSpam;
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.signedUpAt = signedUpAt;
        this.lastSeenAt = lastSeenAt;
        this.lastRepliedAt = lastRepliedAt;
        this.lastContactedAt = lastContactedAt;
        this.lastEmailOpenedAt = lastEmailOpenedAt;
        this.lastEmailClickedAt = lastEmailClickedAt;
        this.languageOverride = languageOverride;
        this.browser = browser;
        this.browserVersion = browserVersion;
        this.browserLanguage = browserLanguage;
        this.os = os;
        this.androidAppName = androidAppName;
        this.androidAppVersion = androidAppVersion;
        this.androidDevice = androidDevice;
        this.androidOsVersion = androidOsVersion;
        this.androidSdkVersion = androidSdkVersion;
        this.androidLastSeenAt = androidLastSeenAt;
        this.iosAppName = iosAppName;
        this.iosAppVersion = iosAppVersion;
        this.iosDevice = iosDevice;
        this.iosOsVersion = iosOsVersion;
        this.iosSdkVersion = iosSdkVersion;
        this.iosLastSeenAt = iosLastSeenAt;
        this.customAttributes = customAttributes;
        this.avatar = avatar;
        this.tags = tags;
        this.notes = notes;
        this.companies = companies;
        this.location = location;
        this.socialProfiles = socialProfiles;
        this.enabledPushMessaging = enabledPushMessaging;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The unique identifier for the contact which is provided by the Client.
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return The id of the workspace which the contact belongs to.
     */
    @JsonProperty("workspace_id")
    public Optional<String> getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The role of the contact.
     */
    @JsonProperty("role")
    public Optional<String> getRole() {
        return role;
    }

    /**
     * @return The contact's email.
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The contact's email domain.
     */
    @JsonProperty("email_domain")
    public Optional<String> getEmailDomain() {
        return emailDomain;
    }

    /**
     * @return The contacts phone.
     */
    @JsonProperty("phone")
    public Optional<String> getPhone() {
        return phone;
    }

    /**
     * @return The contacts phone number normalized to the E164 format
     */
    @JsonProperty("formatted_phone")
    public Optional<String> getFormattedPhone() {
        return formattedPhone;
    }

    /**
     * @return The contacts name.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The id of an admin that has been assigned account ownership of the contact.
     */
    @JsonProperty("owner_id")
    public Optional<Integer> getOwnerId() {
        return ownerId;
    }

    /**
     * @return Whether the contact has had an email sent to them hard bounce.
     */
    @JsonProperty("has_hard_bounced")
    public Optional<Boolean> getHasHardBounced() {
        return hasHardBounced;
    }

    /**
     * @return Whether the contact has marked an email sent to them as spam.
     */
    @JsonProperty("marked_email_as_spam")
    public Optional<Boolean> getMarkedEmailAsSpam() {
        return markedEmailAsSpam;
    }

    /**
     * @return Whether the contact is unsubscribed from emails.
     */
    @JsonProperty("unsubscribed_from_emails")
    public Optional<Boolean> getUnsubscribedFromEmails() {
        return unsubscribedFromEmails;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return (UNIX timestamp) The time specified for when a contact signed up.
     */
    @JsonProperty("signed_up_at")
    public Optional<Integer> getSignedUpAt() {
        return signedUpAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).
     */
    @JsonProperty("last_seen_at")
    public Optional<Integer> getLastSeenAt() {
        return lastSeenAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact last messaged in.
     */
    @JsonProperty("last_replied_at")
    public Optional<Integer> getLastRepliedAt() {
        return lastRepliedAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last messaged.
     */
    @JsonProperty("last_contacted_at")
    public Optional<Integer> getLastContactedAt() {
        return lastContactedAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact last opened an email.
     */
    @JsonProperty("last_email_opened_at")
    public Optional<Integer> getLastEmailOpenedAt() {
        return lastEmailOpenedAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact last clicked a link in an email.
     */
    @JsonProperty("last_email_clicked_at")
    public Optional<Integer> getLastEmailClickedAt() {
        return lastEmailClickedAt;
    }

    /**
     * @return A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.
     */
    @JsonProperty("language_override")
    public Optional<String> getLanguageOverride() {
        return languageOverride;
    }

    /**
     * @return The name of the browser which the contact is using.
     */
    @JsonProperty("browser")
    public Optional<String> getBrowser() {
        return browser;
    }

    /**
     * @return The version of the browser which the contact is using.
     */
    @JsonProperty("browser_version")
    public Optional<String> getBrowserVersion() {
        return browserVersion;
    }

    /**
     * @return The language set by the browser which the contact is using.
     */
    @JsonProperty("browser_language")
    public Optional<String> getBrowserLanguage() {
        return browserLanguage;
    }

    /**
     * @return The operating system which the contact is using.
     */
    @JsonProperty("os")
    public Optional<String> getOs() {
        return os;
    }

    /**
     * @return The name of the Android app which the contact is using.
     */
    @JsonProperty("android_app_name")
    public Optional<String> getAndroidAppName() {
        return androidAppName;
    }

    /**
     * @return The version of the Android app which the contact is using.
     */
    @JsonProperty("android_app_version")
    public Optional<String> getAndroidAppVersion() {
        return androidAppVersion;
    }

    /**
     * @return The Android device which the contact is using.
     */
    @JsonProperty("android_device")
    public Optional<String> getAndroidDevice() {
        return androidDevice;
    }

    /**
     * @return The version of the Android OS which the contact is using.
     */
    @JsonProperty("android_os_version")
    public Optional<String> getAndroidOsVersion() {
        return androidOsVersion;
    }

    /**
     * @return The version of the Android SDK which the contact is using.
     */
    @JsonProperty("android_sdk_version")
    public Optional<String> getAndroidSdkVersion() {
        return androidSdkVersion;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last seen on an Android device.
     */
    @JsonProperty("android_last_seen_at")
    public Optional<Integer> getAndroidLastSeenAt() {
        return androidLastSeenAt;
    }

    /**
     * @return The name of the iOS app which the contact is using.
     */
    @JsonProperty("ios_app_name")
    public Optional<String> getIosAppName() {
        return iosAppName;
    }

    /**
     * @return The version of the iOS app which the contact is using.
     */
    @JsonProperty("ios_app_version")
    public Optional<String> getIosAppVersion() {
        return iosAppVersion;
    }

    /**
     * @return The iOS device which the contact is using.
     */
    @JsonProperty("ios_device")
    public Optional<String> getIosDevice() {
        return iosDevice;
    }

    /**
     * @return The version of iOS which the contact is using.
     */
    @JsonProperty("ios_os_version")
    public Optional<String> getIosOsVersion() {
        return iosOsVersion;
    }

    /**
     * @return The version of the iOS SDK which the contact is using.
     */
    @JsonProperty("ios_sdk_version")
    public Optional<String> getIosSdkVersion() {
        return iosSdkVersion;
    }

    /**
     * @return (UNIX timestamp) The last time the contact used the iOS app.
     */
    @JsonProperty("ios_last_seen_at")
    public Optional<Integer> getIosLastSeenAt() {
        return iosLastSeenAt;
    }

    /**
     * @return The custom attributes which are set for the contact.
     */
    @JsonProperty("custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return customAttributes;
    }

    @JsonProperty("avatar")
    public Optional<Avatar> getAvatar() {
        return avatar;
    }

    @JsonProperty("tags")
    public Optional<ContactTags> getTags() {
        return tags;
    }

    @JsonProperty("notes")
    public Optional<ContactNotes> getNotes() {
        return notes;
    }

    @JsonProperty("companies")
    public Optional<ContactCompanies> getCompanies() {
        return companies;
    }

    @JsonProperty("location")
    public Optional<ContactLocation> getLocation() {
        return location;
    }

    @JsonProperty("social_profiles")
    public Optional<ContactSocialProfiles> getSocialProfiles() {
        return socialProfiles;
    }

    /**
     * @return If the user has enabled push messaging.
     */
    @JsonProperty("enabled_push_messaging")
    public Optional<Boolean> getEnabledPushMessaging() {
        return enabledPushMessaging;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShowContactByExternalIdResponse && equalTo((ShowContactByExternalIdResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShowContactByExternalIdResponse other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && externalId.equals(other.externalId)
                && workspaceId.equals(other.workspaceId)
                && role.equals(other.role)
                && email.equals(other.email)
                && emailDomain.equals(other.emailDomain)
                && phone.equals(other.phone)
                && formattedPhone.equals(other.formattedPhone)
                && name.equals(other.name)
                && ownerId.equals(other.ownerId)
                && hasHardBounced.equals(other.hasHardBounced)
                && markedEmailAsSpam.equals(other.markedEmailAsSpam)
                && unsubscribedFromEmails.equals(other.unsubscribedFromEmails)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && signedUpAt.equals(other.signedUpAt)
                && lastSeenAt.equals(other.lastSeenAt)
                && lastRepliedAt.equals(other.lastRepliedAt)
                && lastContactedAt.equals(other.lastContactedAt)
                && lastEmailOpenedAt.equals(other.lastEmailOpenedAt)
                && lastEmailClickedAt.equals(other.lastEmailClickedAt)
                && languageOverride.equals(other.languageOverride)
                && browser.equals(other.browser)
                && browserVersion.equals(other.browserVersion)
                && browserLanguage.equals(other.browserLanguage)
                && os.equals(other.os)
                && androidAppName.equals(other.androidAppName)
                && androidAppVersion.equals(other.androidAppVersion)
                && androidDevice.equals(other.androidDevice)
                && androidOsVersion.equals(other.androidOsVersion)
                && androidSdkVersion.equals(other.androidSdkVersion)
                && androidLastSeenAt.equals(other.androidLastSeenAt)
                && iosAppName.equals(other.iosAppName)
                && iosAppVersion.equals(other.iosAppVersion)
                && iosDevice.equals(other.iosDevice)
                && iosOsVersion.equals(other.iosOsVersion)
                && iosSdkVersion.equals(other.iosSdkVersion)
                && iosLastSeenAt.equals(other.iosLastSeenAt)
                && customAttributes.equals(other.customAttributes)
                && avatar.equals(other.avatar)
                && tags.equals(other.tags)
                && notes.equals(other.notes)
                && companies.equals(other.companies)
                && location.equals(other.location)
                && socialProfiles.equals(other.socialProfiles)
                && enabledPushMessaging.equals(other.enabledPushMessaging);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.externalId,
                this.workspaceId,
                this.role,
                this.email,
                this.emailDomain,
                this.phone,
                this.formattedPhone,
                this.name,
                this.ownerId,
                this.hasHardBounced,
                this.markedEmailAsSpam,
                this.unsubscribedFromEmails,
                this.createdAt,
                this.updatedAt,
                this.signedUpAt,
                this.lastSeenAt,
                this.lastRepliedAt,
                this.lastContactedAt,
                this.lastEmailOpenedAt,
                this.lastEmailClickedAt,
                this.languageOverride,
                this.browser,
                this.browserVersion,
                this.browserLanguage,
                this.os,
                this.androidAppName,
                this.androidAppVersion,
                this.androidDevice,
                this.androidOsVersion,
                this.androidSdkVersion,
                this.androidLastSeenAt,
                this.iosAppName,
                this.iosAppVersion,
                this.iosDevice,
                this.iosOsVersion,
                this.iosSdkVersion,
                this.iosLastSeenAt,
                this.customAttributes,
                this.avatar,
                this.tags,
                this.notes,
                this.companies,
                this.location,
                this.socialProfiles,
                this.enabledPushMessaging);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        private Optional<String> workspaceId = Optional.empty();

        private Optional<String> role = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> emailDomain = Optional.empty();

        private Optional<String> phone = Optional.empty();

        private Optional<String> formattedPhone = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<Integer> ownerId = Optional.empty();

        private Optional<Boolean> hasHardBounced = Optional.empty();

        private Optional<Boolean> markedEmailAsSpam = Optional.empty();

        private Optional<Boolean> unsubscribedFromEmails = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<Integer> signedUpAt = Optional.empty();

        private Optional<Integer> lastSeenAt = Optional.empty();

        private Optional<Integer> lastRepliedAt = Optional.empty();

        private Optional<Integer> lastContactedAt = Optional.empty();

        private Optional<Integer> lastEmailOpenedAt = Optional.empty();

        private Optional<Integer> lastEmailClickedAt = Optional.empty();

        private Optional<String> languageOverride = Optional.empty();

        private Optional<String> browser = Optional.empty();

        private Optional<String> browserVersion = Optional.empty();

        private Optional<String> browserLanguage = Optional.empty();

        private Optional<String> os = Optional.empty();

        private Optional<String> androidAppName = Optional.empty();

        private Optional<String> androidAppVersion = Optional.empty();

        private Optional<String> androidDevice = Optional.empty();

        private Optional<String> androidOsVersion = Optional.empty();

        private Optional<String> androidSdkVersion = Optional.empty();

        private Optional<Integer> androidLastSeenAt = Optional.empty();

        private Optional<String> iosAppName = Optional.empty();

        private Optional<String> iosAppVersion = Optional.empty();

        private Optional<String> iosDevice = Optional.empty();

        private Optional<String> iosOsVersion = Optional.empty();

        private Optional<String> iosSdkVersion = Optional.empty();

        private Optional<Integer> iosLastSeenAt = Optional.empty();

        private Optional<Map<String, Object>> customAttributes = Optional.empty();

        private Optional<Avatar> avatar = Optional.empty();

        private Optional<ContactTags> tags = Optional.empty();

        private Optional<ContactNotes> notes = Optional.empty();

        private Optional<ContactCompanies> companies = Optional.empty();

        private Optional<ContactLocation> location = Optional.empty();

        private Optional<ContactSocialProfiles> socialProfiles = Optional.empty();

        private Optional<Boolean> enabledPushMessaging = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ShowContactByExternalIdResponse other) {
            type(other.getType());
            id(other.getId());
            externalId(other.getExternalId());
            workspaceId(other.getWorkspaceId());
            role(other.getRole());
            email(other.getEmail());
            emailDomain(other.getEmailDomain());
            phone(other.getPhone());
            formattedPhone(other.getFormattedPhone());
            name(other.getName());
            ownerId(other.getOwnerId());
            hasHardBounced(other.getHasHardBounced());
            markedEmailAsSpam(other.getMarkedEmailAsSpam());
            unsubscribedFromEmails(other.getUnsubscribedFromEmails());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            signedUpAt(other.getSignedUpAt());
            lastSeenAt(other.getLastSeenAt());
            lastRepliedAt(other.getLastRepliedAt());
            lastContactedAt(other.getLastContactedAt());
            lastEmailOpenedAt(other.getLastEmailOpenedAt());
            lastEmailClickedAt(other.getLastEmailClickedAt());
            languageOverride(other.getLanguageOverride());
            browser(other.getBrowser());
            browserVersion(other.getBrowserVersion());
            browserLanguage(other.getBrowserLanguage());
            os(other.getOs());
            androidAppName(other.getAndroidAppName());
            androidAppVersion(other.getAndroidAppVersion());
            androidDevice(other.getAndroidDevice());
            androidOsVersion(other.getAndroidOsVersion());
            androidSdkVersion(other.getAndroidSdkVersion());
            androidLastSeenAt(other.getAndroidLastSeenAt());
            iosAppName(other.getIosAppName());
            iosAppVersion(other.getIosAppVersion());
            iosDevice(other.getIosDevice());
            iosOsVersion(other.getIosOsVersion());
            iosSdkVersion(other.getIosSdkVersion());
            iosLastSeenAt(other.getIosLastSeenAt());
            customAttributes(other.getCustomAttributes());
            avatar(other.getAvatar());
            tags(other.getTags());
            notes(other.getNotes());
            companies(other.getCompanies());
            location(other.getLocation());
            socialProfiles(other.getSocialProfiles());
            enabledPushMessaging(other.getEnabledPushMessaging());
            return this;
        }

        /**
         * <p>The type of object.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         */
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The id of the workspace which the contact belongs to.</p>
         */
        @JsonSetter(value = "workspace_id", nulls = Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        /**
         * <p>The role of the contact.</p>
         */
        @JsonSetter(value = "role", nulls = Nulls.SKIP)
        public Builder role(Optional<String> role) {
            this.role = role;
            return this;
        }

        public Builder role(String role) {
            this.role = Optional.ofNullable(role);
            return this;
        }

        /**
         * <p>The contact's email.</p>
         */
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The contact's email domain.</p>
         */
        @JsonSetter(value = "email_domain", nulls = Nulls.SKIP)
        public Builder emailDomain(Optional<String> emailDomain) {
            this.emailDomain = emailDomain;
            return this;
        }

        public Builder emailDomain(String emailDomain) {
            this.emailDomain = Optional.ofNullable(emailDomain);
            return this;
        }

        /**
         * <p>The contacts phone.</p>
         */
        @JsonSetter(value = "phone", nulls = Nulls.SKIP)
        public Builder phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        /**
         * <p>The contacts phone number normalized to the E164 format</p>
         */
        @JsonSetter(value = "formatted_phone", nulls = Nulls.SKIP)
        public Builder formattedPhone(Optional<String> formattedPhone) {
            this.formattedPhone = formattedPhone;
            return this;
        }

        public Builder formattedPhone(String formattedPhone) {
            this.formattedPhone = Optional.ofNullable(formattedPhone);
            return this;
        }

        /**
         * <p>The contacts name.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The id of an admin that has been assigned account ownership of the contact.</p>
         */
        @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
        public Builder ownerId(Optional<Integer> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder ownerId(Integer ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        /**
         * <p>Whether the contact has had an email sent to them hard bounce.</p>
         */
        @JsonSetter(value = "has_hard_bounced", nulls = Nulls.SKIP)
        public Builder hasHardBounced(Optional<Boolean> hasHardBounced) {
            this.hasHardBounced = hasHardBounced;
            return this;
        }

        public Builder hasHardBounced(Boolean hasHardBounced) {
            this.hasHardBounced = Optional.ofNullable(hasHardBounced);
            return this;
        }

        /**
         * <p>Whether the contact has marked an email sent to them as spam.</p>
         */
        @JsonSetter(value = "marked_email_as_spam", nulls = Nulls.SKIP)
        public Builder markedEmailAsSpam(Optional<Boolean> markedEmailAsSpam) {
            this.markedEmailAsSpam = markedEmailAsSpam;
            return this;
        }

        public Builder markedEmailAsSpam(Boolean markedEmailAsSpam) {
            this.markedEmailAsSpam = Optional.ofNullable(markedEmailAsSpam);
            return this;
        }

        /**
         * <p>Whether the contact is unsubscribed from emails.</p>
         */
        @JsonSetter(value = "unsubscribed_from_emails", nulls = Nulls.SKIP)
        public Builder unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            return this;
        }

        public Builder unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
            this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time specified for when a contact signed up.</p>
         */
        @JsonSetter(value = "signed_up_at", nulls = Nulls.SKIP)
        public Builder signedUpAt(Optional<Integer> signedUpAt) {
            this.signedUpAt = signedUpAt;
            return this;
        }

        public Builder signedUpAt(Integer signedUpAt) {
            this.signedUpAt = Optional.ofNullable(signedUpAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).</p>
         */
        @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
        public Builder lastSeenAt(Optional<Integer> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public Builder lastSeenAt(Integer lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last messaged in.</p>
         */
        @JsonSetter(value = "last_replied_at", nulls = Nulls.SKIP)
        public Builder lastRepliedAt(Optional<Integer> lastRepliedAt) {
            this.lastRepliedAt = lastRepliedAt;
            return this;
        }

        public Builder lastRepliedAt(Integer lastRepliedAt) {
            this.lastRepliedAt = Optional.ofNullable(lastRepliedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last messaged.</p>
         */
        @JsonSetter(value = "last_contacted_at", nulls = Nulls.SKIP)
        public Builder lastContactedAt(Optional<Integer> lastContactedAt) {
            this.lastContactedAt = lastContactedAt;
            return this;
        }

        public Builder lastContactedAt(Integer lastContactedAt) {
            this.lastContactedAt = Optional.ofNullable(lastContactedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last opened an email.</p>
         */
        @JsonSetter(value = "last_email_opened_at", nulls = Nulls.SKIP)
        public Builder lastEmailOpenedAt(Optional<Integer> lastEmailOpenedAt) {
            this.lastEmailOpenedAt = lastEmailOpenedAt;
            return this;
        }

        public Builder lastEmailOpenedAt(Integer lastEmailOpenedAt) {
            this.lastEmailOpenedAt = Optional.ofNullable(lastEmailOpenedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last clicked a link in an email.</p>
         */
        @JsonSetter(value = "last_email_clicked_at", nulls = Nulls.SKIP)
        public Builder lastEmailClickedAt(Optional<Integer> lastEmailClickedAt) {
            this.lastEmailClickedAt = lastEmailClickedAt;
            return this;
        }

        public Builder lastEmailClickedAt(Integer lastEmailClickedAt) {
            this.lastEmailClickedAt = Optional.ofNullable(lastEmailClickedAt);
            return this;
        }

        /**
         * <p>A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.</p>
         */
        @JsonSetter(value = "language_override", nulls = Nulls.SKIP)
        public Builder languageOverride(Optional<String> languageOverride) {
            this.languageOverride = languageOverride;
            return this;
        }

        public Builder languageOverride(String languageOverride) {
            this.languageOverride = Optional.ofNullable(languageOverride);
            return this;
        }

        /**
         * <p>The name of the browser which the contact is using.</p>
         */
        @JsonSetter(value = "browser", nulls = Nulls.SKIP)
        public Builder browser(Optional<String> browser) {
            this.browser = browser;
            return this;
        }

        public Builder browser(String browser) {
            this.browser = Optional.ofNullable(browser);
            return this;
        }

        /**
         * <p>The version of the browser which the contact is using.</p>
         */
        @JsonSetter(value = "browser_version", nulls = Nulls.SKIP)
        public Builder browserVersion(Optional<String> browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        public Builder browserVersion(String browserVersion) {
            this.browserVersion = Optional.ofNullable(browserVersion);
            return this;
        }

        /**
         * <p>The language set by the browser which the contact is using.</p>
         */
        @JsonSetter(value = "browser_language", nulls = Nulls.SKIP)
        public Builder browserLanguage(Optional<String> browserLanguage) {
            this.browserLanguage = browserLanguage;
            return this;
        }

        public Builder browserLanguage(String browserLanguage) {
            this.browserLanguage = Optional.ofNullable(browserLanguage);
            return this;
        }

        /**
         * <p>The operating system which the contact is using.</p>
         */
        @JsonSetter(value = "os", nulls = Nulls.SKIP)
        public Builder os(Optional<String> os) {
            this.os = os;
            return this;
        }

        public Builder os(String os) {
            this.os = Optional.ofNullable(os);
            return this;
        }

        /**
         * <p>The name of the Android app which the contact is using.</p>
         */
        @JsonSetter(value = "android_app_name", nulls = Nulls.SKIP)
        public Builder androidAppName(Optional<String> androidAppName) {
            this.androidAppName = androidAppName;
            return this;
        }

        public Builder androidAppName(String androidAppName) {
            this.androidAppName = Optional.ofNullable(androidAppName);
            return this;
        }

        /**
         * <p>The version of the Android app which the contact is using.</p>
         */
        @JsonSetter(value = "android_app_version", nulls = Nulls.SKIP)
        public Builder androidAppVersion(Optional<String> androidAppVersion) {
            this.androidAppVersion = androidAppVersion;
            return this;
        }

        public Builder androidAppVersion(String androidAppVersion) {
            this.androidAppVersion = Optional.ofNullable(androidAppVersion);
            return this;
        }

        /**
         * <p>The Android device which the contact is using.</p>
         */
        @JsonSetter(value = "android_device", nulls = Nulls.SKIP)
        public Builder androidDevice(Optional<String> androidDevice) {
            this.androidDevice = androidDevice;
            return this;
        }

        public Builder androidDevice(String androidDevice) {
            this.androidDevice = Optional.ofNullable(androidDevice);
            return this;
        }

        /**
         * <p>The version of the Android OS which the contact is using.</p>
         */
        @JsonSetter(value = "android_os_version", nulls = Nulls.SKIP)
        public Builder androidOsVersion(Optional<String> androidOsVersion) {
            this.androidOsVersion = androidOsVersion;
            return this;
        }

        public Builder androidOsVersion(String androidOsVersion) {
            this.androidOsVersion = Optional.ofNullable(androidOsVersion);
            return this;
        }

        /**
         * <p>The version of the Android SDK which the contact is using.</p>
         */
        @JsonSetter(value = "android_sdk_version", nulls = Nulls.SKIP)
        public Builder androidSdkVersion(Optional<String> androidSdkVersion) {
            this.androidSdkVersion = androidSdkVersion;
            return this;
        }

        public Builder androidSdkVersion(String androidSdkVersion) {
            this.androidSdkVersion = Optional.ofNullable(androidSdkVersion);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen on an Android device.</p>
         */
        @JsonSetter(value = "android_last_seen_at", nulls = Nulls.SKIP)
        public Builder androidLastSeenAt(Optional<Integer> androidLastSeenAt) {
            this.androidLastSeenAt = androidLastSeenAt;
            return this;
        }

        public Builder androidLastSeenAt(Integer androidLastSeenAt) {
            this.androidLastSeenAt = Optional.ofNullable(androidLastSeenAt);
            return this;
        }

        /**
         * <p>The name of the iOS app which the contact is using.</p>
         */
        @JsonSetter(value = "ios_app_name", nulls = Nulls.SKIP)
        public Builder iosAppName(Optional<String> iosAppName) {
            this.iosAppName = iosAppName;
            return this;
        }

        public Builder iosAppName(String iosAppName) {
            this.iosAppName = Optional.ofNullable(iosAppName);
            return this;
        }

        /**
         * <p>The version of the iOS app which the contact is using.</p>
         */
        @JsonSetter(value = "ios_app_version", nulls = Nulls.SKIP)
        public Builder iosAppVersion(Optional<String> iosAppVersion) {
            this.iosAppVersion = iosAppVersion;
            return this;
        }

        public Builder iosAppVersion(String iosAppVersion) {
            this.iosAppVersion = Optional.ofNullable(iosAppVersion);
            return this;
        }

        /**
         * <p>The iOS device which the contact is using.</p>
         */
        @JsonSetter(value = "ios_device", nulls = Nulls.SKIP)
        public Builder iosDevice(Optional<String> iosDevice) {
            this.iosDevice = iosDevice;
            return this;
        }

        public Builder iosDevice(String iosDevice) {
            this.iosDevice = Optional.ofNullable(iosDevice);
            return this;
        }

        /**
         * <p>The version of iOS which the contact is using.</p>
         */
        @JsonSetter(value = "ios_os_version", nulls = Nulls.SKIP)
        public Builder iosOsVersion(Optional<String> iosOsVersion) {
            this.iosOsVersion = iosOsVersion;
            return this;
        }

        public Builder iosOsVersion(String iosOsVersion) {
            this.iosOsVersion = Optional.ofNullable(iosOsVersion);
            return this;
        }

        /**
         * <p>The version of the iOS SDK which the contact is using.</p>
         */
        @JsonSetter(value = "ios_sdk_version", nulls = Nulls.SKIP)
        public Builder iosSdkVersion(Optional<String> iosSdkVersion) {
            this.iosSdkVersion = iosSdkVersion;
            return this;
        }

        public Builder iosSdkVersion(String iosSdkVersion) {
            this.iosSdkVersion = Optional.ofNullable(iosSdkVersion);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The last time the contact used the iOS app.</p>
         */
        @JsonSetter(value = "ios_last_seen_at", nulls = Nulls.SKIP)
        public Builder iosLastSeenAt(Optional<Integer> iosLastSeenAt) {
            this.iosLastSeenAt = iosLastSeenAt;
            return this;
        }

        public Builder iosLastSeenAt(Integer iosLastSeenAt) {
            this.iosLastSeenAt = Optional.ofNullable(iosLastSeenAt);
            return this;
        }

        /**
         * <p>The custom attributes which are set for the contact.</p>
         */
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public Builder customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public Builder avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @JsonSetter(value = "tags", nulls = Nulls.SKIP)
        public Builder tags(Optional<ContactTags> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(ContactTags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @JsonSetter(value = "notes", nulls = Nulls.SKIP)
        public Builder notes(Optional<ContactNotes> notes) {
            this.notes = notes;
            return this;
        }

        public Builder notes(ContactNotes notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        @JsonSetter(value = "companies", nulls = Nulls.SKIP)
        public Builder companies(Optional<ContactCompanies> companies) {
            this.companies = companies;
            return this;
        }

        public Builder companies(ContactCompanies companies) {
            this.companies = Optional.ofNullable(companies);
            return this;
        }

        @JsonSetter(value = "location", nulls = Nulls.SKIP)
        public Builder location(Optional<ContactLocation> location) {
            this.location = location;
            return this;
        }

        public Builder location(ContactLocation location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @JsonSetter(value = "social_profiles", nulls = Nulls.SKIP)
        public Builder socialProfiles(Optional<ContactSocialProfiles> socialProfiles) {
            this.socialProfiles = socialProfiles;
            return this;
        }

        public Builder socialProfiles(ContactSocialProfiles socialProfiles) {
            this.socialProfiles = Optional.ofNullable(socialProfiles);
            return this;
        }

        /**
         * <p>If the user has enabled push messaging.</p>
         */
        @JsonSetter(value = "enabled_push_messaging", nulls = Nulls.SKIP)
        public Builder enabledPushMessaging(Optional<Boolean> enabledPushMessaging) {
            this.enabledPushMessaging = enabledPushMessaging;
            return this;
        }

        public Builder enabledPushMessaging(Boolean enabledPushMessaging) {
            this.enabledPushMessaging = Optional.ofNullable(enabledPushMessaging);
            return this;
        }

        public ShowContactByExternalIdResponse build() {
            return new ShowContactByExternalIdResponse(
                    type,
                    id,
                    externalId,
                    workspaceId,
                    role,
                    email,
                    emailDomain,
                    phone,
                    formattedPhone,
                    name,
                    ownerId,
                    hasHardBounced,
                    markedEmailAsSpam,
                    unsubscribedFromEmails,
                    createdAt,
                    updatedAt,
                    signedUpAt,
                    lastSeenAt,
                    lastRepliedAt,
                    lastContactedAt,
                    lastEmailOpenedAt,
                    lastEmailClickedAt,
                    languageOverride,
                    browser,
                    browserVersion,
                    browserLanguage,
                    os,
                    androidAppName,
                    androidAppVersion,
                    androidDevice,
                    androidOsVersion,
                    androidSdkVersion,
                    androidLastSeenAt,
                    iosAppName,
                    iosAppVersion,
                    iosDevice,
                    iosOsVersion,
                    iosSdkVersion,
                    iosLastSeenAt,
                    customAttributes,
                    avatar,
                    tags,
                    notes,
                    companies,
                    location,
                    socialProfiles,
                    enabledPushMessaging,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Avatar.Builder.class)
    public static final class Avatar {
        private final Optional<String> type;

        private final Optional<String> imageUrl;

        private final Map<String, Object> additionalProperties;

        private Avatar(Optional<String> type, Optional<String> imageUrl, Map<String, Object> additionalProperties) {
            this.type = type;
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return An image URL containing the avatar of a contact.
         */
        @JsonProperty("image_url")
        public Optional<String> getImageUrl() {
            return imageUrl;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Avatar && equalTo((Avatar) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return type.equals(other.type) && imageUrl.equals(other.imageUrl);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.imageUrl);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> imageUrl = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Avatar other) {
                type(other.getType());
                imageUrl(other.getImageUrl());
                return this;
            }

            /**
             * <p>The type of object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>An image URL containing the avatar of a contact.</p>
             */
            @JsonSetter(value = "image_url", nulls = Nulls.SKIP)
            public Builder imageUrl(Optional<String> imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = Optional.ofNullable(imageUrl);
                return this;
            }

            public Avatar build() {
                return new Avatar(type, imageUrl, additionalProperties);
            }
        }
    }
}
