/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateConversationRequest.Builder.class)
public final class CreateConversationRequest {
    private final From from;

    private final String body;

    private final Optional<Integer> createdAt;

    private final Map<String, Object> additionalProperties;

    private CreateConversationRequest(
            From from, String body, Optional<Integer> createdAt, Map<String, Object> additionalProperties) {
        this.from = from;
        this.body = body;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("from")
    public From getFrom() {
        return from;
    }

    /**
     * @return The content of the message. HTML is not supported.
     */
    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    /**
     * @return The time the conversation was created as a UTC Unix timestamp. If not provided, the current time will be used. This field is only recommneded for migrating past conversations from another source into Intercom.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateConversationRequest && equalTo((CreateConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateConversationRequest other) {
        return from.equals(other.from) && body.equals(other.body) && createdAt.equals(other.createdAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.from, this.body, this.createdAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FromStage builder() {
        return new Builder();
    }

    public interface FromStage {
        BodyStage from(@NotNull From from);

        Builder from(CreateConversationRequest other);
    }

    public interface BodyStage {
        /**
         * The content of the message. HTML is not supported.
         */
        _FinalStage body(@NotNull String body);
    }

    public interface _FinalStage {
        CreateConversationRequest build();

        /**
         * <p>The time the conversation was created as a UTC Unix timestamp. If not provided, the current time will be used. This field is only recommneded for migrating past conversations from another source into Intercom.</p>
         */
        _FinalStage createdAt(Optional<Integer> createdAt);

        _FinalStage createdAt(Integer createdAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements FromStage, BodyStage, _FinalStage {
        private From from;

        private String body;

        private Optional<Integer> createdAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateConversationRequest other) {
            from(other.getFrom());
            body(other.getBody());
            createdAt(other.getCreatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("from")
        public BodyStage from(@NotNull From from) {
            this.from = Objects.requireNonNull(from, "from must not be null");
            return this;
        }

        /**
         * The content of the message. HTML is not supported.<p>The content of the message. HTML is not supported.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        /**
         * <p>The time the conversation was created as a UTC Unix timestamp. If not provided, the current time will be used. This field is only recommneded for migrating past conversations from another source into Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time the conversation was created as a UTC Unix timestamp. If not provided, the current time will be used. This field is only recommneded for migrating past conversations from another source into Intercom.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @java.lang.Override
        public CreateConversationRequest build() {
            return new CreateConversationRequest(from, body, createdAt, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = From.Builder.class)
    public static final class From {
        private final Type type;

        private final String id;

        private final Map<String, Object> additionalProperties;

        private From(Type type, String id, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The role associated to the contact - user or lead.
         */
        @JsonProperty("type")
        public Type getType() {
            return type;
        }

        /**
         * @return The identifier for the contact which is given by Intercom.
         */
        @JsonProperty("id")
        public String getId() {
            return id;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof From && equalTo((From) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(From other) {
            return type.equals(other.type) && id.equals(other.id);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.id);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static TypeStage builder() {
            return new Builder();
        }

        public interface TypeStage {
            /**
             * The role associated to the contact - user or lead.
             */
            IdStage type(@NotNull Type type);

            Builder from(From other);
        }

        public interface IdStage {
            /**
             * The identifier for the contact which is given by Intercom.
             */
            _FinalStage id(@NotNull String id);
        }

        public interface _FinalStage {
            From build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements TypeStage, IdStage, _FinalStage {
            private Type type;

            private String id;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(From other) {
                type(other.getType());
                id(other.getId());
                return this;
            }

            /**
             * The role associated to the contact - user or lead.<p>The role associated to the contact - user or lead.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("type")
            public IdStage type(@NotNull Type type) {
                this.type = Objects.requireNonNull(type, "type must not be null");
                return this;
            }

            /**
             * The identifier for the contact which is given by Intercom.<p>The identifier for the contact which is given by Intercom.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("id")
            public _FinalStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            @java.lang.Override
            public From build() {
                return new From(type, id, additionalProperties);
            }
        }

        public static final class Type {
            public static final Type USER = new Type(Value.USER, "user");

            public static final Type CONTACT = new Type(Value.CONTACT, "contact");

            public static final Type LEAD = new Type(Value.LEAD, "lead");

            private final Value value;

            private final String string;

            Type(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return value;
            }

            @java.lang.Override
            @JsonValue
            public String toString() {
                return this.string;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
            }

            @java.lang.Override
            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (value) {
                    case USER:
                        return visitor.visitUser();
                    case CONTACT:
                        return visitor.visitContact();
                    case LEAD:
                        return visitor.visitLead();
                    case UNKNOWN:
                    default:
                        return visitor.visitUnknown(string);
                }
            }

            @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
            public static Type valueOf(String value) {
                switch (value) {
                    case "user":
                        return USER;
                    case "contact":
                        return CONTACT;
                    case "lead":
                        return LEAD;
                    default:
                        return new Type(Value.UNKNOWN, value);
                }
            }

            public enum Value {
                LEAD,

                USER,

                CONTACT,

                UNKNOWN
            }

            public interface Visitor<T> {
                T visitLead();

                T visitUser();

                T visitContact();

                T visitUnknown(String unknownType);
            }
        }
    }
}
